/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.behavior;

import android.animation.ValueAnimator;
import android.view.View;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.xuexiang.xui.widget.behavior.AnimateHelper;

public class TranslateAnimateHelper
implements AnimateHelper {
    public View mTarget;
    public float mStartY;
    public int mCurrentState = 1;
    public int mMode = MODE_TITLE;
    public static int MODE_TITLE = 233;
    public static int MODE_BOTTOM = 2333;
    private float mFirstY = 0.0f;
    private float mMargin;

    private TranslateAnimateHelper(View view) {
        this.mTarget = view;
        this.mFirstY = this.mTarget.getY();
        this.mMargin = ((CoordinatorLayout.LayoutParams)this.mTarget.getLayoutParams()).topMargin + ((CoordinatorLayout.LayoutParams)this.mTarget.getLayoutParams()).bottomMargin;
    }

    public static TranslateAnimateHelper get(View target) {
        return new TranslateAnimateHelper(target);
    }

    @Override
    public void show() {
        if (this.mMode == MODE_TITLE) {
            this.showTitle();
        } else if (this.mMode == MODE_BOTTOM) {
            this.showBottom();
        }
    }

    private void hideTitle() {
        ValueAnimator va = ValueAnimator.ofFloat((float[])new float[]{this.mTarget.getY(), -this.mTarget.getHeight()});
        va.setDuration(300L);
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                TranslateAnimateHelper.this.mTarget.setY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        va.start();
        this.mCurrentState = 0;
    }

    private void showTitle() {
        ValueAnimator va = ValueAnimator.ofFloat((float[])new float[]{this.mTarget.getY(), 0.0f});
        va.setDuration(300L);
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                TranslateAnimateHelper.this.mTarget.setY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        va.start();
        this.mCurrentState = 1;
    }

    @Override
    public void hide() {
        if (this.mMode == MODE_TITLE) {
            this.hideTitle();
        } else if (this.mMode == MODE_BOTTOM) {
            this.hideBottom();
        }
    }

    private void showBottom() {
        ValueAnimator va = ValueAnimator.ofFloat((float[])new float[]{this.mTarget.getY(), this.mFirstY});
        va.setDuration(300L);
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                TranslateAnimateHelper.this.mTarget.setY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        va.start();
        this.mCurrentState = 1;
    }

    private void hideBottom() {
        ValueAnimator va = ValueAnimator.ofFloat((float[])new float[]{this.mTarget.getY(), this.mFirstY + (float)this.mTarget.getHeight() + this.mMargin});
        va.setDuration(300L);
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                TranslateAnimateHelper.this.mTarget.setY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        va.start();
        this.mCurrentState = 0;
    }

    @Override
    public void setStartY(float y) {
        this.mStartY = y;
    }

    @Override
    public int getState() {
        return this.mCurrentState;
    }

    @Override
    public void setMode(int mode) {
        this.mMode = mode;
    }

    private void setState(int state) {
        this.mCurrentState = state;
    }
}

