/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.widget.loopviewpager;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.xuexiang.xui.widget.banner.widget.loopviewpager.LoopPagerAdapterWrapper;
import java.util.ArrayList;
import java.util.List;

public class LoopViewPager
extends ViewPager {
    private static final boolean DEFAULT_BOUNDARY_CASHING = false;
    private LoopPagerAdapterWrapper mAdapter;
    private boolean mBoundaryCaching = false;
    private List<ViewPager.OnPageChangeListener> mOnPageChangeListeners;
    private ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){
        private float mPreviousOffset = -1.0f;
        private float mPreviousPosition = -1.0f;

        public void onPageSelected(int position) {
            int realPosition = LoopViewPager.this.mAdapter.toRealPosition(position);
            if (this.mPreviousPosition != (float)realPosition) {
                this.mPreviousPosition = realPosition;
                if (LoopViewPager.this.mOnPageChangeListeners != null) {
                    for (int i = 0; i < LoopViewPager.this.mOnPageChangeListeners.size(); ++i) {
                        ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)LoopViewPager.this.mOnPageChangeListeners.get(i);
                        if (listener == null) continue;
                        listener.onPageSelected(realPosition);
                    }
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int lastPosition;
            int realPosition = position;
            if (LoopViewPager.this.mAdapter != null) {
                realPosition = LoopViewPager.this.mAdapter.toRealPosition(position);
                if (positionOffset == 0.0f && this.mPreviousOffset == 0.0f && (position == 0 || position == LoopViewPager.this.mAdapter.getCount() - 1)) {
                    LoopViewPager.this.setCurrentItem(realPosition, false);
                }
            }
            this.mPreviousOffset = positionOffset;
            int n = lastPosition = LoopViewPager.this.mAdapter != null ? LoopViewPager.this.mAdapter.getRealCount() - 1 : -1;
            if (LoopViewPager.this.mOnPageChangeListeners != null) {
                for (int i = 0; i < LoopViewPager.this.mOnPageChangeListeners.size(); ++i) {
                    ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)LoopViewPager.this.mOnPageChangeListeners.get(i);
                    if (listener == null) continue;
                    if (realPosition != lastPosition) {
                        listener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                        continue;
                    }
                    if ((double)positionOffset > 0.5) {
                        listener.onPageScrolled(0, 0.0f, 0);
                        continue;
                    }
                    listener.onPageScrolled(realPosition, 0.0f, 0);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (LoopViewPager.this.mAdapter != null) {
                int position = LoopViewPager.super.getCurrentItem();
                int realPosition = LoopViewPager.this.mAdapter.toRealPosition(position);
                if (state == 0 && (position == 0 || position == LoopViewPager.this.mAdapter.getCount() - 1)) {
                    LoopViewPager.this.setCurrentItem(realPosition, false);
                }
            }
            if (LoopViewPager.this.mOnPageChangeListeners != null) {
                for (int i = 0; i < LoopViewPager.this.mOnPageChangeListeners.size(); ++i) {
                    ViewPager.OnPageChangeListener listener = (ViewPager.OnPageChangeListener)LoopViewPager.this.mOnPageChangeListeners.get(i);
                    if (listener == null) continue;
                    listener.onPageScrollStateChanged(state);
                }
            }
        }
    };

    public static int toRealPosition(int position, int count) {
        position = --position < 0 ? (position += count) : (position %= count);
        return position;
    }

    public void setBoundaryCaching(boolean flag) {
        this.mBoundaryCaching = flag;
        if (this.mAdapter != null) {
            this.mAdapter.setBoundaryCaching(flag);
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        this.mAdapter = new LoopPagerAdapterWrapper(adapter);
        this.mAdapter.setBoundaryCaching(this.mBoundaryCaching);
        super.setAdapter((PagerAdapter)this.mAdapter);
        this.setCurrentItem(0, false);
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter != null ? this.mAdapter.getRealAdapter() : this.mAdapter;
    }

    public PagerAdapter getPageAdapterWrapper() {
        return this.mAdapter;
    }

    public int getCurrentItem() {
        return this.mAdapter != null ? this.mAdapter.toRealPosition(super.getCurrentItem()) : 0;
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        int realItem = this.mAdapter.toInnerPosition(item);
        super.setCurrentItem(realItem, smoothScroll);
    }

    public void setCurrentItem(int item) {
        if (this.getCurrentItem() != item) {
            this.setCurrentItem(item, true);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.addOnPageChangeListener(listener);
    }

    public void addOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners == null) {
            this.mOnPageChangeListeners = new ArrayList<ViewPager.OnPageChangeListener>();
        }
        this.mOnPageChangeListeners.add(listener);
    }

    public void removeOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.remove(listener);
        }
    }

    public void clearOnPageChangeListeners() {
        if (this.mOnPageChangeListeners != null) {
            this.mOnPageChangeListeners.clear();
        }
    }

    public LoopViewPager(Context context) {
        super(context);
        this.init(context);
    }

    public LoopViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        if (this.onPageChangeListener != null) {
            super.removeOnPageChangeListener(this.onPageChangeListener);
        }
        super.addOnPageChangeListener(this.onPageChangeListener);
    }
}

