/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.widget.banner.base;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.banner.anim.BaseAnimator;
import com.xuexiang.xui.widget.banner.widget.banner.base.BaseBanner;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseIndicatorBanner<E, T extends BaseIndicatorBanner<E, T>>
extends BaseBanner<E, T> {
    public static final int STYLE_DRAWABLE_RESOURCE = 0;
    public static final int STYLE_CORNER_RECTANGLE = 1;
    private List<ImageView> mIndicatorViews = new ArrayList<ImageView>();
    private int mIndicatorStyle;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private int mIndicatorGap;
    private int mIndicatorCornerRadius;
    private Drawable mSelectDrawable;
    private Drawable mUnSelectDrawable;
    private int mSelectColor;
    private int mUnselectColor;
    private Class<? extends BaseAnimator> mSelectAnimClass;
    private Class<? extends BaseAnimator> mUnselectAnimClass;
    private LinearLayout mLlIndicators;

    public BaseIndicatorBanner(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public BaseIndicatorBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public BaseIndicatorBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BaseIndicatorBanner);
        this.mIndicatorStyle = ta.getInt(R.styleable.BaseIndicatorBanner_bb_indicatorStyle, 1);
        this.mIndicatorWidth = ta.getDimensionPixelSize(R.styleable.BaseIndicatorBanner_bb_indicatorWidth, this.dp2px(6.0f));
        this.mIndicatorHeight = ta.getDimensionPixelSize(R.styleable.BaseIndicatorBanner_bb_indicatorHeight, this.dp2px(6.0f));
        this.mIndicatorGap = ta.getDimensionPixelSize(R.styleable.BaseIndicatorBanner_bb_indicatorGap, this.dp2px(6.0f));
        this.mIndicatorCornerRadius = ta.getDimensionPixelSize(R.styleable.BaseIndicatorBanner_bb_indicatorCornerRadius, this.dp2px(3.0f));
        this.mSelectColor = ta.getColor(R.styleable.BaseIndicatorBanner_bb_indicatorSelectColor, Color.parseColor((String)"#ffffff"));
        this.mUnselectColor = ta.getColor(R.styleable.BaseIndicatorBanner_bb_indicatorUnselectColor, Color.parseColor((String)"#88ffffff"));
        int selectRes = ta.getResourceId(R.styleable.BaseIndicatorBanner_bb_indicatorSelectRes, 0);
        int unselectRes = ta.getResourceId(R.styleable.BaseIndicatorBanner_bb_indicatorUnselectRes, 0);
        ta.recycle();
        this.mLlIndicators = new LinearLayout(context);
        this.mLlIndicators.setGravity(17);
        this.setIndicatorSelectorRes(unselectRes, selectRes);
    }

    @Override
    public View onCreateIndicator() {
        if (this.mIndicatorStyle == 1) {
            this.mUnSelectDrawable = this.getDrawable(this.mUnselectColor, this.mIndicatorCornerRadius);
            this.mSelectDrawable = this.getDrawable(this.mSelectColor, this.mIndicatorCornerRadius);
        }
        int size = this.mDatas.size();
        this.mIndicatorViews.clear();
        this.mLlIndicators.removeAllViews();
        for (int i = 0; i < size; ++i) {
            ImageView iv = new ImageView(this.mContext);
            iv.setImageDrawable(i == this.mCurrentPosition ? this.mSelectDrawable : this.mUnSelectDrawable);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.mIndicatorWidth, this.mIndicatorHeight);
            lp.setMarginStart(i == 0 ? 0 : this.mIndicatorGap);
            this.mLlIndicators.addView((View)iv, (ViewGroup.LayoutParams)lp);
            this.mIndicatorViews.add(iv);
        }
        this.setCurrentIndicator(this.mCurrentPosition);
        return this.mLlIndicators;
    }

    @Override
    public void setCurrentIndicator(int position) {
        for (int i = 0; i < this.mIndicatorViews.size(); ++i) {
            this.mIndicatorViews.get(i).setImageDrawable(i == position ? this.mSelectDrawable : this.mUnSelectDrawable);
        }
        try {
            if (this.mSelectAnimClass != null) {
                if (position == this.mLastPosition) {
                    this.mSelectAnimClass.newInstance().playOn((View)this.mIndicatorViews.get(position));
                } else {
                    this.mSelectAnimClass.newInstance().playOn((View)this.mIndicatorViews.get(position));
                    if (this.mUnselectAnimClass == null) {
                        this.mSelectAnimClass.newInstance().interpolator(new ReverseInterpolator()).playOn((View)this.mIndicatorViews.get(this.mLastPosition));
                    } else {
                        this.mUnselectAnimClass.newInstance().playOn((View)this.mIndicatorViews.get(this.mLastPosition));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public T setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorStyle = indicatorStyle;
        return (T)((Object)this);
    }

    public T setIndicatorWidth(float indicatorWidth) {
        this.mIndicatorWidth = this.dp2px(indicatorWidth);
        return (T)((Object)this);
    }

    public T setIndicatorHeight(float indicatorHeight) {
        this.mIndicatorHeight = this.dp2px(indicatorHeight);
        return (T)((Object)this);
    }

    public T setIndicatorGap(float indicatorGap) {
        this.mIndicatorGap = this.dp2px(indicatorGap);
        return (T)((Object)this);
    }

    public T setIndicatorSelectColor(int selectColor) {
        this.mSelectColor = selectColor;
        return (T)((Object)this);
    }

    public T setIndicatorUnselectColor(int unselectColor) {
        this.mUnselectColor = unselectColor;
        return (T)((Object)this);
    }

    public T setIndicatorCornerRadius(float indicatorCornerRadius) {
        this.mIndicatorCornerRadius = this.dp2px(indicatorCornerRadius);
        return (T)((Object)this);
    }

    public T setIndicatorSelectorRes(int unselectRes, int selectRes) {
        try {
            if (this.mIndicatorStyle == 0) {
                if (selectRes != 0) {
                    this.mSelectDrawable = this.getResources().getDrawable(selectRes);
                }
                if (unselectRes != 0) {
                    this.mUnSelectDrawable = this.getResources().getDrawable(unselectRes);
                }
            }
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        return (T)((Object)this);
    }

    public T setSelectAnimClass(Class<? extends BaseAnimator> selectAnimClass) {
        this.mSelectAnimClass = selectAnimClass;
        return (T)((Object)this);
    }

    public T setUnselectAnimClass(Class<? extends BaseAnimator> unselectAnimClass) {
        this.mUnselectAnimClass = unselectAnimClass;
        return (T)((Object)this);
    }

    private GradientDrawable getDrawable(int color2, float raduis) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setCornerRadius(raduis);
        drawable2.setColor(color2);
        return drawable2;
    }

    private static class ReverseInterpolator
    implements Interpolator {
        private ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }
}

