/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.widget.banner.base;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.banner.widget.banner.BannerItem;
import com.xuexiang.xui.widget.banner.widget.banner.base.BaseIndicatorBanner;
import com.xuexiang.xui.widget.imageview.ImageLoader;
import com.xuexiang.xui.widget.imageview.strategy.DiskCacheStrategyEnum;
import com.xuexiang.xui.widget.imageview.strategy.LoadOption;
import java.lang.ref.WeakReference;

public abstract class BaseImageBanner<T extends BaseImageBanner<T>>
extends BaseIndicatorBanner<BannerItem, T> {
    protected Drawable mPlaceHolder;
    protected boolean mEnableCache;
    protected double mScale;

    public BaseImageBanner(Context context) {
        super(context);
        this.initImageBanner(context);
    }

    public BaseImageBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initImageBanner(context);
    }

    public BaseImageBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initImageBanner(context);
    }

    protected void initImageBanner(Context context) {
        this.mPlaceHolder = new ColorDrawable(ResUtils.getColor(context, R.color.default_image_banner_placeholder_color));
        this.mEnableCache = true;
        this.mScale = this.getContainerScale();
    }

    @Override
    public void onTitleSelect(TextView tv, int position) {
        BannerItem item = (BannerItem)this.getItem(position);
        if (item != null) {
            tv.setText((CharSequence)item.title);
        }
    }

    @Override
    public void setContainerScale(float containerScale) {
        super.setContainerScale(containerScale);
        this.mScale = this.getContainerScale();
    }

    protected abstract int getItemLayoutId();

    protected abstract int getImageViewId();

    @Override
    public View onCreateItemView(int position) {
        View inflate = View.inflate((Context)this.getContext(), (int)this.getItemLayoutId(), null);
        ImageView iv = (ImageView)inflate.findViewById(this.getImageViewId());
        WeakReference<ImageView> imageViewWeakReference = new WeakReference<ImageView>(iv);
        ImageView target = (ImageView)imageViewWeakReference.get();
        BannerItem item = (BannerItem)this.getItem(position);
        if (item != null && target != null) {
            this.loadingImageView(target, item);
        }
        return inflate;
    }

    protected void loadingImageView(ImageView iv, BannerItem item) {
        String imgUrl = item.imgUrl;
        if (!TextUtils.isEmpty((CharSequence)imgUrl)) {
            if (this.mScale > 0.0) {
                int itemWidth = this.getItemWidth();
                int itemHeight = (int)((double)itemWidth * this.mScale);
                iv.setScaleType(ImageView.ScaleType.CENTER_CROP);
                iv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(itemWidth, itemHeight));
                LoadOption option = LoadOption.of(this.mPlaceHolder).setSize(itemWidth, itemHeight).setCacheStrategy(this.mEnableCache ? DiskCacheStrategyEnum.RESOURCE : DiskCacheStrategyEnum.NONE);
                ImageLoader.get().loadImage(iv, (Object)imgUrl, option);
            } else {
                ImageLoader.get().loadImage(iv, (Object)imgUrl, this.mPlaceHolder, this.mEnableCache ? DiskCacheStrategyEnum.RESOURCE : DiskCacheStrategyEnum.NONE);
            }
        } else {
            iv.setImageDrawable(this.mPlaceHolder);
        }
    }

    public T enableCache(boolean enableCache) {
        this.mEnableCache = enableCache;
        return (T)((Object)this);
    }

    public boolean getEnableCache() {
        return this.mEnableCache;
    }

    public Drawable getPlaceHolderDrawable() {
        return this.mPlaceHolder;
    }

    public T setPlaceHolderDrawable(Drawable placeHolder) {
        this.mPlaceHolder = placeHolder;
        return (T)((Object)this);
    }

    public double getScale() {
        return this.mScale;
    }

    public T setScale(double scale) {
        this.mScale = scale;
        return (T)((Object)this);
    }

    protected void onDetachedFromWindow() {
        this.pauseScroll();
        super.onDetachedFromWindow();
    }
}

