/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.widget.banner.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.widget.banner.widget.loopviewpager.FixedSpeedScroller;
import com.xuexiang.xui.widget.banner.widget.loopviewpager.LoopViewPager;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class BaseBanner<E, T extends BaseBanner<E, T>>
extends RelativeLayout
implements HasTypeface {
    private ScheduledExecutorService mExecutorService;
    protected Context mContext;
    protected DisplayMetrics mDisplayMetrics;
    protected ViewPager mViewPager;
    protected RelativeLayout mRlBottomBarParent;
    protected List<E> mDatas = new ArrayList();
    protected int mCurrentPosition;
    protected int mLastPosition;
    private long mDelay;
    private long mPeriod;
    private boolean mIsAutoScrollEnable;
    private boolean mIsAutoScrolling;
    private int mScrollSpeed = 450;
    private Class<? extends ViewPager.PageTransformer> mTransformerClass;
    private int mItemWidth;
    private int mItemHeight;
    private LinearLayout mLlBottomBar;
    private boolean mIsBarShowWhenLast;
    private LinearLayout mLlIndicatorContainer;
    private TextView mTvTitle;
    private boolean mIsDataChanged = false;
    private boolean mIsOnePageLoop = true;
    private float mContainerScale;
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    private Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(@NonNull Message message) {
            BaseBanner.this.scrollToNextItem(BaseBanner.this.mCurrentPosition);
            return true;
        }
    });
    private ViewPager.OnPageChangeListener mInternalPageListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (BaseBanner.this.mOnPageChangeListener != null) {
                BaseBanner.this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageSelected(int position) {
            BaseBanner.this.mCurrentPosition = position % BaseBanner.this.mDatas.size();
            BaseBanner.this.setCurrentIndicator(BaseBanner.this.mCurrentPosition);
            BaseBanner.this.onTitleSelect(BaseBanner.this.mTvTitle, BaseBanner.this.mCurrentPosition);
            BaseBanner.this.mLlBottomBar.setVisibility(BaseBanner.this.mCurrentPosition == BaseBanner.this.mDatas.size() - 1 && !BaseBanner.this.mIsBarShowWhenLast ? 8 : 0);
            BaseBanner.this.mLastPosition = BaseBanner.this.mCurrentPosition;
            if (BaseBanner.this.mOnPageChangeListener != null) {
                BaseBanner.this.mOnPageChangeListener.onPageSelected(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (BaseBanner.this.mOnPageChangeListener != null) {
                BaseBanner.this.mOnPageChangeListener.onPageScrollStateChanged(state);
            }
        }
    };
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private OnItemClickListener<E> mOnItemClickListener;

    public BaseBanner(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public BaseBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public BaseBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.mContext = context;
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BaseBanner);
        this.mContainerScale = ta.getFloat(R.styleable.BaseBanner_bb_scale, -1.0f);
        boolean isLoopEnable = ta.getBoolean(R.styleable.BaseBanner_bb_isLoopEnable, true);
        this.mDelay = ta.getInt(R.styleable.BaseBanner_bb_delay, 5);
        this.mPeriod = ta.getInt(R.styleable.BaseBanner_bb_period, 5);
        this.mIsAutoScrollEnable = ta.getBoolean(R.styleable.BaseBanner_bb_isAutoScrollEnable, true);
        int barColor = ta.getColor(R.styleable.BaseBanner_bb_barColor, 0);
        this.mIsBarShowWhenLast = ta.getBoolean(R.styleable.BaseBanner_bb_isBarShowWhenLast, true);
        int indicatorGravity = ta.getInt(R.styleable.BaseBanner_bb_indicatorGravity, 17);
        float barPaddingLeft = ta.getDimension(R.styleable.BaseBanner_bb_barPaddingLeft, (float)this.dp2px(10.0f));
        float barPaddingTop = ta.getDimension(R.styleable.BaseBanner_bb_barPaddingTop, (float)this.dp2px(indicatorGravity == 17 ? 6.0f : 2.0f));
        float barPaddingRight = ta.getDimension(R.styleable.BaseBanner_bb_barPaddingRight, (float)this.dp2px(10.0f));
        float barPaddingBottom = ta.getDimension(R.styleable.BaseBanner_bb_barPaddingBottom, (float)this.dp2px(indicatorGravity == 17 ? 6.0f : 2.0f));
        int textColor = ta.getColor(R.styleable.BaseBanner_bb_textColor, Color.parseColor((String)"#ffffff"));
        float textSize = ta.getDimension(R.styleable.BaseBanner_bb_textSize, this.sp2px(12.5f));
        boolean isTitleShow = ta.getBoolean(R.styleable.BaseBanner_bb_isTitleShow, true);
        boolean isIndicatorShow = ta.getBoolean(R.styleable.BaseBanner_bb_isIndicatorShow, true);
        ta.recycle();
        int height = attrs != null ? attrs.getAttributeIntValue(NAMESPACE_ANDROID, "layout_height", -2) : -2;
        this.mViewPager = isLoopEnable ? new LoopViewPager(context) : new ViewPager(context);
        this.mViewPager.setOverScrollMode(2);
        this.mItemWidth = this.mDisplayMetrics.widthPixels;
        this.initHeight(context, height, attrs);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.mItemWidth, this.mItemHeight);
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)lp);
        this.mRlBottomBarParent = new RelativeLayout(context);
        this.addView((View)this.mRlBottomBarParent, (ViewGroup.LayoutParams)lp);
        this.mLlBottomBar = new LinearLayout(context);
        RelativeLayout.LayoutParams lp2 = new RelativeLayout.LayoutParams(this.mItemWidth, -2);
        lp2.addRule(12, -1);
        this.mRlBottomBarParent.addView((View)this.mLlBottomBar, (ViewGroup.LayoutParams)lp2);
        this.mLlBottomBar.setBackgroundColor(barColor);
        this.mLlBottomBar.setPadding((int)barPaddingLeft, (int)barPaddingTop, (int)barPaddingRight, (int)barPaddingBottom);
        this.mLlBottomBar.setClipChildren(false);
        this.mLlBottomBar.setClipToPadding(false);
        this.initIndicatorContainer(context, isIndicatorShow);
        this.initTitle(context, textColor, textSize, isTitleShow);
        if (indicatorGravity == 17) {
            this.mLlBottomBar.setGravity(17);
            this.mLlBottomBar.addView((View)this.mLlIndicatorContainer);
        } else if (indicatorGravity == 5) {
            this.mLlBottomBar.setGravity(16);
            this.mLlBottomBar.addView((View)this.mTvTitle);
            this.mLlBottomBar.addView((View)this.mLlIndicatorContainer);
            this.mTvTitle.setPadding(0, 0, this.dp2px(7.0f), 0);
            this.mTvTitle.setEllipsize(TextUtils.TruncateAt.END);
            this.mTvTitle.setGravity(3);
        } else if (indicatorGravity == 3) {
            this.mLlBottomBar.setGravity(16);
            this.mLlBottomBar.addView((View)this.mLlIndicatorContainer);
            this.mLlBottomBar.addView((View)this.mTvTitle);
            this.mTvTitle.setPadding(this.dp2px(7.0f), 0, 0, 0);
            this.mTvTitle.setEllipsize(TextUtils.TruncateAt.END);
            this.mTvTitle.setGravity(5);
        }
    }

    private void initHeight(@NonNull Context context, int height, @Nullable AttributeSet attrs) {
        if (this.mContainerScale < 0.0f) {
            if (height == -1 || height == -2) {
                this.mItemHeight = height;
            } else {
                int[] systemAttrs = new int[]{16842997};
                TypedArray a = context.obtainStyledAttributes(attrs, systemAttrs);
                int h = a.getDimensionPixelSize(0, -2);
                a.recycle();
                this.mItemHeight = h;
            }
        } else {
            if (this.mContainerScale > 1.0f) {
                this.mContainerScale = 1.0f;
            }
            this.mItemHeight = (int)((float)this.mItemWidth * this.mContainerScale);
        }
    }

    private void initIndicatorContainer(@NonNull Context context, boolean isIndicatorShow) {
        this.mLlIndicatorContainer = new LinearLayout(context);
        this.mLlIndicatorContainer.setGravity(17);
        this.mLlIndicatorContainer.setVisibility(isIndicatorShow ? 0 : 4);
        this.mLlIndicatorContainer.setClipChildren(false);
        this.mLlIndicatorContainer.setClipToPadding(false);
    }

    private void initTitle(@NonNull Context context, int textColor, float textSize, boolean isTitleShow) {
        this.mTvTitle = new TextView(context);
        this.mTvTitle.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.mTvTitle.setSingleLine(true);
        this.mTvTitle.setTextColor(textColor);
        this.mTvTitle.setTextSize(0, textSize);
        this.mTvTitle.setVisibility(isTitleShow ? 0 : 4);
    }

    public void setContainerScale(float containerScale) {
        this.mContainerScale = containerScale;
        if (this.mContainerScale > 1.0f) {
            this.mContainerScale = 1.0f;
        }
        this.mItemHeight = (int)((float)this.mItemWidth * this.mContainerScale);
        this.removeView((View)this.mViewPager);
        this.removeView((View)this.mRlBottomBarParent);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.mItemWidth, this.mItemHeight);
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)lp);
        this.addView((View)this.mRlBottomBarParent, (ViewGroup.LayoutParams)lp);
    }

    public abstract View onCreateItemView(int var1);

    public abstract View onCreateIndicator();

    public abstract void setCurrentIndicator(int var1);

    public void onTitleSelect(TextView tv, int position) {
    }

    public T setSource(List<E> list) {
        this.mDatas = list;
        this.mIsDataChanged = true;
        return (T)((Object)this);
    }

    public E getItem(int position) {
        return this.size() > 0 ? (E)this.mDatas.get(position) : null;
    }

    public int size() {
        return this.mDatas != null ? this.mDatas.size() : 0;
    }

    public int getItemHeight() {
        return this.mItemHeight;
    }

    public int getItemWidth() {
        return this.mItemWidth;
    }

    public float getContainerScale() {
        return this.mContainerScale;
    }

    public T setDelay(long delay) {
        this.mDelay = delay;
        return (T)((Object)this);
    }

    public T setPeriod(long period) {
        this.mPeriod = period;
        return (T)((Object)this);
    }

    public T setAutoScrollEnable(boolean isAutoScrollEnable) {
        this.mIsAutoScrollEnable = isAutoScrollEnable;
        return (T)((Object)this);
    }

    public T setTransformerClass(Class<? extends ViewPager.PageTransformer> transformerClass) {
        this.mTransformerClass = transformerClass;
        return (T)((Object)this);
    }

    public T setBarColor(int barColor) {
        this.mLlBottomBar.setBackgroundColor(barColor);
        return (T)((Object)this);
    }

    public T setBarShowWhenLast(boolean isBarShowWhenLast) {
        this.mIsBarShowWhenLast = isBarShowWhenLast;
        return (T)((Object)this);
    }

    public T barPadding(float left, float top, float right, float bottom) {
        this.mLlBottomBar.setPadding(this.dp2px(left), this.dp2px(top), this.dp2px(right), this.dp2px(bottom));
        return (T)((Object)this);
    }

    public T setTextColor(int textColor) {
        this.mTvTitle.setTextColor(textColor);
        return (T)((Object)this);
    }

    public T setTextSize(float textSize) {
        this.mTvTitle.setTextSize(2, textSize);
        return (T)((Object)this);
    }

    public T setTitleShow(boolean isTitleShow) {
        this.mTvTitle.setVisibility(isTitleShow ? 0 : 4);
        return (T)((Object)this);
    }

    public T setIndicatorShow(boolean isIndicatorShow) {
        this.mLlIndicatorContainer.setVisibility(isIndicatorShow ? 0 : 4);
        return (T)((Object)this);
    }

    private void scrollToNextItem(int position) {
        if (this.isValid()) {
            if (this.mIsDataChanged) {
                this.updateViewPager();
            }
            this.mViewPager.setCurrentItem(++position);
        }
    }

    private void updateViewPager() {
        if (this.isLoopViewPager()) {
            ((LoopViewPager)this.mViewPager).getPageAdapterWrapper().notifyDataSetChanged();
        } else if (this.mViewPager.getAdapter() != null) {
            this.mViewPager.getAdapter().notifyDataSetChanged();
        }
    }

    private void setViewPager() {
        InnerBannerAdapter mInnerAdapter = new InnerBannerAdapter();
        this.mViewPager.setAdapter((PagerAdapter)mInnerAdapter);
        this.mViewPager.setOffscreenPageLimit(this.mDatas.size() - 1);
        try {
            if (this.mTransformerClass != null) {
                this.mViewPager.setPageTransformer(true, this.mTransformerClass.newInstance());
                if (this.isLoopViewPager()) {
                    this.mScrollSpeed = 550;
                    this.setScrollSpeed();
                }
            } else if (this.isLoopViewPager()) {
                this.mScrollSpeed = 450;
                this.setScrollSpeed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mInternalPageListener != null) {
            this.mViewPager.removeOnPageChangeListener(this.mInternalPageListener);
            this.mViewPager.addOnPageChangeListener(this.mInternalPageListener);
        }
    }

    public void startScroll() {
        if (this.mDatas == null) {
            throw new IllegalStateException("Data source is empty,you must setSource() before startScroll()");
        }
        if (this.mDatas.size() > 0 && this.mCurrentPosition > this.mDatas.size() - 1) {
            this.mCurrentPosition = 0;
        }
        this.onTitleSelect(this.mTvTitle, this.mCurrentPosition);
        this.setViewPager();
        View indicatorViews = this.onCreateIndicator();
        if (indicatorViews != null) {
            this.mLlIndicatorContainer.removeAllViews();
            this.mLlIndicatorContainer.addView(indicatorViews);
        }
        this.goOnScroll();
    }

    public void goOnScroll() {
        if (!this.isValid()) {
            return;
        }
        if (this.mIsAutoScrolling) {
            return;
        }
        if (this.isLoopViewPager() && this.mIsAutoScrollEnable) {
            this.pauseScroll();
            this.mExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.mExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    BaseBanner.this.mHandler.obtainMessage().sendToTarget();
                }
            }, this.mDelay, this.mPeriod, TimeUnit.SECONDS);
            this.mIsAutoScrolling = true;
            UILog.d(((Object)((Object)this)).getClass().getSimpleName() + "--->goOnScroll()");
        } else {
            this.mIsAutoScrolling = false;
        }
    }

    public void pauseScroll() {
        this.stopScroll();
        UILog.d(((Object)((Object)this)).getClass().getSimpleName() + "--->pauseScroll()");
        this.mIsAutoScrolling = false;
    }

    private void stopScroll() {
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdown();
            this.mExecutorService = null;
        }
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.pauseScroll();
                break;
            }
            case 1: {
                this.goOnScroll();
                break;
            }
            case 3: {
                this.goOnScroll();
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void setScrollSpeed() {
        try {
            Field mScroller = ViewPager.class.getDeclaredField("mScroller");
            mScroller.setAccessible(true);
            AccelerateDecelerateInterpolator interpolator2 = new AccelerateDecelerateInterpolator();
            FixedSpeedScroller myScroller = new FixedSpeedScroller(this.mContext, (Interpolator)interpolator2, this.mScrollSpeed);
            mScroller.set(this.mViewPager, (Object)myScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int dp2px(float dp) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    private float sp2px(float sp) {
        float scale = this.mContext.getResources().getDisplayMetrics().scaledDensity;
        return sp * scale;
    }

    protected boolean isLoopViewPager() {
        return this.mViewPager instanceof LoopViewPager;
    }

    protected boolean isValid() {
        if (this.mViewPager == null) {
            UILog.e("ViewPager is not exist!");
            return false;
        }
        if (this.mDatas == null || this.mDatas.size() <= 0) {
            UILog.e("DataList must be not empty!");
            return false;
        }
        return this.mIsOnePageLoop || this.mDatas.size() != 1;
    }

    public BaseBanner addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
        return this;
    }

    public BaseBanner setOnItemClickListener(OnItemClickListener<E> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        return this;
    }

    public BaseBanner setIsOnePageLoop(boolean isOnePageLoop) {
        this.mIsOnePageLoop = isOnePageLoop;
        return this;
    }

    public void recycle() {
        this.pauseScroll();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public void setTypeface(Typeface typeface) {
        if (this.mTvTitle != null) {
            this.mTvTitle.setTypeface(typeface);
        }
    }

    public static interface OnItemClickListener<E> {
        public void onItemClick(View var1, E var2, int var3);
    }

    private class InnerBannerAdapter
    extends PagerAdapter {
        private InnerBannerAdapter() {
        }

        public int getCount() {
            return BaseBanner.this.mDatas != null ? BaseBanner.this.mDatas.size() : 0;
        }

        @NonNull
        public Object instantiateItem(ViewGroup container, final int position) {
            View inflate = BaseBanner.this.onCreateItemView(position);
            inflate.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BaseBanner.this.mOnItemClickListener != null) {
                        BaseBanner.this.mOnItemClickListener.onItemClick(v, BaseBanner.this.getItem(position), position);
                    }
                }
            });
            container.addView(inflate);
            return inflate;
        }

        public void destroyItem(ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }
    }
}

