/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.transform;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

public class ZoomOutSlideTransformer
implements ViewPager.PageTransformer {
    private static final float MIN_SCALE = 0.85f;
    private static final float MIN_ALPHA = 0.9f;

    public void transformPage(@NonNull View page, float position) {
        if (position >= -1.0f || position <= 1.0f) {
            float height = page.getHeight();
            float scaleFactor = Math.max(0.85f, 1.0f - Math.abs(position));
            float vertMargin = height * (1.0f - scaleFactor) / 2.0f;
            float horzMargin = (float)page.getWidth() * (1.0f - scaleFactor) / 2.0f;
            page.setPivotY(0.5f * height);
            if (position < 0.0f) {
                page.setTranslationX(horzMargin - vertMargin / 2.0f);
            } else {
                page.setTranslationX(-horzMargin + vertMargin / 2.0f);
            }
            page.setScaleX(scaleFactor);
            page.setScaleY(scaleFactor);
            page.setAlpha(0.9f + (scaleFactor - 0.85f) / 0.14999998f * 0.100000024f);
        }
    }
}

