/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.recycler.layout;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

public class BannerLayoutManager
extends RecyclerView.LayoutManager {
    public static final int DETERMINE_BY_MAX_AND_MIN = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int DIRECTION_NO_WHERE = -1;
    private static final int DIRECTION_FORWARD = 0;
    private static final int DIRECTION_BACKWARD = 1;
    protected static final int INVALID_SIZE = Integer.MAX_VALUE;
    private SparseArray<View> positionCache = new SparseArray();
    protected int mDecoratedMeasurement;
    protected int mDecoratedMeasurementInOther;
    int mOrientation;
    protected int mSpaceMain;
    protected int mSpaceInOther;
    protected float mOffset;
    protected OrientationHelper mOrientationHelper;
    private boolean mReverseLayout = false;
    private boolean mShouldReverseLayout = false;
    private boolean mSmoothScrollbarEnabled = true;
    private int mPendingScrollPosition = -1;
    private SavedState mPendingSavedState = null;
    protected float mInterval;
    OnPageChangeListener onPageChangeListener;
    private boolean mRecycleChildrenOnDetach;
    private boolean mInfinite = true;
    private boolean mEnableBringCenterToFront;
    private int mLeftItems;
    private int mRightItems;
    private int mMaxVisibleItemCount = -1;
    private Interpolator mSmoothScrollInterpolator;
    private int mDistanceToBottom = Integer.MAX_VALUE;
    private View currentFocusView;
    private int itemSpace = 20;
    private float centerScale = 1.2f;
    private float moveSpeed = 1.0f;

    protected float getDistanceRatio() {
        if (this.moveSpeed == 0.0f) {
            return Float.MAX_VALUE;
        }
        return 1.0f / this.moveSpeed;
    }

    protected float setInterval() {
        return (float)this.mDecoratedMeasurement * ((this.centerScale - 1.0f) / 2.0f + 1.0f) + (float)this.itemSpace;
    }

    public void setItemSpace(int itemSpace) {
        this.itemSpace = itemSpace;
    }

    public void setCenterScale(float centerScale) {
        this.centerScale = centerScale;
    }

    public void setMoveSpeed(float moveSpeed) {
        this.assertNotInLayoutOrScroll(null);
        if (this.moveSpeed == moveSpeed) {
            return;
        }
        this.moveSpeed = moveSpeed;
    }

    protected void setItemViewProperty(View itemView, float targetOffset) {
        float scale = this.calculateScale(targetOffset + (float)this.mSpaceMain);
        itemView.setScaleX(scale);
        itemView.setScaleY(scale);
    }

    private float calculateScale(float x) {
        float deltaX = Math.abs(x - (float)(this.mOrientationHelper.getTotalSpace() - this.mDecoratedMeasurement) / 2.0f);
        float diff = 0.0f;
        if ((float)this.mDecoratedMeasurement - deltaX > 0.0f) {
            diff = (float)this.mDecoratedMeasurement - deltaX;
        }
        return (this.centerScale - 1.0f) / (float)this.mDecoratedMeasurement * diff + 1.0f;
    }

    protected float setViewElevation(View itemView, float targetOffset) {
        return 0.0f;
    }

    public BannerLayoutManager(Context context) {
        this(context, 0, false);
    }

    public BannerLayoutManager(Context context, int orientation) {
        this(context, orientation, false);
    }

    public BannerLayoutManager(Context context, int orientation, boolean reverseLayout) {
        this.setEnableBringCenterToFront(true);
        this.setMaxVisibleItemCount(3);
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
        this.setAutoMeasureEnabled(true);
        this.setItemPrefetchEnabled(false);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public boolean getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    public void setRecycleChildrenOnDetach(boolean recycleChildrenOnDetach) {
        this.mRecycleChildrenOnDetach = recycleChildrenOnDetach;
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.mRecycleChildrenOnDetach) {
            this.removeAndRecycleAllViews(recycler);
            recycler.clear();
        }
    }

    public Parcelable onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState savedState = new SavedState();
        savedState.position = this.mPendingScrollPosition;
        savedState.offset = this.mOffset;
        savedState.isReverseLayout = this.mShouldReverseLayout;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = new SavedState((SavedState)state);
            this.requestLayout();
        }
    }

    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation:" + orientation);
        }
        this.assertNotInLayoutOrScroll(null);
        if (orientation == this.mOrientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mOrientationHelper = null;
        this.mDistanceToBottom = Integer.MAX_VALUE;
        this.removeAllViews();
    }

    public int getMaxVisibleItemCount() {
        return this.mMaxVisibleItemCount;
    }

    public void setMaxVisibleItemCount(int mMaxVisibleItemCount) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mMaxVisibleItemCount == mMaxVisibleItemCount) {
            return;
        }
        this.mMaxVisibleItemCount = mMaxVisibleItemCount;
        this.removeAllViews();
    }

    private void resolveShouldLayoutReverse() {
        if (this.mOrientation == 0 && this.getLayoutDirection() == 1) {
            this.mReverseLayout = !this.mReverseLayout;
        }
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public void setReverseLayout(boolean reverseLayout) {
        this.assertNotInLayoutOrScroll(null);
        if (reverseLayout == this.mReverseLayout) {
            return;
        }
        this.mReverseLayout = reverseLayout;
        this.removeAllViews();
    }

    public void setSmoothScrollInterpolator(Interpolator smoothScrollInterpolator) {
        this.mSmoothScrollInterpolator = smoothScrollInterpolator;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        int offsetPosition = this.getOffsetToPosition(position);
        if (this.mOrientation == 1) {
            recyclerView.smoothScrollBy(0, offsetPosition, this.mSmoothScrollInterpolator);
        } else {
            recyclerView.smoothScrollBy(offsetPosition, 0, this.mSmoothScrollInterpolator);
        }
    }

    public void scrollToPosition(int position) {
        if (!(this.mInfinite || position >= 0 && position < this.getItemCount())) {
            return;
        }
        this.mPendingScrollPosition = position;
        this.mOffset = this.mShouldReverseLayout ? (float)position * -this.mInterval : (float)position * this.mInterval;
        this.requestLayout();
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            this.mOffset = 0.0f;
            return;
        }
        this.ensureLayoutState();
        this.resolveShouldLayoutReverse();
        View scrap = recycler.getViewForPosition(0);
        this.measureChildWithMargins(scrap, 0, 0);
        this.mDecoratedMeasurement = this.mOrientationHelper.getDecoratedMeasurement(scrap);
        this.mDecoratedMeasurementInOther = this.mOrientationHelper.getDecoratedMeasurementInOther(scrap);
        this.mSpaceMain = (this.mOrientationHelper.getTotalSpace() - this.mDecoratedMeasurement) / 2;
        this.mSpaceInOther = this.mDistanceToBottom == Integer.MAX_VALUE ? (this.getTotalSpaceInOther() - this.mDecoratedMeasurementInOther) / 2 : this.getTotalSpaceInOther() - this.mDecoratedMeasurementInOther - this.mDistanceToBottom;
        this.mInterval = this.setInterval();
        this.setUp();
        this.mLeftItems = (int)Math.abs(this.minRemoveOffset() / this.mInterval) + 1;
        this.mRightItems = (int)Math.abs(this.maxRemoveOffset() / this.mInterval) + 1;
        if (this.mPendingSavedState != null) {
            this.mShouldReverseLayout = this.mPendingSavedState.isReverseLayout;
            this.mPendingScrollPosition = this.mPendingSavedState.position;
            this.mOffset = this.mPendingSavedState.offset;
        }
        if (this.mPendingScrollPosition != -1) {
            this.mOffset = this.mShouldReverseLayout ? (float)this.mPendingScrollPosition * -this.mInterval : (float)this.mPendingScrollPosition * this.mInterval;
        }
        this.detachAndScrapAttachedViews(recycler);
        this.layoutItems(recycler);
    }

    public int getTotalSpaceInOther() {
        if (this.mOrientation == 0) {
            return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        }
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSavedState = null;
        this.mPendingScrollPosition = -1;
    }

    public boolean onAddFocusables(@NonNull RecyclerView recyclerView, @NonNull ArrayList<View> views, int direction, int focusableMode) {
        int currentPosition = this.getCurrentPosition();
        View currentView = this.findViewByPosition(currentPosition);
        if (currentView == null) {
            return true;
        }
        if (recyclerView.hasFocus()) {
            int movement = this.getMovement(direction);
            if (movement != -1) {
                int targetPosition = movement == 1 ? currentPosition - 1 : currentPosition + 1;
                recyclerView.smoothScrollToPosition(targetPosition);
            }
        } else {
            currentView.addFocusables(views, direction, focusableMode);
        }
        return true;
    }

    public View onFocusSearchFailed(@NonNull View focused, int focusDirection, @NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state) {
        return null;
    }

    private int getMovement(int direction) {
        if (this.mOrientation == 1) {
            if (direction == 33) {
                return this.mShouldReverseLayout ? 0 : 1;
            }
            if (direction == 130) {
                return this.mShouldReverseLayout ? 1 : 0;
            }
            return -1;
        }
        if (direction == 17) {
            return this.mShouldReverseLayout ? 0 : 1;
        }
        if (direction == 66) {
            return this.mShouldReverseLayout ? 1 : 0;
        }
        return -1;
    }

    void ensureLayoutState() {
        if (this.mOrientationHelper == null) {
            this.mOrientationHelper = OrientationHelper.createOrientationHelper((RecyclerView.LayoutManager)this, (int)this.mOrientation);
        }
    }

    protected void setUp() {
    }

    private float getProperty(int position) {
        return this.mShouldReverseLayout ? (float)position * -this.mInterval : (float)position * this.mInterval;
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        this.removeAllViews();
        this.mOffset = 0.0f;
    }

    public int computeHorizontalScrollOffset(@NonNull RecyclerView.State state) {
        return this.computeScrollOffset();
    }

    public int computeVerticalScrollOffset(@NonNull RecyclerView.State state) {
        return this.computeScrollOffset();
    }

    public int computeHorizontalScrollExtent(@NonNull RecyclerView.State state) {
        return this.computeScrollExtent();
    }

    public int computeVerticalScrollExtent(@NonNull RecyclerView.State state) {
        return this.computeScrollExtent();
    }

    public int computeHorizontalScrollRange(@NonNull RecyclerView.State state) {
        return this.computeScrollRange();
    }

    public int computeVerticalScrollRange(@NonNull RecyclerView.State state) {
        return this.computeScrollRange();
    }

    private int computeScrollOffset() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (!this.mSmoothScrollbarEnabled) {
            return !this.mShouldReverseLayout ? this.getCurrentPosition() : this.getItemCount() - this.getCurrentPosition() - 1;
        }
        float realOffset = this.getOffsetOfRightAdapterPosition();
        return !this.mShouldReverseLayout ? (int)realOffset : (int)((float)(this.getItemCount() - 1) * this.mInterval + realOffset);
    }

    private int computeScrollExtent() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (!this.mSmoothScrollbarEnabled) {
            return 1;
        }
        return (int)this.mInterval;
    }

    private int computeScrollRange() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (!this.mSmoothScrollbarEnabled) {
            return this.getItemCount();
        }
        return (int)((float)this.getItemCount() * this.mInterval);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return this.scrollBy(dx, recycler, state);
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return this.scrollBy(dy, recycler, state);
    }

    private int scrollBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.ensureLayoutState();
        int willScroll = dy;
        float realDx = (float)dy / this.getDistanceRatio();
        if (Math.abs(realDx) < 1.0E-8f) {
            return 0;
        }
        float targetOffset = this.mOffset + realDx;
        if (!this.mInfinite && targetOffset < this.getMinOffset()) {
            willScroll = (int)((float)willScroll - (targetOffset - this.getMinOffset()) * this.getDistanceRatio());
        } else if (!this.mInfinite && targetOffset > this.getMaxOffset()) {
            willScroll = (int)((this.getMaxOffset() - this.mOffset) * this.getDistanceRatio());
        }
        realDx = (float)willScroll / this.getDistanceRatio();
        this.mOffset += realDx;
        this.layoutItems(recycler);
        return willScroll;
    }

    private void layoutItems(RecyclerView.Recycler recycler) {
        this.detachAndScrapAttachedViews(recycler);
        this.positionCache.clear();
        int itemCount = this.getItemCount();
        if (itemCount == 0) {
            return;
        }
        int currentPos = this.mShouldReverseLayout ? -this.getCurrentPositionOffset() : this.getCurrentPositionOffset();
        int start = currentPos - this.mLeftItems;
        int end = currentPos + this.mRightItems;
        if (this.useMaxVisibleCount()) {
            int offset;
            boolean isEven;
            boolean bl = isEven = this.mMaxVisibleItemCount % 2 == 0;
            if (isEven) {
                offset = this.mMaxVisibleItemCount / 2;
                start = currentPos - offset + 1;
                end = currentPos + offset + 1;
            } else {
                offset = (this.mMaxVisibleItemCount - 1) / 2;
                start = currentPos - offset;
                end = currentPos + offset + 1;
            }
        }
        if (!this.mInfinite) {
            if (start < 0) {
                start = 0;
                if (this.useMaxVisibleCount()) {
                    end = this.mMaxVisibleItemCount;
                }
            }
            if (end > itemCount) {
                end = itemCount;
            }
        }
        float lastOrderWeight = Float.MIN_VALUE;
        for (int i = start; i < end; ++i) {
            float orderWeight;
            if (!this.useMaxVisibleCount() && this.removeCondition(this.getProperty(i) - this.mOffset)) continue;
            int adapterPosition = i;
            if (i >= itemCount) {
                adapterPosition %= itemCount;
            } else if (i < 0) {
                int delta = -adapterPosition % itemCount;
                if (delta == 0) {
                    delta = itemCount;
                }
                adapterPosition = itemCount - delta;
            }
            View scrap = recycler.getViewForPosition(adapterPosition);
            this.measureChildWithMargins(scrap, 0, 0);
            this.resetViewProperty(scrap);
            float targetOffset = this.getProperty(i) - this.mOffset;
            this.layoutScrap(scrap, targetOffset);
            float f = orderWeight = this.mEnableBringCenterToFront ? this.setViewElevation(scrap, targetOffset) : (float)adapterPosition;
            if (orderWeight > lastOrderWeight) {
                this.addView(scrap);
            } else {
                this.addView(scrap, 0);
            }
            if (i == currentPos) {
                this.currentFocusView = scrap;
            }
            lastOrderWeight = orderWeight;
            this.positionCache.put(i, (Object)scrap);
        }
        this.currentFocusView.requestFocus();
    }

    private boolean useMaxVisibleCount() {
        return this.mMaxVisibleItemCount != -1;
    }

    private boolean removeCondition(float targetOffset) {
        return targetOffset > this.maxRemoveOffset() || targetOffset < this.minRemoveOffset();
    }

    private void resetViewProperty(View v) {
        v.setRotation(0.0f);
        v.setRotationY(0.0f);
        v.setRotationX(0.0f);
        v.setScaleX(1.0f);
        v.setScaleY(1.0f);
        v.setAlpha(1.0f);
    }

    float getMaxOffset() {
        return !this.mShouldReverseLayout ? (float)(this.getItemCount() - 1) * this.mInterval : 0.0f;
    }

    float getMinOffset() {
        return !this.mShouldReverseLayout ? 0.0f : (float)(-(this.getItemCount() - 1)) * this.mInterval;
    }

    private void layoutScrap(View scrap, float targetOffset) {
        int left = this.calItemLeft(scrap, targetOffset);
        int top = this.calItemTop(scrap, targetOffset);
        if (this.mOrientation == 1) {
            this.layoutDecorated(scrap, this.mSpaceInOther + left, this.mSpaceMain + top, this.mSpaceInOther + left + this.mDecoratedMeasurementInOther, this.mSpaceMain + top + this.mDecoratedMeasurement);
        } else {
            this.layoutDecorated(scrap, this.mSpaceMain + left, this.mSpaceInOther + top, this.mSpaceMain + left + this.mDecoratedMeasurement, this.mSpaceInOther + top + this.mDecoratedMeasurementInOther);
        }
        this.setItemViewProperty(scrap, targetOffset);
    }

    protected int calItemLeft(View itemView, float targetOffset) {
        return this.mOrientation == 1 ? 0 : (int)targetOffset;
    }

    protected int calItemTop(View itemView, float targetOffset) {
        return this.mOrientation == 1 ? (int)targetOffset : 0;
    }

    protected float maxRemoveOffset() {
        return this.mOrientationHelper.getTotalSpace() - this.mSpaceMain;
    }

    protected float minRemoveOffset() {
        return -this.mDecoratedMeasurement - this.mOrientationHelper.getStartAfterPadding() - this.mSpaceMain;
    }

    public int getCurrentPosition() {
        if (this.getItemCount() == 0) {
            return 0;
        }
        int position = this.getCurrentPositionOffset();
        if (!this.mInfinite) {
            return Math.abs(position);
        }
        position = !this.mShouldReverseLayout ? (position >= 0 ? position % this.getItemCount() : this.getItemCount() + position % this.getItemCount()) : (position > 0 ? this.getItemCount() - position % this.getItemCount() : -position % this.getItemCount());
        return position == this.getItemCount() ? 0 : position;
    }

    public View findViewByPosition(int position) {
        int itemCount = this.getItemCount();
        if (itemCount == 0) {
            return null;
        }
        for (int i = 0; i < this.positionCache.size(); ++i) {
            int key = this.positionCache.keyAt(i);
            if (key >= 0) {
                if (position != key % itemCount) continue;
                return (View)this.positionCache.valueAt(i);
            }
            int delta = key % itemCount;
            if (delta == 0) {
                delta = -itemCount;
            }
            if (itemCount + delta != position) continue;
            return (View)this.positionCache.valueAt(i);
        }
        return null;
    }

    private int getCurrentPositionOffset() {
        return Math.round(this.mOffset / this.mInterval);
    }

    private float getOffsetOfRightAdapterPosition() {
        if (this.mShouldReverseLayout) {
            return this.mInfinite ? (this.mOffset <= 0.0f ? this.mOffset % (this.mInterval * (float)this.getItemCount()) : (float)this.getItemCount() * -this.mInterval + this.mOffset % (this.mInterval * (float)this.getItemCount())) : this.mOffset;
        }
        return this.mInfinite ? (this.mOffset >= 0.0f ? this.mOffset % (this.mInterval * (float)this.getItemCount()) : (float)this.getItemCount() * this.mInterval + this.mOffset % (this.mInterval * (float)this.getItemCount())) : this.mOffset;
    }

    public int getOffsetToCenter() {
        if (this.mInfinite) {
            return (int)(((float)this.getCurrentPositionOffset() * this.mInterval - this.mOffset) * this.getDistanceRatio());
        }
        return (int)(((float)this.getCurrentPosition() * (!this.mShouldReverseLayout ? this.mInterval : -this.mInterval) - this.mOffset) * this.getDistanceRatio());
    }

    public int getOffsetToPosition(int position) {
        if (this.mInfinite) {
            return (int)(((float)(this.getCurrentPositionOffset() + (!this.mShouldReverseLayout ? position - this.getCurrentPosition() : this.getCurrentPosition() - position)) * this.mInterval - this.mOffset) * this.getDistanceRatio());
        }
        return (int)(((float)position * (!this.mShouldReverseLayout ? this.mInterval : -this.mInterval) - this.mOffset) * this.getDistanceRatio());
    }

    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
    }

    public void setInfinite(boolean enable) {
        this.assertNotInLayoutOrScroll(null);
        if (enable == this.mInfinite) {
            return;
        }
        this.mInfinite = enable;
        this.requestLayout();
    }

    public boolean getInfinite() {
        return this.mInfinite;
    }

    public int getDistanceToBottom() {
        return this.mDistanceToBottom == Integer.MAX_VALUE ? (this.getTotalSpaceInOther() - this.mDecoratedMeasurementInOther) / 2 : this.mDistanceToBottom;
    }

    public void setDistanceToBottom(int mDistanceToBottom) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mDistanceToBottom == mDistanceToBottom) {
            return;
        }
        this.mDistanceToBottom = mDistanceToBottom;
        this.removeAllViews();
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    public void setEnableBringCenterToFront(boolean bringCenterToTop) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mEnableBringCenterToFront == bringCenterToTop) {
            return;
        }
        this.mEnableBringCenterToFront = bringCenterToTop;
        this.requestLayout();
    }

    public boolean getEnableBringCenterToFront() {
        return this.mEnableBringCenterToFront;
    }

    public boolean getSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public static interface OnPageChangeListener {
        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }

    private static class SavedState
    implements Parcelable {
        int position;
        float offset;
        boolean isReverseLayout;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
        }

        SavedState(Parcel in) {
            this.position = in.readInt();
            this.offset = in.readFloat();
            this.isReverseLayout = in.readInt() == 1;
        }

        public SavedState(SavedState other) {
            this.position = other.position;
            this.offset = other.offset;
            this.isReverseLayout = other.isReverseLayout;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.position);
            dest.writeFloat(this.offset);
            dest.writeInt(this.isReverseLayout ? 1 : 0);
        }
    }
}

