/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.recycler;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.banner.recycler.BannerLayout;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerViewBannerBase<L extends RecyclerView.LayoutManager, A extends RecyclerView.Adapter>
extends FrameLayout {
    private static final int WHAT_AUTO_PLAY = 1000;
    protected RecyclerView mIndicatorContainer;
    protected IndicatorAdapter mIndicatorAdapter;
    protected int mIndicatorMargin;
    protected boolean mShowIndicator;
    protected Drawable mSelectedDrawable;
    protected Drawable mUnselectedDrawable;
    protected RecyclerView mRecyclerView;
    protected A mAdapter;
    protected L mLayoutManager;
    protected boolean mIsAutoPlaying;
    protected int mAutoPlayDuration = 4000;
    protected boolean mHasInit;
    protected int mBannerSize = 1;
    protected int mCurrentIndex;
    protected boolean mIsPlaying;
    protected List<String> mTempUrlList = new ArrayList<String>();
    private BannerLayout.OnIndicatorIndexChangedListener mOnIndicatorIndexChangedListener;
    protected Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == 1000) {
                RecyclerViewBannerBase.this.mRecyclerView.smoothScrollToPosition(++RecyclerViewBannerBase.this.mCurrentIndex);
                RecyclerViewBannerBase.this.refreshIndicator();
                RecyclerViewBannerBase.this.mHandler.sendEmptyMessageDelayed(1000, (long)RecyclerViewBannerBase.this.mAutoPlayDuration);
            }
            return false;
        }
    });

    public RecyclerViewBannerBase(Context context) {
        this(context, null);
    }

    public RecyclerViewBannerBase(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerViewBannerBase(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    protected void initView(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RecyclerViewBannerBase);
        this.mShowIndicator = typedArray.getBoolean(R.styleable.RecyclerViewBannerBase_rvbb_showIndicator, true);
        this.mAutoPlayDuration = typedArray.getInt(R.styleable.RecyclerViewBannerBase_rvbb_interval, 4000);
        this.mIsAutoPlaying = typedArray.getBoolean(R.styleable.RecyclerViewBannerBase_rvbb_autoPlaying, true);
        this.mSelectedDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.RecyclerViewBannerBase_rvbb_indicatorSelectedSrc);
        this.mUnselectedDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.RecyclerViewBannerBase_rvbb_indicatorUnselectedSrc);
        int indicatorSize = typedArray.getDimensionPixelSize(R.styleable.RecyclerViewBannerBase_rvbb_indicatorSize, ResUtils.getDimensionPixelSize(context, R.dimen.default_recycler_banner_indicatorSize));
        int indicatorSelectedColor = typedArray.getColor(R.styleable.RecyclerViewBannerBase_rvbb_indicatorSelectedColor, -65536);
        int indicatorUnselectedColor = typedArray.getColor(R.styleable.RecyclerViewBannerBase_rvbb_indicatorUnselectedColor, -7829368);
        if (this.mSelectedDrawable == null) {
            GradientDrawable selectedGradientDrawable = new GradientDrawable();
            selectedGradientDrawable.setShape(1);
            selectedGradientDrawable.setColor(indicatorSelectedColor);
            selectedGradientDrawable.setSize(indicatorSize, indicatorSize);
            selectedGradientDrawable.setCornerRadius((float)(indicatorSize >> 1));
            this.mSelectedDrawable = new LayerDrawable(new Drawable[]{selectedGradientDrawable});
        }
        if (this.mUnselectedDrawable == null) {
            GradientDrawable unSelectedGradientDrawable = new GradientDrawable();
            unSelectedGradientDrawable.setShape(1);
            unSelectedGradientDrawable.setColor(indicatorUnselectedColor);
            unSelectedGradientDrawable.setSize(indicatorSize, indicatorSize);
            unSelectedGradientDrawable.setCornerRadius((float)(indicatorSize >> 1));
            this.mUnselectedDrawable = new LayerDrawable(new Drawable[]{unSelectedGradientDrawable});
        }
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.RecyclerViewBannerBase_rvbb_indicatorSpace, ResUtils.getDimensionPixelSize(context, R.dimen.default_recycler_banner_indicatorSpace));
        int marginLeft = typedArray.getDimensionPixelSize(R.styleable.RecyclerViewBannerBase_rvbb_indicatorMarginLeft, ResUtils.getDimensionPixelSize(context, R.dimen.default_recycler_banner_indicatorMarginLeft));
        int marginRight = typedArray.getDimensionPixelSize(R.styleable.RecyclerViewBannerBase_rvbb_indicatorMarginRight, ResUtils.getDimensionPixelSize(context, R.dimen.default_recycler_banner_indicatorMarginRight));
        int marginBottom = typedArray.getDimensionPixelSize(R.styleable.RecyclerViewBannerBase_rvbb_indicatorMarginBottom, ResUtils.getDimensionPixelSize(context, R.dimen.default_recycler_banner_indicatorMarginBottom));
        int g = typedArray.getInt(R.styleable.RecyclerViewBannerBase_rvbb_indicatorGravity, 0);
        int gravity = g == 0 ? 0x800003 : (g == 2 ? 0x800005 : 17);
        int orientation = typedArray.getInt(R.styleable.RecyclerViewBannerBase_rvbb_orientation, 0);
        typedArray.recycle();
        this.mRecyclerView = new RecyclerView(context);
        new PagerSnapHelper().attachToRecyclerView(this.mRecyclerView);
        this.mLayoutManager = this.getLayoutManager(context, orientation);
        this.mRecyclerView.setLayoutManager(this.mLayoutManager);
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                RecyclerViewBannerBase.this.onBannerScrolled(recyclerView, dx, dy);
            }

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                RecyclerViewBannerBase.this.onBannerScrollStateChanged(recyclerView, newState);
            }
        });
        FrameLayout.LayoutParams vpLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)vpLayoutParams);
        this.mIndicatorContainer = new RecyclerView(context);
        LinearLayoutManager indicatorLayoutManager = new LinearLayoutManager(context, orientation, false);
        this.mIndicatorContainer.setLayoutManager((RecyclerView.LayoutManager)indicatorLayoutManager);
        this.mIndicatorAdapter = new IndicatorAdapter();
        this.mIndicatorContainer.setAdapter((RecyclerView.Adapter)this.mIndicatorAdapter);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 0x50 | gravity;
        params.setMargins(marginLeft, 0, marginRight, marginBottom);
        this.addView((View)this.mIndicatorContainer, (ViewGroup.LayoutParams)params);
        if (!this.mShowIndicator) {
            this.mIndicatorContainer.setVisibility(8);
        }
    }

    protected void onBannerScrolled(RecyclerView recyclerView, int dx, int dy) {
    }

    protected void onBannerScrollStateChanged(RecyclerView recyclerView, int newState) {
    }

    protected abstract L getLayoutManager(Context var1, int var2);

    protected abstract A getAdapter(Context var1, List<String> var2, OnBannerItemClickListener var3);

    public void setIndicatorInterval(int millisecond) {
        this.mAutoPlayDuration = millisecond;
    }

    protected synchronized void setPlaying(boolean playing) {
        if (this.mIsAutoPlaying && this.mHasInit) {
            if (!this.mIsPlaying && playing) {
                this.mHandler.sendEmptyMessageDelayed(1000, (long)this.mAutoPlayDuration);
                this.mIsPlaying = true;
            } else if (this.mIsPlaying && !playing) {
                this.mHandler.removeMessages(1000);
                this.mIsPlaying = false;
            }
        }
    }

    public void setAutoPlaying(boolean isAutoPlaying) {
        this.mIsAutoPlaying = isAutoPlaying;
        this.setPlaying(this.mIsAutoPlaying);
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public void setShowIndicator(boolean showIndicator) {
        this.mShowIndicator = showIndicator;
        this.mIndicatorContainer.setVisibility(showIndicator ? 0 : 8);
    }

    public void initBannerImageView(@NonNull List<String> newList, OnBannerItemClickListener onBannerItemClickListener) {
        if (this.compareListDifferent(newList, this.mTempUrlList)) {
            this.mHasInit = false;
            this.setVisibility(0);
            this.setPlaying(false);
            this.mAdapter = this.getAdapter(this.getContext(), newList, onBannerItemClickListener);
            this.mRecyclerView.setAdapter(this.mAdapter);
            this.mTempUrlList = newList;
            this.mBannerSize = this.mTempUrlList.size();
            if (this.mBannerSize > 1) {
                this.mIndicatorContainer.setVisibility(0);
                this.mCurrentIndex = this.mBannerSize * 10000;
                this.mRecyclerView.scrollToPosition(this.mCurrentIndex);
                this.mIndicatorAdapter.notifyDataSetChanged();
                this.setPlaying(true);
            } else {
                this.mIndicatorContainer.setVisibility(8);
                this.mCurrentIndex = 0;
            }
            this.mHasInit = true;
        }
        if (!this.mShowIndicator) {
            this.mIndicatorContainer.setVisibility(8);
        }
    }

    public void initBannerImageView(@NonNull List<String> newList) {
        this.initBannerImageView(newList, null);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.setPlaying(false);
                break;
            }
            case 1: 
            case 3: {
                this.setPlaying(true);
                break;
            }
        }
        try {
            return super.dispatchTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setPlaying(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setPlaying(false);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.setPlaying(true);
        } else {
            this.setPlaying(false);
        }
    }

    protected synchronized void refreshIndicator() {
        if (this.mBannerSize > 1) {
            int position = this.mCurrentIndex % this.mBannerSize;
            if (this.mShowIndicator) {
                this.mIndicatorAdapter.setPosition(position);
                this.mIndicatorAdapter.notifyDataSetChanged();
            }
            if (this.mOnIndicatorIndexChangedListener != null) {
                this.mOnIndicatorIndexChangedListener.onIndexChanged(position);
            }
        }
    }

    public RecyclerViewBannerBase setOnIndicatorIndexChangedListener(BannerLayout.OnIndicatorIndexChangedListener onIndicatorIndexChangedListener) {
        this.mOnIndicatorIndexChangedListener = onIndicatorIndexChangedListener;
        return this;
    }

    protected int getColor(@ColorRes int color2) {
        return ContextCompat.getColor((Context)this.getContext(), (int)color2);
    }

    protected boolean compareListDifferent(List<String> newTabList, List<String> oldTabList) {
        if (oldTabList == null || oldTabList.isEmpty()) {
            return true;
        }
        if (newTabList.size() != oldTabList.size()) {
            return true;
        }
        for (int i = 0; i < newTabList.size(); ++i) {
            if (TextUtils.isEmpty((CharSequence)newTabList.get(i))) {
                return true;
            }
            if (newTabList.get(i).equals(oldTabList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static interface OnIndicatorIndexChangedListener {
        public void onIndexChanged(int var1);
    }

    public static interface OnBannerItemClickListener {
        public void onItemClick(int var1);
    }

    protected class IndicatorAdapter
    extends RecyclerView.Adapter {
        int currentPosition = 0;

        protected IndicatorAdapter() {
        }

        public void setPosition(int currentPosition) {
            this.currentPosition = currentPosition;
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ImageView bannerPoint = new ImageView(RecyclerViewBannerBase.this.getContext());
            RecyclerView.LayoutParams lp = new RecyclerView.LayoutParams(-2, -2);
            lp.setMargins(RecyclerViewBannerBase.this.mIndicatorMargin, RecyclerViewBannerBase.this.mIndicatorMargin, RecyclerViewBannerBase.this.mIndicatorMargin, RecyclerViewBannerBase.this.mIndicatorMargin);
            bannerPoint.setLayoutParams((ViewGroup.LayoutParams)lp);
            return new RecyclerView.ViewHolder((View)bannerPoint){};
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            ImageView bannerPoint = (ImageView)holder.itemView;
            bannerPoint.setImageDrawable(this.currentPosition == position ? RecyclerViewBannerBase.this.mSelectedDrawable : RecyclerViewBannerBase.this.mUnselectedDrawable);
        }

        public int getItemCount() {
            return RecyclerViewBannerBase.this.mBannerSize;
        }
    }
}

