/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.anim;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.Interpolator;

public abstract class BaseAnimator {
    protected long mDuration = 500L;
    protected AnimatorSet mAnimatorSet = new AnimatorSet();
    private Interpolator mInterpolator;
    private long mDelay;
    private AnimatorListener mListener;

    public abstract void setAnimation(View var1);

    protected void start(View view) {
        BaseAnimator.reset(view);
        this.setAnimation(view);
        this.mAnimatorSet.setDuration(this.mDuration);
        if (this.mInterpolator != null) {
            this.mAnimatorSet.setInterpolator((TimeInterpolator)this.mInterpolator);
        }
        if (this.mDelay > 0L) {
            this.mAnimatorSet.setStartDelay(this.mDelay);
        }
        if (this.mListener != null) {
            this.mAnimatorSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    BaseAnimator.this.mListener.onAnimationStart(animator);
                }

                public void onAnimationRepeat(Animator animator) {
                    BaseAnimator.this.mListener.onAnimationRepeat(animator);
                }

                public void onAnimationEnd(Animator animator) {
                    BaseAnimator.this.mListener.onAnimationEnd(animator);
                }

                public void onAnimationCancel(Animator animator) {
                    BaseAnimator.this.mListener.onAnimationCancel(animator);
                }
            });
        }
        this.mAnimatorSet.start();
    }

    public static void reset(View view) {
        view.setAlpha(1.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
        view.setRotation(0.0f);
        view.setRotationY(0.0f);
        view.setRotationX(0.0f);
    }

    public BaseAnimator duration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public BaseAnimator delay(long delay) {
        this.mDelay = delay;
        return this;
    }

    public BaseAnimator interpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
        return this;
    }

    public BaseAnimator listener(AnimatorListener listener) {
        this.mListener = listener;
        return this;
    }

    public void playOn(View view) {
        this.start(view);
    }

    public static interface AnimatorListener {
        public void onAnimationStart(Animator var1);

        public void onAnimationRepeat(Animator var1);

        public void onAnimationEnd(Animator var1);

        public void onAnimationCancel(Animator var1);
    }
}

