/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.alpha;

import android.view.View;
import androidx.annotation.NonNull;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.alpha.IAlphaViewHelper;
import java.lang.ref.WeakReference;

public class XUIAlphaViewHelper
implements IAlphaViewHelper {
    private WeakReference<View> mTarget;
    private boolean mChangeAlphaWhenPress;
    private boolean mChangeAlphaWhenDisable;
    private float mNormalAlpha = 1.0f;
    private float mPressedAlpha;
    private float mDisabledAlpha;

    public XUIAlphaViewHelper(@NonNull View target) {
        this.mTarget = new WeakReference<View>(target);
        this.mChangeAlphaWhenPress = ThemeUtils.resolveBoolean(target.getContext(), R.attr.xui_switch_alpha_pressed, true);
        this.mChangeAlphaWhenDisable = ThemeUtils.resolveBoolean(target.getContext(), R.attr.xui_switch_alpha_disabled, true);
        this.mPressedAlpha = ThemeUtils.resolveFloat(target.getContext(), R.attr.xui_alpha_pressed, 0.5f);
        this.mDisabledAlpha = ThemeUtils.resolveFloat(target.getContext(), R.attr.xui_alpha_disabled, 0.5f);
    }

    public XUIAlphaViewHelper(@NonNull View target, float pressedAlpha, float disabledAlpha) {
        this.mTarget = new WeakReference<View>(target);
        this.mPressedAlpha = pressedAlpha;
        this.mDisabledAlpha = disabledAlpha;
    }

    @Override
    public void onPressedChanged(View current, boolean pressed) {
        View target = (View)this.mTarget.get();
        if (target == null) {
            return;
        }
        if (current.isEnabled()) {
            target.setAlpha(this.mChangeAlphaWhenPress && pressed && current.isClickable() ? this.mPressedAlpha : this.mNormalAlpha);
        } else if (this.mChangeAlphaWhenDisable) {
            target.setAlpha(this.mDisabledAlpha);
        }
    }

    @Override
    public void onEnabledChanged(View current, boolean enabled) {
        View target = (View)this.mTarget.get();
        if (target == null) {
            return;
        }
        float alphaForIsEnable = this.mChangeAlphaWhenDisable ? (enabled ? this.mNormalAlpha : this.mDisabledAlpha) : this.mNormalAlpha;
        if (current != target && target.isEnabled() != enabled) {
            target.setEnabled(enabled);
        }
        target.setAlpha(alphaForIsEnable);
    }

    @Override
    public void setChangeAlphaWhenPress(boolean changeAlphaWhenPress) {
        this.mChangeAlphaWhenPress = changeAlphaWhenPress;
    }

    @Override
    public void setChangeAlphaWhenDisable(boolean changeAlphaWhenDisable) {
        this.mChangeAlphaWhenDisable = changeAlphaWhenDisable;
        View target = (View)this.mTarget.get();
        if (target != null) {
            this.onEnabledChanged(target, target.isEnabled());
        }
    }
}

