/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import androidx.appcompat.app.AppCompatActivity;
import com.xuexiang.xui.utils.Utils;

public abstract class BaseSplashActivity
extends AppCompatActivity {
    private static final int DEFAULT_SPLASH_DURATION_MILLIS = 500;
    protected LinearLayout mWelcomeLayout;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initView();
        this.initSplashView(this.getSplashImgResId());
        this.onCreateActivity();
    }

    private void initView() {
        this.mWelcomeLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        this.mWelcomeLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mWelcomeLayout.setOrientation(1);
        this.setContentView((View)this.mWelcomeLayout);
    }

    protected void initSplashView(int splashImgResId) {
        if (splashImgResId != 0) {
            Utils.setBackground((Context)this, (View)this.mWelcomeLayout, splashImgResId);
        }
    }

    protected int getSplashImgResId() {
        return 0;
    }

    protected abstract void onCreateActivity();

    protected abstract void onSplashFinished();

    protected long getSplashDurationMillis() {
        return 500L;
    }

    protected void startSplash(boolean enableAlphaAnim) {
        if (enableAlphaAnim) {
            this.startSplashAnim((Animation)new AlphaAnimation(0.2f, 1.0f));
        } else {
            this.startSplashAnim((Animation)new AlphaAnimation(1.0f, 1.0f));
        }
    }

    private void startSplashAnim(Animation anim2) {
        Utils.checkNull(anim2, "Splash Animation can not be null");
        anim2.setDuration(this.getSplashDurationMillis());
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                BaseSplashActivity.this.onSplashFinished();
            }
        });
        this.mWelcomeLayout.startAnimation(anim2);
    }

    protected void onDestroy() {
        Utils.recycleBackground((View)this.mWelcomeLayout);
        super.onDestroy();
    }
}

