/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.XUIObservableScrollView;

public class XUIWrapContentScrollView
extends XUIObservableScrollView {
    private int mMaxHeight = 0x1FFFFFFF;

    public XUIWrapContentScrollView(Context context) {
        super(context);
    }

    public XUIWrapContentScrollView(Context context, int maxHeight) {
        super(context);
        this.mMaxHeight = maxHeight;
    }

    public XUIWrapContentScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public XUIWrapContentScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XUIWrapContentScrollView);
        if (ta != null) {
            this.mMaxHeight = ta.getDimensionPixelSize(R.styleable.XUIWrapContentScrollView_wcsv_max_height, this.mMaxHeight);
            ta.recycle();
        }
    }

    public void setMaxHeight(int maxHeight) {
        if (this.mMaxHeight != maxHeight) {
            this.mMaxHeight = maxHeight;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        int expandSpec = lp.height > 0 && lp.height <= this.mMaxHeight ? View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }
}

