/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ExpandableListView;
import com.xuexiang.xui.R;

public class XUIWrapContentExpandableListView
extends ExpandableListView {
    private int mMaxHeight = 0x1FFFFFFF;

    public XUIWrapContentExpandableListView(Context context) {
        super(context);
    }

    public XUIWrapContentExpandableListView(Context context, int maxHeight) {
        super(context);
        this.mMaxHeight = maxHeight;
    }

    public XUIWrapContentExpandableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public XUIWrapContentExpandableListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XUIWrapContentExpandableListView);
        if (ta != null) {
            this.mMaxHeight = ta.getDimensionPixelSize(R.styleable.XUIWrapContentExpandableListView_wcelv_max_height, this.mMaxHeight);
            ta.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }

    public void setMaxHeight(int maxHeight) {
        if (this.mMaxHeight != maxHeight) {
            this.mMaxHeight = maxHeight;
            this.requestLayout();
        }
    }
}

