/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.widget.toast.XToast;

public final class XToastUtils {
    private static final int DEFAULT_ALPHA = 200;
    private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

    private XToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @MainThread
    public static void toast(final @NonNull CharSequence message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.normal(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void toast(final @StringRes int message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.normal(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void toast(final @NonNull CharSequence message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.normal(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void toast(final @StringRes int message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.normal(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void error(final @NonNull CharSequence message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.error(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void error(@NonNull Throwable error) {
        final String message = error.getMessage() != null ? error.getMessage() : "";
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.error(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void error(final @StringRes int message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.error(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void error(final @NonNull CharSequence message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.error(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void error(final @StringRes int message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.error(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void success(final @NonNull CharSequence message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.success(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void success(final @StringRes int message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.success(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void success(final @NonNull CharSequence message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.success(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void success(final @StringRes int message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.success(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void info(final @NonNull CharSequence message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.info(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void info(final @StringRes int message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.info(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void info(final @NonNull CharSequence message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.info(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void info(final @StringRes int message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.info(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void warning(final @NonNull CharSequence message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.warning(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void warning(final @StringRes int message) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.warning(XUI.getContext(), message).show();
            }
        });
    }

    @MainThread
    public static void warning(final @NonNull CharSequence message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.warning(XUI.getContext(), message, duration).show();
            }
        });
    }

    @MainThread
    public static void warning(final @StringRes int message, final int duration) {
        XToastUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XToast.warning(XUI.getContext(), message, duration).show();
            }
        });
    }

    private static void runOnUiThread(@NonNull Runnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            MAIN_HANDLER.post(runnable);
        }
    }

    static {
        XToast.Config.get().setAlpha(200).setToastTypeface(XUI.getDefaultTypeface()).allowQueue(false);
    }
}

