/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.LayoutInflaterCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.tabs.TabLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.adapter.recyclerview.DividerItemDecoration;
import com.xuexiang.xui.adapter.recyclerview.GridDividerItemDecoration;
import com.xuexiang.xui.adapter.recyclerview.XGridLayoutManager;
import com.xuexiang.xui.adapter.recyclerview.XLinearLayoutManager;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.ViewUtils;
import com.xuexiang.xui.widget.dialog.LoadingDialog;
import com.xuexiang.xui.widget.dialog.MiniLoadingDialog;
import com.xuexiang.xui.widget.progress.loading.IMessageLoader;
import com.xuexiang.xui.widget.progress.loading.LoadingViewLayout;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class WidgetUtils {
    private WidgetUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void requestFullScreen(@NonNull Activity activity) {
        activity.requestWindowFeature(1);
        activity.getWindow().setFlags(1024, 1024);
    }

    public static void initSpinnerStyle(@NonNull Spinner spinner, @NonNull String[] items) {
        WidgetUtils.initSpinnerStyle(spinner);
        WidgetUtils.initSpinnerItem(spinner, items);
    }

    public static void initSpinnerStyle(@NonNull Spinner spinner) {
        spinner.setBackground(ResUtils.getDrawable(spinner.getContext(), R.drawable.xui_config_bg_spinner));
        ViewUtils.setPaddingEnd((View)spinner, ResUtils.getDimensionPixelSize(spinner.getContext(), R.dimen.default_spinner_icon_padding_size));
        spinner.setPopupBackgroundDrawable(ResUtils.getDrawable(spinner.getContext(), R.drawable.ms_drop_down_bg_radius));
        WidgetUtils.setSpinnerDropDownVerticalOffset(spinner);
    }

    public static void initSpinnerItem(@NonNull Spinner spinner, @NonNull String[] items) {
        ArrayAdapter adapter = new ArrayAdapter(spinner.getContext(), R.layout.xui_layout_spinner_selected_item, R.id.spinner_item, (Object[])items);
        adapter.setDropDownViewResource(R.layout.xui_layout_spinner_drop_down_item);
        spinner.setAdapter((SpinnerAdapter)adapter);
    }

    public static void setSpinnerDropDownVerticalOffset(@NonNull Spinner spinner) {
        int itemHeight = ThemeUtils.resolveDimension(spinner.getContext(), R.attr.ms_item_height_size);
        int dropdownOffset = ThemeUtils.resolveDimension(spinner.getContext(), R.attr.ms_dropdown_offset);
        if (Build.VERSION.SDK_INT < 21) {
            spinner.setDropDownVerticalOffset(0);
        } else {
            spinner.setDropDownVerticalOffset(itemHeight + dropdownOffset);
        }
    }

    public static TabLayout.Tab addTabWithoutRipple(@NonNull TabLayout tabLayout, @Nullable CharSequence text, @DrawableRes int resId) {
        TabLayout.Tab tab = tabLayout.newTab();
        tab.setText(text);
        tab.setIcon(resId);
        tab.view.setBackgroundColor(0);
        tabLayout.addTab(tab);
        return tab;
    }

    public static TabLayout.Tab addTabWithoutRipple(@NonNull TabLayout tabLayout, @Nullable CharSequence text, @Nullable Drawable icon) {
        TabLayout.Tab tab = tabLayout.newTab();
        tab.setText(text);
        tab.setIcon(icon);
        tab.view.setBackgroundColor(0);
        tabLayout.addTab(tab);
        return tab;
    }

    public static void setTabLayoutTextFont(TabLayout tabLayout) {
        WidgetUtils.setTabLayoutTextFont(tabLayout, XUI.getDefaultTypeface());
    }

    public static void setTabLayoutTextFont(TabLayout tabLayout, Typeface typeface) {
        if (tabLayout == null || typeface == null) {
            return;
        }
        ViewGroup vg = (ViewGroup)tabLayout.getChildAt(0);
        int tabsCount = vg.getChildCount();
        for (int i = 0; i < tabsCount; ++i) {
            ViewGroup vgTab = (ViewGroup)vg.getChildAt(i);
            int tabCount = vgTab.getChildCount();
            for (int j = 0; j < tabCount; ++j) {
                View tabViewChild = vgTab.getChildAt(j);
                if (!(tabViewChild instanceof TextView)) continue;
                ((TextView)tabViewChild).setTypeface(typeface);
            }
        }
    }

    public static void initGridRecyclerView(@NonNull RecyclerView recyclerView, int spanCount) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XGridLayoutManager(recyclerView.getContext(), spanCount));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration(recyclerView.getContext(), spanCount));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initGridRecyclerView(@NonNull RecyclerView recyclerView, int spanCount, int dividerWidth) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XGridLayoutManager(recyclerView.getContext(), spanCount));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration(recyclerView.getContext(), spanCount, dividerWidth));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initGridRecyclerView(@NonNull RecyclerView recyclerView, int spanCount, int dividerWidth, int dividerColor) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XGridLayoutManager(recyclerView.getContext(), spanCount));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration(recyclerView.getContext(), spanCount, dividerWidth, dividerColor));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initGridRecyclerView(@NonNull RecyclerView recyclerView, boolean canScroll, int spanCount, int dividerWidth, int dividerColor) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XGridLayoutManager(recyclerView.getContext(), spanCount).setScrollEnabled(canScroll));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration(recyclerView.getContext(), spanCount, dividerWidth, dividerColor));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initRecyclerView(@NonNull RecyclerView recyclerView) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XLinearLayoutManager(recyclerView.getContext()));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(recyclerView.getContext(), 1));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initRecyclerView(@NonNull RecyclerView recyclerView, int dividerHeight) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XLinearLayoutManager(recyclerView.getContext()));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(recyclerView.getContext(), 1, dividerHeight));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initRecyclerView(@NonNull RecyclerView recyclerView, int dividerHeight, int dividerColor) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XLinearLayoutManager(recyclerView.getContext()));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(recyclerView.getContext(), 1, dividerHeight, dividerColor));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static void initRecyclerView(@NonNull RecyclerView recyclerView, boolean canScroll, int dividerHeight, int dividerColor) {
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new XLinearLayoutManager(recyclerView.getContext()).setScrollEnabled(canScroll));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(recyclerView.getContext(), 1, dividerHeight, dividerColor));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    public static Bundle getChangePayload(List<Object> payloads) {
        if (payloads == null || payloads.isEmpty()) {
            return null;
        }
        for (Object payload : payloads) {
            if (!(payload instanceof Bundle)) continue;
            return (Bundle)payload;
        }
        return null;
    }

    public static LoadingDialog getLoadingDialog(@NonNull Context context) {
        return new LoadingDialog(context);
    }

    public static LoadingDialog getLoadingDialog(@NonNull Context context, @NonNull String message) {
        return new LoadingDialog(context, message);
    }

    public static LoadingDialog updateLoadingMessage(LoadingDialog loadingDialog, @NonNull Context context, @NonNull String message) {
        if (loadingDialog == null) {
            loadingDialog = WidgetUtils.getLoadingDialog(context);
        }
        loadingDialog.updateMessage(message);
        loadingDialog.show();
        return loadingDialog;
    }

    public static IMessageLoader getMessageLoader(boolean isDialog, @NonNull Context context) {
        return isDialog ? new LoadingDialog(context) : new LoadingViewLayout(context);
    }

    public static MiniLoadingDialog getMiniLoadingDialog(@NonNull Context context) {
        return new MiniLoadingDialog(context);
    }

    public static MiniLoadingDialog getMiniLoadingDialog(@NonNull Context context, @NonNull String message) {
        return new MiniLoadingDialog(context, message);
    }

    public static void transparentBottomSheetDialogBackground(BottomSheetDialog dialog) {
        FrameLayout frameLayout;
        if (dialog != null && dialog.getWindow() != null && (frameLayout = (FrameLayout)dialog.getWindow().findViewById(R.id.design_bottom_sheet)) != null) {
            frameLayout.setBackgroundColor(0);
        }
    }

    public static void clearActivityBackground(Activity activity) {
        if (activity == null) {
            return;
        }
        WidgetUtils.clearWindowBackground(activity.getWindow());
    }

    public static void clearWindowBackground(Window window) {
        if (window == null) {
            return;
        }
        window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
    }

    public static void clearViewBackground(View view) {
        if (view == null) {
            return;
        }
        view.setBackgroundColor(0);
    }

    public static void clearAllViewBackground(View view) {
        if (view == null) {
            return;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                WidgetUtils.clearAllViewBackground(viewGroup.getChildAt(i));
            }
        }
        view.setBackgroundColor(0);
    }

    public static Activity findActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            ContextWrapper wrapper = (ContextWrapper)context;
            return WidgetUtils.findActivity(wrapper.getBaseContext());
        }
        return null;
    }

    public static void setViewParentNotClip(@NonNull View targetView) {
        ViewGroup parent = (ViewGroup)targetView.getParent();
        if (parent == null) {
            return;
        }
        parent.setClipChildren(false);
        parent.setClipToPadding(false);
    }

    public static void installLayoutInflaterLogger(@NonNull AppCompatActivity activity) {
        WidgetUtils.installLayoutInflaterLogger(activity, "LayoutInflater", 5L);
    }

    public static void installLayoutInflaterLogger(final @NonNull AppCompatActivity activity, final @NonNull String loggerTag, final long limitCost) {
        LayoutInflaterCompat.setFactory2((LayoutInflater)activity.getLayoutInflater(), (LayoutInflater.Factory2)new LayoutInflater.Factory2(){

            @Nullable
            public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
                long startNanos = System.nanoTime();
                View view = activity.getDelegate().createView(parent, name, context, attrs);
                long cost = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                if (cost > limitCost) {
                    UILog.eTag(loggerTag, "LoadWidget:" + name + ", cost:" + cost + " ms");
                } else {
                    UILog.dTag(loggerTag, "LoadWidget:" + name + ", cost:" + cost + " ms");
                }
                return view;
            }

            @Nullable
            public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
                return null;
            }
        });
    }
}

