/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import android.view.Window;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.widget.imageview.ImageLoader;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class ViewUtils {
    private static final AtomicInteger ATOMIC_INTEGER = new AtomicInteger(1);
    private static final int[] APPCOMPAT_CHECK_ATTRS = new int[]{R.attr.colorPrimary};

    private ViewUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void checkAppCompatTheme(Context context) {
        TypedArray a = context.obtainStyledAttributes(APPCOMPAT_CHECK_ATTRS);
        boolean failed = !a.hasValue(0);
        a.recycle();
        if (failed) {
            throw new IllegalArgumentException("You need to use a Theme.AppCompat theme (or descendant) with the design library.");
        }
    }

    public static View getActivityRoot(Activity activity) {
        return ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
    }

    public static void requestApplyInsets(Window window) {
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            window.getDecorView().requestFitSystemWindows();
        } else if (Build.VERSION.SDK_INT >= 21) {
            window.getDecorView().requestApplyInsets();
        }
    }

    @TargetApi(value=16)
    public static void setBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static void setBackgroundKeepingPadding(View view, Drawable drawable2) {
        int[] padding = new int[]{view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom()};
        ViewUtils.setBackground(view, drawable2);
        view.setPadding(padding[0], padding[1], padding[2], padding[3]);
    }

    public static void setBackgroundKeepingPadding(View view, int backgroundResId) {
        ViewUtils.setBackgroundKeepingPadding(view, ContextCompat.getDrawable((Context)view.getContext(), (int)backgroundResId));
    }

    public static void setBackgroundColorKeepPadding(View view, @ColorInt int color2) {
        int[] padding = new int[]{view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom()};
        view.setBackgroundColor(color2);
        view.setPadding(padding[0], padding[1], padding[2], padding[3]);
    }

    public static void playBackgroundBlinkAnimation(View v, @ColorInt int bgColor) {
        if (v == null) {
            return;
        }
        int[] alphaArray = new int[]{0, 255, 0};
        ViewUtils.playViewBackgroundAnimation(v, bgColor, alphaArray, 300);
    }

    public static Animator playViewBackgroundAnimation(final View v, @ColorInt int bgColor, int[] alphaArray, int stepDuration, final Runnable endAction) {
        int animationCount = alphaArray.length - 1;
        ColorDrawable bgDrawable = new ColorDrawable(bgColor);
        final Drawable oldBgDrawable = v.getBackground();
        ViewUtils.setBackgroundKeepingPadding(v, (Drawable)bgDrawable);
        ArrayList<ObjectAnimator> animatorList = new ArrayList<ObjectAnimator>();
        for (int i = 0; i < animationCount; ++i) {
            ObjectAnimator animator = ObjectAnimator.ofInt((Object)v.getBackground(), (String)"alpha", (int[])new int[]{alphaArray[i], alphaArray[i + 1]});
            animatorList.add(animator);
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration((long)stepDuration);
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ViewUtils.setBackgroundKeepingPadding(v, oldBgDrawable);
                if (endAction != null) {
                    endAction.run();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.playSequentially(animatorList);
        animatorSet.start();
        return animatorSet;
    }

    public static void playViewBackgroundAnimation(View v, @ColorInt int bgColor, int[] alphaArray, int stepDuration) {
        ViewUtils.playViewBackgroundAnimation(v, bgColor, alphaArray, stepDuration, null);
    }

    public static void playViewBackgroundAnimation(final View v, @ColorInt int startColor, @ColorInt int endColor, long duration, int repeatCount, int setAnimTagId, final Runnable endAction) {
        final Drawable oldBgDrawable = v.getBackground();
        ViewUtils.setBackgroundColorKeepPadding(v, startColor);
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(new int[]{startColor, endColor});
        anim2.setDuration(duration / (long)(repeatCount + 1));
        anim2.setRepeatCount(repeatCount);
        anim2.setRepeatMode(2);
        anim2.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ViewUtils.setBackgroundColorKeepPadding(v, (Integer)animation.getAnimatedValue());
            }
        });
        if (setAnimTagId != 0) {
            v.setTag(setAnimTagId, (Object)anim2);
        }
        anim2.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ViewUtils.setBackgroundKeepingPadding(v, oldBgDrawable);
                if (endAction != null) {
                    endAction.run();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        anim2.start();
    }

    public static void playViewBackgroundAnimation(View v, int startColor, int endColor, long duration) {
        ViewUtils.playViewBackgroundAnimation(v, startColor, endColor, duration, 0, 0, null);
    }

    public static int generateViewId() {
        int newValue;
        int result;
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        do {
            if ((newValue = (result = ATOMIC_INTEGER.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!ATOMIC_INTEGER.compareAndSet(result, newValue));
        return result;
    }

    public static AlphaAnimation fadeIn(View view, int duration, Animation.AnimationListener listener) {
        return ViewUtils.fadeIn(view, duration, listener, true);
    }

    public static AlphaAnimation fadeIn(View view, int duration, Animation.AnimationListener listener, boolean isNeedAnimation) {
        if (view == null) {
            return null;
        }
        if (isNeedAnimation) {
            view.setVisibility(0);
            AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setInterpolator((Interpolator)new DecelerateInterpolator());
            alpha.setDuration((long)duration);
            alpha.setFillAfter(true);
            if (listener != null) {
                alpha.setAnimationListener(listener);
            }
            view.startAnimation((Animation)alpha);
            return alpha;
        }
        view.setAlpha(1.0f);
        view.setVisibility(0);
        return null;
    }

    public static AlphaAnimation fadeOut(View view, int duration, Animation.AnimationListener listener) {
        return ViewUtils.fadeOut(view, duration, listener, true);
    }

    public static AlphaAnimation fadeOut(final View view, int duration, final Animation.AnimationListener listener, boolean isNeedAnimation) {
        if (view == null) {
            return null;
        }
        if (isNeedAnimation) {
            AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
            alpha.setInterpolator((Interpolator)new DecelerateInterpolator());
            alpha.setDuration((long)duration);
            alpha.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (listener != null) {
                        listener.onAnimationStart(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    view.setVisibility(8);
                    if (listener != null) {
                        listener.onAnimationEnd(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (listener != null) {
                        listener.onAnimationRepeat(animation);
                    }
                }
            });
            view.startAnimation((Animation)alpha);
            return alpha;
        }
        view.setVisibility(8);
        return null;
    }

    public static void clearValueAnimator(Animator animator) {
        if (animator != null) {
            animator.removeAllListeners();
            if (animator instanceof ValueAnimator) {
                ((ValueAnimator)animator).removeAllUpdateListeners();
            }
            if (Build.VERSION.SDK_INT >= 19) {
                animator.pause();
            }
            animator.cancel();
        }
    }

    public static Rect calculateViewScreenLocation(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return new Rect(location[0], location[1], location[0] + view.getWidth(), location[1] + view.getHeight());
    }

    @Nullable
    public static TranslateAnimation slideIn(View view, int duration, Animation.AnimationListener listener, Direction direction) {
        return ViewUtils.slideIn(view, duration, listener, true, direction);
    }

    @Nullable
    public static TranslateAnimation slideIn(View view, int duration, Animation.AnimationListener listener, boolean isNeedAnimation, Direction direction) {
        if (view == null) {
            return null;
        }
        if (isNeedAnimation) {
            TranslateAnimation translate = null;
            switch (direction) {
                case LEFT_TO_RIGHT: {
                    translate = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
                    break;
                }
                case TOP_TO_BOTTOM: {
                    translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, -1.0f, 1, 0.0f);
                    break;
                }
                case RIGHT_TO_LEFT: {
                    translate = new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
                    break;
                }
                case BOTTOM_TO_TOP: {
                    translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
                    break;
                }
            }
            translate.setInterpolator((Interpolator)new DecelerateInterpolator());
            translate.setDuration((long)duration);
            translate.setFillAfter(true);
            if (listener != null) {
                translate.setAnimationListener(listener);
            }
            view.setVisibility(0);
            view.startAnimation((Animation)translate);
            return translate;
        }
        view.clearAnimation();
        view.setVisibility(0);
        return null;
    }

    @Nullable
    public static TranslateAnimation slideOut(View view, int duration, Animation.AnimationListener listener, Direction direction) {
        return ViewUtils.slideOut(view, duration, listener, true, direction);
    }

    @Nullable
    public static TranslateAnimation slideOut(final View view, int duration, final Animation.AnimationListener listener, boolean isNeedAnimation, Direction direction) {
        if (view == null) {
            return null;
        }
        if (isNeedAnimation) {
            TranslateAnimation translate = null;
            switch (direction) {
                case LEFT_TO_RIGHT: {
                    translate = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
                    break;
                }
                case TOP_TO_BOTTOM: {
                    translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
                    break;
                }
                case RIGHT_TO_LEFT: {
                    translate = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
                    break;
                }
                case BOTTOM_TO_TOP: {
                    translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, -1.0f);
                    break;
                }
            }
            translate.setInterpolator((Interpolator)new DecelerateInterpolator());
            translate.setDuration((long)duration);
            translate.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (listener != null) {
                        listener.onAnimationStart(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    view.setVisibility(8);
                    if (listener != null) {
                        listener.onAnimationEnd(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (listener != null) {
                        listener.onAnimationRepeat(animation);
                    }
                }
            });
            view.startAnimation((Animation)translate);
            return translate;
        }
        view.clearAnimation();
        view.setVisibility(8);
        return null;
    }

    public static void setVisibility(View view, boolean isShow) {
        if (view != null) {
            view.setVisibility(isShow ? 0 : 8);
        }
    }

    public static void setVisibility(View view, int visibility) {
        if (view != null) {
            view.setVisibility(visibility);
        }
    }

    public static void setEnabled(View view, boolean enabled) {
        if (view != null) {
            view.setEnabled(enabled);
            if (view instanceof EditText) {
                view.setFocusable(enabled);
                view.setFocusableInTouchMode(enabled);
            }
        }
    }

    public static void setText(TextView view, String text) {
        if (view != null) {
            view.setText((CharSequence)text);
        }
    }

    public static void setText(TextView view, @StringRes int textId) {
        if (view != null) {
            view.setText(textId);
        }
    }

    public static void textColorId(TextView view, @ColorRes int colorId) {
        if (view != null) {
            view.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)colorId));
        }
    }

    public static void setImageResource(ImageView view, @DrawableRes int imageId) {
        if (view != null) {
            view.setImageResource(imageId);
        }
    }

    public static void setImageDrawable(ImageView view, Drawable drawable2) {
        if (view != null) {
            view.setImageDrawable(drawable2);
        }
    }

    public static void setImageUri(ImageView view, Object uri) {
        if (view != null) {
            ImageLoader.get().loadImage(view, uri);
        }
    }

    public static void setImageLevel(ImageView view, int level) {
        if (view != null) {
            view.setImageLevel(level);
        }
    }

    public static void setImageTint(ImageView view, ColorStateList tint) {
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            view.setImageTintList(tint);
        }
    }

    public static void setChecked(CompoundButton view, boolean isCheck) {
        if (view != null) {
            view.setChecked(isCheck);
        }
    }

    public static void setOnCheckedChangeListener(CompoundButton view, CompoundButton.OnCheckedChangeListener checkedChangeListener) {
        if (view != null) {
            view.setOnCheckedChangeListener(checkedChangeListener);
        }
    }

    public static void setCheckedSilent(CompoundButton view, boolean isCheck, CompoundButton.OnCheckedChangeListener checkedChangeListener) {
        if (view != null) {
            view.setOnCheckedChangeListener(null);
            view.setChecked(isCheck);
            view.setOnCheckedChangeListener(checkedChangeListener);
        }
    }

    public static void expendTouchArea(final View view, final int expendSize) {
        if (view != null) {
            final View parentView = (View)view.getParent();
            parentView.post(new Runnable(){

                @Override
                public void run() {
                    Rect rect = new Rect();
                    view.getHitRect(rect);
                    rect.left -= expendSize;
                    rect.top -= expendSize;
                    rect.right += expendSize;
                    rect.bottom += expendSize;
                    parentView.setTouchDelegate(new TouchDelegate(rect, view));
                }
            });
        }
    }

    public static void setPadding(View view, int padding) {
        if (view != null) {
            view.setPadding(padding, padding, padding, padding);
        }
    }

    public static void setPaddingLeft(View view, int value) {
        if (value != view.getPaddingLeft()) {
            view.setPadding(value, view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public static void setPaddingStart(View view, int value) {
        if (value != view.getPaddingStart()) {
            view.setPaddingRelative(value, view.getPaddingTop(), view.getPaddingEnd(), view.getPaddingBottom());
        }
    }

    public static void setPaddingTop(View view, int value) {
        if (value != view.getPaddingTop()) {
            view.setPadding(view.getPaddingLeft(), value, view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public static void setPaddingRight(View view, int value) {
        if (value != view.getPaddingRight()) {
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), value, view.getPaddingBottom());
        }
    }

    public static void setPaddingEnd(View view, int value) {
        if (value != view.getPaddingEnd()) {
            view.setPaddingRelative(view.getPaddingStart(), view.getPaddingTop(), value, view.getPaddingBottom());
        }
    }

    public static void setPaddingBottom(View view, int value) {
        if (value != view.getPaddingBottom()) {
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), value);
        }
    }

    public static boolean getIsLastLineSpacingExtraError() {
        return Build.VERSION.SDK_INT < 21;
    }

    public static View findViewFromViewStub(View parentView, int viewStubId, int inflatedViewId) {
        if (null == parentView) {
            return null;
        }
        View view = parentView.findViewById(inflatedViewId);
        if (null == view) {
            ViewStub vs = (ViewStub)parentView.findViewById(viewStubId);
            if (null == vs) {
                return null;
            }
            view = vs.inflate();
            if (null != view) {
                view = view.findViewById(inflatedViewId);
            }
        }
        return view;
    }

    @SuppressLint(value={"ResourceType"})
    public static View findViewFromViewStub(View parentView, int viewStubId, int inflatedViewId, int inflateLayoutResId) {
        if (null == parentView) {
            return null;
        }
        View view = parentView.findViewById(inflatedViewId);
        if (null == view) {
            ViewStub vs = (ViewStub)parentView.findViewById(viewStubId);
            if (null == vs) {
                return null;
            }
            if (vs.getLayoutResource() < 1 && inflateLayoutResId > 0) {
                vs.setLayoutResource(inflateLayoutResId);
            }
            if (null != (view = vs.inflate())) {
                view = view.findViewById(inflatedViewId);
            }
        }
        return view;
    }

    public static void safeSetImageViewSelected(ImageView imageView, boolean selected) {
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 == null) {
            return;
        }
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        imageView.setSelected(selected);
        if (drawable2.getIntrinsicWidth() != drawableWidth || drawable2.getIntrinsicHeight() != drawableHeight) {
            imageView.requestLayout();
        }
    }

    public static ColorFilter setImageViewTintColor(ImageView imageView, @ColorInt int tintColor) {
        LightingColorFilter colorFilter = new LightingColorFilter(Color.argb((int)255, (int)0, (int)0, (int)0), tintColor);
        imageView.setColorFilter((ColorFilter)colorFilter);
        return colorFilter;
    }

    public static boolean isListViewAlreadyAtBottom(ListView listView) {
        if (listView.getAdapter() == null || listView.getHeight() == 0) {
            return false;
        }
        if (listView.getLastVisiblePosition() == listView.getAdapter().getCount() - 1) {
            View lastItemView = listView.getChildAt(listView.getChildCount() - 1);
            return lastItemView != null && lastItemView.getBottom() == listView.getHeight();
        }
        return false;
    }

    public static void getDescendantRect(ViewGroup parent, View descendant, Rect out) {
        out.set(0, 0, descendant.getWidth(), descendant.getHeight());
        ViewGroupHelper.offsetDescendantRect(parent, descendant, out);
    }

    public static void setViewTextFont(View view, Typeface typeface) {
        if (view == null || typeface == null) {
            return;
        }
        if (view instanceof TextView) {
            ((TextView)view).setTypeface(typeface);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                ViewUtils.setViewTextFont(viewGroup.getChildAt(i), typeface);
            }
        }
    }

    public static void setViewsFont(Typeface typeface, View ... views) {
        if (typeface == null || views == null || views.length == 0) {
            return;
        }
        for (View view : views) {
            ViewUtils.setViewTextFont(view, typeface);
        }
    }

    public static void setViewsFont(View ... views) {
        ViewUtils.setViewsFont(XUI.getDefaultTypeface(), views);
    }

    public static void clearViewLongClick(View rootView, int ... ids) {
        if (rootView == null || ids == null || ids.length == 0) {
            return;
        }
        for (int id2 : ids) {
            View view = rootView.findViewById(id2);
            if (view == null) continue;
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return true;
                }
            });
        }
    }

    public static void clearAllViewLongClick(View view) {
        if (view == null) {
            return;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                ViewUtils.clearAllViewLongClick(viewGroup.getChildAt(i));
            }
        } else {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return true;
                }
            });
        }
    }

    public static void setToolbarLayoutTextFont(CollapsingToolbarLayout collapsingToolbarLayout) {
        ViewUtils.setToolbarLayoutTextFont(collapsingToolbarLayout, XUI.getDefaultTypeface());
    }

    public static void setToolbarLayoutTextFont(CollapsingToolbarLayout collapsingToolbarLayout, Typeface typeface) {
        if (collapsingToolbarLayout == null || typeface == null) {
            return;
        }
        collapsingToolbarLayout.setExpandedTitleTypeface(typeface);
        collapsingToolbarLayout.setCollapsedTitleTypeface(typeface);
    }

    public static enum Direction {
        LEFT_TO_RIGHT,
        TOP_TO_BOTTOM,
        RIGHT_TO_LEFT,
        BOTTOM_TO_TOP;

    }

    private static class ViewGroupHelper {
        private static final ThreadLocal<Matrix> MATRIX_THREAD_LOCAL = new ThreadLocal();
        private static final ThreadLocal<RectF> RECT_F_THREAD_LOCAL = new ThreadLocal();

        private ViewGroupHelper() {
        }

        public static void offsetDescendantRect(ViewGroup group, View child, Rect rect) {
            Matrix m = MATRIX_THREAD_LOCAL.get();
            if (m == null) {
                m = new Matrix();
                MATRIX_THREAD_LOCAL.set(m);
            } else {
                m.reset();
            }
            ViewGroupHelper.offsetDescendantMatrix((ViewParent)group, child, m);
            RectF rectF = RECT_F_THREAD_LOCAL.get();
            if (rectF == null) {
                rectF = new RectF();
                RECT_F_THREAD_LOCAL.set(rectF);
            }
            rectF.set(rect);
            m.mapRect(rectF);
            rect.set((int)(rectF.left + 0.5f), (int)(rectF.top + 0.5f), (int)(rectF.right + 0.5f), (int)(rectF.bottom + 0.5f));
        }

        static void offsetDescendantMatrix(ViewParent target, View view, Matrix m) {
            ViewParent parent = view.getParent();
            if (parent instanceof View && parent != target) {
                View vp = (View)parent;
                ViewGroupHelper.offsetDescendantMatrix(target, vp, m);
                m.preTranslate((float)(-vp.getScrollX()), (float)(-vp.getScrollY()));
            }
            m.preTranslate((float)view.getLeft(), (float)view.getTop());
            if (!view.getMatrix().isIdentity()) {
                m.preConcat(view.getMatrix());
            }
        }
    }
}

