/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public final class Utils {
    private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getStatusBarHeight(Context context) {
        if (context == null) {
            return Utils.getStatusBarHeight();
        }
        return Utils.getInternalDimensionSize(context.getResources(), STATUS_BAR_HEIGHT_RES_NAME);
    }

    public static int getStatusBarHeight() {
        return Utils.getInternalDimensionSize(Resources.getSystem(), STATUS_BAR_HEIGHT_RES_NAME);
    }

    private static int getInternalDimensionSize(Resources res, String key) {
        int result = 0;
        int resourceId = res.getIdentifier(key, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getListViewHeightBasedOnChildren(ListView view) {
        int adapterCount;
        ListAdapter adapter;
        int height = Utils.getAbsListViewHeightBasedOnChildren((AbsListView)view);
        if (view != null && (adapter = view.getAdapter()) != null && (adapterCount = adapter.getCount()) > 0) {
            height += view.getDividerHeight() * (adapterCount - 1);
        }
        return height;
    }

    public static int getAbsListViewHeightBasedOnChildren(AbsListView view) {
        ListAdapter adapter;
        if (view == null || (adapter = (ListAdapter)view.getAdapter()) == null) {
            return 0;
        }
        int height = 0;
        for (int i = 0; i < adapter.getCount(); ++i) {
            View item = adapter.getView(i, null, (ViewGroup)view);
            if (item instanceof ViewGroup) {
                item.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            }
            item.measure(0, 0);
            height += item.getMeasuredHeight();
        }
        return height += view.getPaddingTop() + view.getPaddingBottom();
    }

    public static void setBackground(Context context, View view, int resId) {
        if (view == null) {
            return;
        }
        Bitmap bm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        BitmapDrawable bd = new BitmapDrawable(context.getResources(), bm);
        view.setBackground((Drawable)bd);
    }

    public static void recycleBackground(View view) {
        Bitmap bmp;
        Drawable d = view.getBackground();
        view.setBackgroundResource(0);
        if (d != null && d instanceof BitmapDrawable && (bmp = ((BitmapDrawable)d).getBitmap()) != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        if (d != null) {
            d.setCallback(null);
        }
    }

    public static void clearImageView(View view) {
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                Utils.clearImageView(parent.getChildAt(i));
            }
        } else if (view instanceof ImageView) {
            Utils.clearImgMemory((ImageView)view);
        }
    }

    public static void clearImgMemory(ImageView imageView) {
        Bitmap bmp;
        Drawable d = imageView.getDrawable();
        if (d != null && d instanceof BitmapDrawable && (bmp = ((BitmapDrawable)d).getBitmap()) != null && !bmp.isRecycled()) {
            bmp.recycle();
        }
        imageView.setImageBitmap(null);
        if (d != null) {
            d.setCallback(null);
        }
    }

    public static Bitmap zoom(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static void closeIOQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isFileExist(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static Bitmap getBitmap(String filePath) {
        if (!Utils.isFileExist(filePath)) {
            return null;
        }
        return BitmapFactory.decodeFile((String)filePath);
    }

    public static void checkNull(Object object, String hint) {
        if (null == object) {
            throw new NullPointerException(hint);
        }
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static Bitmap rotate(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable2, int color2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(color2, PorterDuff.Mode.SRC_IN);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(bitmap);
        canvas.drawColor(color2, PorterDuff.Mode.SRC_IN);
        return bitmap;
    }

    public static Drawable getAppIcon(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo info = pm.getApplicationInfo(context.getPackageName(), 0);
            return info.loadIcon(pm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSupportColorAttrs() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isLight(int color2) {
        return Math.sqrt((double)(Color.red((int)color2) * Color.red((int)color2)) * 0.241 + (double)(Color.green((int)color2) * Color.green((int)color2)) * 0.691 + (double)(Color.blue((int)color2) * Color.blue((int)color2)) * 0.068) > 130.0;
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence string2) {
        return string2 == null || string2.length() == 0;
    }

    public static int getNumberDigits(int number) {
        if (number <= 0) {
            return 0;
        }
        return (int)(Math.log10(number) + 1.0);
    }

    public static ColorFilter setDrawableTintColor(Drawable drawable2, @ColorInt int tintColor) {
        LightingColorFilter colorFilter = new LightingColorFilter(Color.argb((int)255, (int)0, (int)0, (int)0), tintColor);
        if (drawable2 != null) {
            drawable2.setColorFilter((ColorFilter)colorFilter);
        }
        return colorFilter;
    }

    public static Application getApplicationByReflect() {
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object app = activityThread.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                throw new NullPointerException("you should init first");
            }
            return (Application)app;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("you should init first");
    }

    public static <T> T cast(Object object, Class<T> clazz) {
        return (T)(clazz != null && clazz.isInstance(object) ? object : null);
    }
}

