/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.ArrayRes;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.dialog.materialdialog.GravityEnum;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ThemeUtils {
    public static final int DEFAULT_MODE = 0;
    public static final int LIGHT_MODE = 1;
    public static final int DARK_MODE = 2;

    private ThemeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @ColorInt
    public static int getDisabledColor(Context context) {
        int primaryColor = ThemeUtils.resolveColor(context, 16842806);
        int disabledColor = ThemeUtils.isColorDark(primaryColor) ? -16777216 : -1;
        return ThemeUtils.adjustAlpha(disabledColor, 0.3f);
    }

    @ColorInt
    public static int adjustAlpha(@ColorInt int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int resolveColor(Context context, @AttrRes int attr2) {
        return ThemeUtils.resolveColor(context, attr2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public static int resolveColor(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getColorFromAttrRes(int attrRes, int defaultValue, Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            int n = a.getColor(0, defaultValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static float resolveFloat(Context context, int attrRes) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.getFloat();
    }

    public static int resolveInt(Context context, int attrRes) {
        return ThemeUtils.resolveInt(context, attrRes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveInt(Context context, int attrRes, int defaultValue) {
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            int n = a.getInt(0, defaultValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float resolveFloat(Context context, int attrRes, float defaultValue) {
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            float f = a.getFloat(0, defaultValue);
            return f;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList resolveActionTextColorStateList(Context context, @AttrRes int colorAttr, ColorStateList fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{colorAttr});
        try {
            TypedValue value = a.peekValue(0);
            if (value == null) {
                ColorStateList colorStateList = fallback;
                return colorStateList;
            }
            if (value.type >= 28 && value.type <= 31) {
                ColorStateList colorStateList = ThemeUtils.getActionTextStateList(context, value.data);
                return colorStateList;
            }
            ColorStateList stateList = a.getColorStateList(0);
            if (stateList != null) {
                ColorStateList colorStateList = stateList;
                return colorStateList;
            }
            ColorStateList colorStateList = fallback;
            return colorStateList;
        }
        finally {
            a.recycle();
        }
    }

    public static ColorStateList getActionTextColorStateList(Context context, @ColorRes int colorId) {
        TypedValue value = new TypedValue();
        context.getResources().getValue(colorId, value, true);
        if (value.type >= 28 && value.type <= 31) {
            return ThemeUtils.getActionTextStateList(context, value.data);
        }
        if (Build.VERSION.SDK_INT <= 22) {
            return context.getResources().getColorStateList(colorId);
        }
        return context.getColorStateList(colorId);
    }

    @ColorInt
    public static int getColor(Context context, @ColorRes int colorId) {
        return ContextCompat.getColor((Context)context, (int)colorId);
    }

    public static String resolveString(Context context, @AttrRes int attr2) {
        TypedValue v = new TypedValue();
        context.getTheme().resolveAttribute(attr2, v, true);
        return (String)v.string;
    }

    public static String resolveString(Context context, @AttrRes int attr2, String defaultValue) {
        TypedValue v = new TypedValue();
        context.getTheme().resolveAttribute(attr2, v, true);
        String value = (String)v.string;
        return TextUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    public static String resolveString(Resources.Theme theme, @AttrRes int attr2) {
        TypedValue v = new TypedValue();
        theme.resolveAttribute(attr2, v, true);
        return (String)v.string;
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr2) {
        return ThemeUtils.resolveDrawable(context, attr2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable resolveDrawable(Context context, @AttrRes int attr2, Drawable fallback) {
        TypedArray array = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            Drawable drawable2 = null;
            if (Build.VERSION.SDK_INT >= 21) {
                drawable2 = array.getDrawable(0);
            } else {
                int id2 = array.getResourceId(0, -1);
                if (id2 != -1) {
                    drawable2 = AppCompatResources.getDrawable((Context)context, (int)id2);
                }
            }
            if (drawable2 == null && fallback != null) {
                drawable2 = fallback;
            }
            Drawable drawable3 = drawable2;
            return drawable3;
        }
        finally {
            array.recycle();
        }
    }

    public static int resolveDimension(Context context, @AttrRes int attr2) {
        return ThemeUtils.resolveDimension(context, attr2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveDimension(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getDimensionPixelSize(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveBoolean(Context context, @AttrRes int attr2, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static boolean resolveBoolean(Context context, @AttrRes int attr2) {
        return ThemeUtils.resolveBoolean(context, attr2, false);
    }

    public static boolean isColorDark(@ColorInt int color2) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / 255.0;
        return darkness >= 0.5;
    }

    public static void setBackgroundCompat(View view, Drawable d) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(d);
        } else {
            view.setBackground(d);
        }
    }

    public static ColorStateList getActionTextStateList(Context context, int newPrimaryColor) {
        int fallBackButtonColor = ThemeUtils.resolveColor(context, 16842806);
        if (newPrimaryColor == 0) {
            newPrimaryColor = fallBackButtonColor;
        }
        int[][] states = new int[][]{{-16842910}, new int[0]};
        int[] colors = new int[]{ThemeUtils.adjustAlpha(newPrimaryColor, 0.4f), newPrimaryColor};
        return new ColorStateList((int[][])states, colors);
    }

    public static int[] getColorArray(@NonNull Context context, @ArrayRes int array) {
        if (array == 0) {
            return null;
        }
        TypedArray ta = context.getResources().obtainTypedArray(array);
        int[] colors = new int[ta.length()];
        for (int i = 0; i < ta.length(); ++i) {
            colors[i] = ta.getColor(i, 0);
        }
        ta.recycle();
        return colors;
    }

    public static <T> boolean isIn(@NonNull T find, @Nullable T[] ary) {
        if (ary == null || ary.length == 0) {
            return false;
        }
        for (T item : ary) {
            if (!item.equals(find)) continue;
            return true;
        }
        return false;
    }

    @ColorInt
    public static int getMainThemeColor(Context context) {
        return ThemeUtils.resolveColor(context, R.attr.colorAccent, ThemeUtils.getColor(context, R.color.xui_config_color_main_theme));
    }

    @Deprecated
    public static boolean isNightMode() {
        int mode = ResUtils.getResources().getConfiguration().uiMode & 0x30;
        return mode == 32;
    }

    public static boolean isNightMode(@NonNull Context context) {
        int mode = ResUtils.getResources((Context)context).getConfiguration().uiMode & 0x30;
        return mode == 32;
    }

    @SuppressLint(value={"WrongConstant"})
    public static void applyTheme(int theme) {
        switch (theme) {
            case 1: {
                AppCompatDelegate.setDefaultNightMode((int)1);
                break;
            }
            case 2: {
                AppCompatDelegate.setDefaultNightMode((int)2);
                break;
            }
            case 0: {
                if (Build.VERSION.SDK_INT >= 29) {
                    AppCompatDelegate.setDefaultNightMode((int)-1);
                    break;
                }
                AppCompatDelegate.setDefaultNightMode((int)3);
                break;
            }
        }
    }

    private static int gravityEnumToAttrInt(GravityEnum value) {
        switch (value) {
            case CENTER: {
                return 1;
            }
            case END: {
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GravityEnum resolveGravityEnum(Context context, @AttrRes int attr2, GravityEnum defaultGravity) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            switch (a.getInt(0, ThemeUtils.gravityEnumToAttrInt(defaultGravity))) {
                case 1: {
                    GravityEnum gravityEnum = GravityEnum.CENTER;
                    return gravityEnum;
                }
                case 2: {
                    GravityEnum gravityEnum = GravityEnum.END;
                    return gravityEnum;
                }
            }
            GravityEnum gravityEnum = GravityEnum.START;
            return gravityEnum;
        }
        finally {
            a.recycle();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Theme {
    }
}

