/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.core.view.ViewCompat;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.DeviceUtils;
import com.xuexiang.xui.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtils {
    private static final int STATUSBAR_TYPE_DEFAULT = 0;
    private static final int STATUSBAR_TYPE_MIUI = 1;
    private static final int STATUSBAR_TYPE_FLYME = 2;
    private static final int STATUSBAR_TYPE_ANDROID6 = 3;
    private static final int STATUS_BAR_DEFAULT_HEIGHT_DP = 25;
    public static float sVirtualDensity = -1.0f;
    public static float sVirtualDensityDpi = -1.0f;
    private static int sStatusbarHeight = -1;
    private static int mStatusBarType = 0;
    private static Integer sTransparentValue;

    public static void translucent(Activity activity) {
        StatusBarUtils.translucent(activity.getWindow());
    }

    public static void translucent(Window window) {
        StatusBarUtils.translucent(window, 0x40000000);
    }

    private static boolean supportTranslucent() {
        return Build.VERSION.SDK_INT >= 19 && (!DeviceUtils.isEssentialPhone() || Build.VERSION.SDK_INT >= 26);
    }

    private StatusBarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void initStatusBarStyle(Activity activity, boolean isDark) {
        StatusBarUtils.initStatusBarStyle(activity, isDark, 0);
    }

    public static void initStatusBarStyle(Activity activity, boolean isDark, @ColorInt int colorOn5x) {
        StatusBarUtils.translucent(activity, colorOn5x);
        if (isDark) {
            StatusBarUtils.setStatusBarDarkMode(activity);
        } else {
            StatusBarUtils.setStatusBarLightMode(activity);
        }
    }

    public static void translucent(Activity activity, @ColorInt int colorOn5x) {
        Window window = activity.getWindow();
        StatusBarUtils.translucent(window, colorOn5x);
    }

    @TargetApi(value=19)
    public static void translucent(Window window, @ColorInt int colorOn5x) {
        if (!StatusBarUtils.supportTranslucent()) {
            return;
        }
        if (StatusBarUtils.isNotchOfficialSupport()) {
            StatusBarUtils.handleDisplayCutoutMode(window);
        }
        if (DeviceUtils.isMeizu() || DeviceUtils.isMIUI() && Build.VERSION.SDK_INT < 23) {
            window.setFlags(0x4000000, 0x4000000);
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            window.getDecorView().setSystemUiVisibility(1280);
            if (Build.VERSION.SDK_INT >= 23 && StatusBarUtils.supportTransclentStatusBar6()) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(0);
            } else {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(colorOn5x);
            }
        }
    }

    public static boolean isNotchOfficialSupport() {
        return Build.VERSION.SDK_INT >= 28;
    }

    @TargetApi(value=28)
    private static void handleDisplayCutoutMode(final Window window) {
        View decorView = window.getDecorView();
        if (decorView != null) {
            if (ViewCompat.isAttachedToWindow((View)decorView)) {
                StatusBarUtils.realHandleDisplayCutoutMode(window, decorView);
            } else {
                decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        StatusBarUtils.realHandleDisplayCutoutMode(window, v);
                    }

                    public void onViewDetachedFromWindow(View v) {
                    }
                });
            }
        }
    }

    @TargetApi(value=28)
    private static void realHandleDisplayCutoutMode(Window window, View decorView) {
        if (decorView.getRootWindowInsets() != null && decorView.getRootWindowInsets().getDisplayCutout() != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.layoutInDisplayCutoutMode = 1;
            window.setAttributes(params);
        }
    }

    public static boolean setStatusBarLightMode(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (DeviceUtils.isZTKC2016()) {
            return false;
        }
        if (mStatusBarType != 0) {
            return StatusBarUtils.setStatusBarLightMode(activity, mStatusBarType);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            if (StatusBarUtils.isMIUICustomStatusBarLightModeImpl() && StatusBarUtils.MIUISetStatusBarLightMode(activity.getWindow(), true)) {
                mStatusBarType = 1;
                return true;
            }
            if (StatusBarUtils.FlymeSetStatusBarLightMode(activity.getWindow(), true)) {
                mStatusBarType = 2;
                return true;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                StatusBarUtils.Android6SetStatusBarLightMode(activity.getWindow(), true);
                mStatusBarType = 3;
                return true;
            }
        }
        return false;
    }

    private static boolean setStatusBarLightMode(Activity activity, int type) {
        if (type == 1) {
            return StatusBarUtils.MIUISetStatusBarLightMode(activity.getWindow(), true);
        }
        if (type == 2) {
            return StatusBarUtils.FlymeSetStatusBarLightMode(activity.getWindow(), true);
        }
        if (type == 3) {
            return StatusBarUtils.Android6SetStatusBarLightMode(activity.getWindow(), true);
        }
        return false;
    }

    public static boolean setStatusBarDarkMode(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (mStatusBarType == 0) {
            return true;
        }
        if (mStatusBarType == 1) {
            return StatusBarUtils.MIUISetStatusBarLightMode(activity.getWindow(), false);
        }
        if (mStatusBarType == 2) {
            return StatusBarUtils.FlymeSetStatusBarLightMode(activity.getWindow(), false);
        }
        if (mStatusBarType == 3) {
            return StatusBarUtils.Android6SetStatusBarLightMode(activity.getWindow(), false);
        }
        return true;
    }

    @TargetApi(value=23)
    private static int changeStatusBarModeRetainFlag(Window window, int out) {
        out = StatusBarUtils.retainSystemUiFlag(window, out, 1024);
        out = StatusBarUtils.retainSystemUiFlag(window, out, 4);
        out = StatusBarUtils.retainSystemUiFlag(window, out, 2);
        out = StatusBarUtils.retainSystemUiFlag(window, out, 4096);
        out = StatusBarUtils.retainSystemUiFlag(window, out, 1024);
        out = StatusBarUtils.retainSystemUiFlag(window, out, 512);
        return out;
    }

    public static int retainSystemUiFlag(Window window, int out, int type) {
        int now = window.getDecorView().getSystemUiVisibility();
        if ((now & type) == type) {
            out |= type;
        }
        return out;
    }

    @TargetApi(value=23)
    private static boolean Android6SetStatusBarLightMode(Window window, boolean light) {
        View decorView = window.getDecorView();
        int systemUi = light ? 8192 : 256;
        systemUi = StatusBarUtils.changeStatusBarModeRetainFlag(window, systemUi);
        decorView.setSystemUiVisibility(systemUi);
        if (DeviceUtils.isMIUIV9()) {
            StatusBarUtils.MIUISetStatusBarLightMode(window, light);
        }
        return true;
    }

    public static boolean MIUISetStatusBarLightMode(Window window, boolean light) {
        boolean result = false;
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (light) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isMIUICustomStatusBarLightModeImpl() {
        if (DeviceUtils.isMIUIV9() && Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return DeviceUtils.isMIUIV5() || DeviceUtils.isMIUIV6() || DeviceUtils.isMIUIV7() || DeviceUtils.isMIUIV8();
    }

    public static boolean FlymeSetStatusBarLightMode(Window window, boolean light) {
        boolean result = false;
        if (window != null) {
            StatusBarUtils.Android6SetStatusBarLightMode(window, light);
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = light ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isFullScreen(Activity activity) {
        boolean ret = false;
        try {
            WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
            ret = (attrs.flags & 0x400) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Integer getStatusBarAPITransparentValue(Context context) {
        if (sTransparentValue != null) {
            return sTransparentValue;
        }
        String[] systemSharedLibraryNames = context.getPackageManager().getSystemSharedLibraryNames();
        String fieldName = null;
        for (String lib : systemSharedLibraryNames) {
            if ("touchwiz".equals(lib)) {
                fieldName = "SYSTEM_UI_FLAG_TRANSPARENT_BACKGROUND";
                continue;
            }
            if (!lib.startsWith("com.sonyericsson.navigationbar")) continue;
            fieldName = "SYSTEM_UI_FLAG_TRANSPARENT";
        }
        if (fieldName != null) {
            try {
                Class<?> type;
                Field field = View.class.getField(fieldName);
                if (field != null && (type = field.getType()) == Integer.TYPE) {
                    sTransparentValue = field.getInt(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sTransparentValue;
    }

    public static boolean supportTransclentStatusBar6() {
        return !DeviceUtils.isZUKZ1() && !DeviceUtils.isZTKC2016();
    }

    public static int getStatusBarHeight(Context context) {
        if (sStatusbarHeight == -1) {
            sStatusbarHeight = Utils.getStatusBarHeight(context);
        }
        return sStatusbarHeight;
    }

    public static void setVirtualDensity(float density) {
        sVirtualDensity = density;
    }

    public static void setVirtualDensityDpi(float densityDpi) {
        sVirtualDensityDpi = densityDpi;
    }

    public static void fullScreen(Activity activity) {
        if (activity == null) {
            return;
        }
        StatusBarUtils.fullScreen(activity.getWindow());
    }

    public static void fullScreen(Window window) {
        if (window == null) {
            return;
        }
        if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
            window.getDecorView().setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.getDecorView().setSystemUiVisibility(4615);
        }
    }

    public static void cancelFullScreen(Activity activity, @ColorInt int statusBarColor, @ColorInt int navigationBarColor) {
        if (activity == null) {
            return;
        }
        StatusBarUtils.cancelFullScreen(activity.getWindow(), statusBarColor, navigationBarColor);
    }

    public static void cancelFullScreen(Window window, @ColorInt int statusBarColor, @ColorInt int navigationBarColor) {
        if (window == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0xC000000);
            window.getDecorView().setSystemUiVisibility(0);
            window.addFlags(Integer.MIN_VALUE);
            if (statusBarColor != -1) {
                window.setStatusBarColor(statusBarColor);
            }
            if (navigationBarColor != -1) {
                window.setNavigationBarColor(navigationBarColor);
            }
        }
    }

    public static void cancelFullScreen(Activity activity) {
        if (activity == null) {
            return;
        }
        StatusBarUtils.cancelFullScreen(activity.getWindow());
    }

    public static void cancelFullScreen(Window window) {
        StatusBarUtils.cancelFullScreen(window, -1, -1);
    }

    public static void setNavigationBarColor(Activity activity, int color2) {
        if (Build.VERSION.SDK_INT > 21) {
            activity.getWindow().setNavigationBarColor(color2);
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x8000000);
            ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
            View navigationBar = new View((Context)activity);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, StatusBarUtils.getNavigationBarHeight((Context)activity));
            params.gravity = 80;
            navigationBar.setLayoutParams((ViewGroup.LayoutParams)params);
            navigationBar.setBackgroundColor(color2);
            decorView.addView(navigationBar);
        }
    }

    public static int getNavigationBarHeight(Context context) {
        int height = 0;
        int id2 = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (id2 > 0) {
            height = context.getResources().getDimensionPixelSize(id2);
        }
        return height;
    }

    public static boolean isNavigationBarExist(Activity activity) {
        return DensityUtils.isNavigationBarExist((Context)activity);
    }

    public static void showDialogInFullScreen(final Dialog dialog) {
        if (dialog == null) {
            return;
        }
        StatusBarUtils.showWindowInFullScreen(dialog.getWindow(), new IWindowShower(){

            @Override
            public void show(Window window) {
                dialog.show();
            }
        });
    }

    public static void showWindowInFullScreen(Window window, IWindowShower iWindowShower) {
        if (window == null || iWindowShower == null) {
            return;
        }
        window.addFlags(8);
        iWindowShower.show(window);
        StatusBarUtils.fullScreen(window);
        window.clearFlags(8);
    }

    public static void showDialog(Activity activity, final Dialog dialog) {
        if (dialog == null) {
            return;
        }
        StatusBarUtils.showWindow(activity, dialog.getWindow(), new IWindowShower(){

            @Override
            public void show(Window window) {
                dialog.show();
            }
        });
    }

    public static boolean showWindow(Activity activity, Window window, IWindowShower iWindowShower) {
        if (activity == null || window == null || iWindowShower == null) {
            return false;
        }
        window.addFlags(8);
        iWindowShower.show(window);
        StatusBarUtils.syncSystemUiVisibility(activity, window);
        window.clearFlags(8);
        return true;
    }

    public static boolean syncSystemUiVisibility(Activity original, Window target) {
        if (original == null) {
            return false;
        }
        return StatusBarUtils.syncSystemUiVisibility(original.getWindow(), target);
    }

    public static boolean syncSystemUiVisibility(Window original, Window target) {
        if (original == null || target == null) {
            return false;
        }
        target.getDecorView().setSystemUiVisibility(original.getDecorView().getSystemUiVisibility());
        return true;
    }

    public static interface IWindowShower {
        public void show(Window var1);
    }
}

