/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.text.style.UpdateAppearance;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.xuexiang.xui.XUI;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public final class SpanUtils {
    private static final int COLOR_DEFAULT = -16777217;
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_TOP = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CharSequence mText = "";
    private int flag;
    private int foregroundColor;
    private int backgroundColor;
    private int lineHeight;
    private int alignLine;
    private int quoteColor;
    private int stripeWidth;
    private int quoteGapWidth;
    private int first;
    private int rest;
    private int bulletColor;
    private int bulletRadius;
    private int bulletGapWidth;
    private Bitmap iconMarginBitmap;
    private Drawable iconMarginDrawable;
    private Uri iconMarginUri;
    private int iconMarginResourceId;
    private int iconMarginGapWidth;
    private int alignIconMargin;
    private int fontSize;
    private boolean fontSizeIsDp;
    private float proportion;
    private float xProportion;
    private boolean isStrikethrough;
    private boolean isUnderline;
    private boolean isSuperscript;
    private boolean isSubscript;
    private boolean isBold;
    private boolean isItalic;
    private boolean isBoldItalic;
    private String fontFamily;
    private Typeface typeface;
    private Layout.Alignment alignment;
    private ClickableSpan clickSpan;
    private String url;
    private float blurRadius;
    private BlurMaskFilter.Blur style;
    private Shader shader;
    private float shadowRadius;
    private float shadowDx;
    private float shadowDy;
    private int shadowColor;
    private Object[] spans;
    private Bitmap imageBitmap;
    private Drawable imageDrawable;
    private Uri imageUri;
    private int imageResourceId;
    private int alignImage;
    private int spaceSize;
    private int spaceColor;
    private SpannableStringBuilder mBuilder = new SpannableStringBuilder();
    private int mType;
    private final int mTypeCharSequence = 0;
    private final int mTypeImage = 1;
    private final int mTypeSpace = 2;

    public SpanUtils() {
        this.setDefault();
    }

    private void setDefault() {
        this.flag = 33;
        this.foregroundColor = -16777217;
        this.backgroundColor = -16777217;
        this.lineHeight = -1;
        this.quoteColor = -16777217;
        this.first = -1;
        this.bulletColor = -16777217;
        this.iconMarginBitmap = null;
        this.iconMarginDrawable = null;
        this.iconMarginUri = null;
        this.iconMarginResourceId = -1;
        this.iconMarginGapWidth = -1;
        this.fontSize = -1;
        this.proportion = -1.0f;
        this.xProportion = -1.0f;
        this.isStrikethrough = false;
        this.isUnderline = false;
        this.isSuperscript = false;
        this.isSubscript = false;
        this.isBold = false;
        this.isItalic = false;
        this.isBoldItalic = false;
        this.fontFamily = null;
        this.typeface = null;
        this.alignment = null;
        this.clickSpan = null;
        this.url = null;
        this.blurRadius = -1.0f;
        this.shader = null;
        this.shadowRadius = -1.0f;
        this.spans = null;
        this.imageBitmap = null;
        this.imageDrawable = null;
        this.imageUri = null;
        this.imageResourceId = -1;
        this.spaceSize = -1;
    }

    public SpanUtils setFlag(int flag) {
        this.flag = flag;
        return this;
    }

    public SpanUtils setForegroundColor(@ColorInt int color2) {
        this.foregroundColor = color2;
        return this;
    }

    public SpanUtils setBackgroundColor(@ColorInt int color2) {
        this.backgroundColor = color2;
        return this;
    }

    public SpanUtils setLineHeight(@IntRange(from=0L) int lineHeight) {
        return this.setLineHeight(lineHeight, 2);
    }

    public SpanUtils setLineHeight(@IntRange(from=0L) int lineHeight, int align) {
        this.lineHeight = lineHeight;
        this.alignLine = align;
        return this;
    }

    public SpanUtils setQuoteColor(@ColorInt int color2) {
        return this.setQuoteColor(color2, 2, 2);
    }

    public SpanUtils setQuoteColor(@ColorInt int color2, @IntRange(from=1L) int stripeWidth, @IntRange(from=0L) int gapWidth) {
        this.quoteColor = color2;
        this.stripeWidth = stripeWidth;
        this.quoteGapWidth = gapWidth;
        return this;
    }

    public SpanUtils setLeadingMargin(@IntRange(from=0L) int first, @IntRange(from=0L) int rest) {
        this.first = first;
        this.rest = rest;
        return this;
    }

    public SpanUtils setBullet(@IntRange(from=0L) int gapWidth) {
        return this.setBullet(0, 3, gapWidth);
    }

    public SpanUtils setBullet(@ColorInt int color2, @IntRange(from=0L) int radius, @IntRange(from=0L) int gapWidth) {
        this.bulletColor = color2;
        this.bulletRadius = radius;
        this.bulletGapWidth = gapWidth;
        return this;
    }

    public SpanUtils setIconMargin(Bitmap bitmap) {
        return this.setIconMargin(bitmap, 0, 2);
    }

    public SpanUtils setIconMargin(Bitmap bitmap, int gapWidth, int align) {
        this.iconMarginBitmap = bitmap;
        this.iconMarginGapWidth = gapWidth;
        this.alignIconMargin = align;
        return this;
    }

    public SpanUtils setIconMargin(Drawable drawable2) {
        return this.setIconMargin(drawable2, 0, 2);
    }

    public SpanUtils setIconMargin(Drawable drawable2, int gapWidth, int align) {
        this.iconMarginDrawable = drawable2;
        this.iconMarginGapWidth = gapWidth;
        this.alignIconMargin = align;
        return this;
    }

    public SpanUtils setIconMargin(Uri uri) {
        return this.setIconMargin(uri, 0, 2);
    }

    public SpanUtils setIconMargin(Uri uri, int gapWidth, int align) {
        this.iconMarginUri = uri;
        this.iconMarginGapWidth = gapWidth;
        this.alignIconMargin = align;
        return this;
    }

    public SpanUtils setIconMargin(@DrawableRes int resourceId) {
        return this.setIconMargin(resourceId, 0, 2);
    }

    public SpanUtils setIconMargin(@DrawableRes int resourceId, int gapWidth, int align) {
        this.iconMarginResourceId = resourceId;
        this.iconMarginGapWidth = gapWidth;
        this.alignIconMargin = align;
        return this;
    }

    public SpanUtils setFontSize(@IntRange(from=0L) int size) {
        return this.setFontSize(size, false);
    }

    public SpanUtils setFontSize(@IntRange(from=0L) int size, boolean isDp) {
        this.fontSize = size;
        this.fontSizeIsDp = isDp;
        return this;
    }

    public SpanUtils setFontProportion(@FloatRange(from=0.0, fromInclusive=false) float proportion) {
        this.proportion = proportion;
        return this;
    }

    public SpanUtils setFontXProportion(@FloatRange(from=0.0, fromInclusive=false) float proportion) {
        this.xProportion = proportion;
        return this;
    }

    public SpanUtils setStrikethrough() {
        this.isStrikethrough = true;
        return this;
    }

    public SpanUtils setUnderline() {
        this.isUnderline = true;
        return this;
    }

    public SpanUtils setSuperscript() {
        this.isSuperscript = true;
        return this;
    }

    public SpanUtils setSubscript() {
        this.isSubscript = true;
        return this;
    }

    public SpanUtils setBold() {
        this.isBold = true;
        return this;
    }

    public SpanUtils setItalic() {
        this.isItalic = true;
        return this;
    }

    public SpanUtils setBoldItalic() {
        this.isBoldItalic = true;
        return this;
    }

    public SpanUtils setFontFamily(@NonNull String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    public SpanUtils setTypeface(@NonNull Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public SpanUtils setAlign(@NonNull Layout.Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public SpanUtils setClickSpan(@NonNull ClickableSpan clickSpan) {
        this.clickSpan = clickSpan;
        return this;
    }

    public SpanUtils setUrl(@NonNull String url) {
        this.url = url;
        return this;
    }

    public SpanUtils setBlur(@FloatRange(from=0.0, fromInclusive=false) float radius, BlurMaskFilter.Blur style2) {
        this.blurRadius = radius;
        this.style = style2;
        return this;
    }

    public SpanUtils setShader(@NonNull Shader shader) {
        this.shader = shader;
        return this;
    }

    public SpanUtils setShadow(@FloatRange(from=0.0, fromInclusive=false) float radius, float dx, float dy, int shadowColor) {
        this.shadowRadius = radius;
        this.shadowDx = dx;
        this.shadowDy = dy;
        this.shadowColor = shadowColor;
        return this;
    }

    public SpanUtils setSpans(Object ... spans) {
        if (spans.length > 0) {
            this.spans = spans;
        }
        return this;
    }

    public SpanUtils append(@NonNull CharSequence text) {
        this.apply(0);
        this.mText = text;
        return this;
    }

    public SpanUtils appendLine() {
        this.apply(0);
        this.mText = LINE_SEPARATOR;
        return this;
    }

    public SpanUtils appendLine(@NonNull CharSequence text) {
        this.apply(0);
        this.mText = text + LINE_SEPARATOR;
        return this;
    }

    public SpanUtils appendImage(@NonNull Bitmap bitmap) {
        return this.appendImage(bitmap, 0);
    }

    public SpanUtils appendImage(@NonNull Bitmap bitmap, int align) {
        this.apply(1);
        this.imageBitmap = bitmap;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendImage(@NonNull Drawable drawable2) {
        return this.appendImage(drawable2, 0);
    }

    public SpanUtils appendImage(@NonNull Drawable drawable2, int align) {
        this.apply(1);
        this.imageDrawable = drawable2;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendImage(@NonNull Uri uri) {
        return this.appendImage(uri, 0);
    }

    public SpanUtils appendImage(@NonNull Uri uri, int align) {
        this.apply(1);
        this.imageUri = uri;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendImage(@DrawableRes int resourceId) {
        return this.appendImage(resourceId, 0);
    }

    public SpanUtils appendImage(@DrawableRes int resourceId, int align) {
        this.apply(1);
        this.imageResourceId = resourceId;
        this.alignImage = align;
        return this;
    }

    public SpanUtils appendSpace(@IntRange(from=0L) int size) {
        return this.appendSpace(size, 0);
    }

    public SpanUtils appendSpace(@IntRange(from=0L) int size, @ColorInt int color2) {
        this.apply(2);
        this.spaceSize = size;
        this.spaceColor = color2;
        return this;
    }

    private void apply(int type) {
        this.applyLast();
        this.mType = type;
    }

    public SpannableStringBuilder create() {
        this.applyLast();
        return this.mBuilder;
    }

    private void applyLast() {
        if (this.mType == 0) {
            this.updateCharCharSequence();
        } else if (this.mType == 1) {
            this.updateImage();
        } else if (this.mType == 2) {
            this.updateSpace();
        }
        this.setDefault();
    }

    private void updateCharCharSequence() {
        if (this.mText.length() == 0) {
            return;
        }
        int start = this.mBuilder.length();
        this.mBuilder.append(this.mText);
        int end = this.mBuilder.length();
        if (this.foregroundColor != -16777217) {
            this.mBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), start, end, this.flag);
        }
        if (this.backgroundColor != -16777217) {
            this.mBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), start, end, this.flag);
        }
        if (this.first != -1) {
            this.mBuilder.setSpan((Object)new LeadingMarginSpan.Standard(this.first, this.rest), start, end, this.flag);
        }
        if (this.quoteColor != -16777217) {
            this.mBuilder.setSpan((Object)new CustomQuoteSpan(this.quoteColor, this.stripeWidth, this.quoteGapWidth), start, end, this.flag);
        }
        if (this.bulletColor != -16777217) {
            this.mBuilder.setSpan((Object)new CustomBulletSpan(this.bulletColor, this.bulletRadius, this.bulletGapWidth), start, end, this.flag);
        }
        if (this.iconMarginGapWidth != -1) {
            if (this.iconMarginBitmap != null) {
                this.mBuilder.setSpan((Object)new CustomIconMarginSpan(this.iconMarginBitmap, this.iconMarginGapWidth, this.alignIconMargin), start, end, this.flag);
            } else if (this.iconMarginDrawable != null) {
                this.mBuilder.setSpan((Object)new CustomIconMarginSpan(this.iconMarginDrawable, this.iconMarginGapWidth, this.alignIconMargin), start, end, this.flag);
            } else if (this.iconMarginUri != null) {
                this.mBuilder.setSpan((Object)new CustomIconMarginSpan(this.iconMarginUri, this.iconMarginGapWidth, this.alignIconMargin), start, end, this.flag);
            } else if (this.iconMarginResourceId != -1) {
                this.mBuilder.setSpan((Object)new CustomIconMarginSpan(this.iconMarginResourceId, this.iconMarginGapWidth, this.alignIconMargin), start, end, this.flag);
            }
        }
        if (this.fontSize != -1) {
            this.mBuilder.setSpan((Object)new AbsoluteSizeSpan(this.fontSize, this.fontSizeIsDp), start, end, this.flag);
        }
        if (this.proportion != -1.0f) {
            this.mBuilder.setSpan((Object)new RelativeSizeSpan(this.proportion), start, end, this.flag);
        }
        if (this.xProportion != -1.0f) {
            this.mBuilder.setSpan((Object)new ScaleXSpan(this.xProportion), start, end, this.flag);
        }
        if (this.lineHeight != -1) {
            this.mBuilder.setSpan((Object)new CustomLineHeightSpan(this.lineHeight, this.alignLine), start, end, this.flag);
        }
        if (this.isStrikethrough) {
            this.mBuilder.setSpan((Object)new StrikethroughSpan(), start, end, this.flag);
        }
        if (this.isUnderline) {
            this.mBuilder.setSpan((Object)new UnderlineSpan(), start, end, this.flag);
        }
        if (this.isSuperscript) {
            this.mBuilder.setSpan((Object)new SuperscriptSpan(), start, end, this.flag);
        }
        if (this.isSubscript) {
            this.mBuilder.setSpan((Object)new SubscriptSpan(), start, end, this.flag);
        }
        if (this.isBold) {
            this.mBuilder.setSpan((Object)new StyleSpan(1), start, end, this.flag);
        }
        if (this.isItalic) {
            this.mBuilder.setSpan((Object)new StyleSpan(2), start, end, this.flag);
        }
        if (this.isBoldItalic) {
            this.mBuilder.setSpan((Object)new StyleSpan(3), start, end, this.flag);
        }
        if (this.fontFamily != null) {
            this.mBuilder.setSpan((Object)new TypefaceSpan(this.fontFamily), start, end, this.flag);
        }
        if (this.typeface != null) {
            this.mBuilder.setSpan((Object)new CustomTypefaceSpan(this.typeface), start, end, this.flag);
        }
        if (this.alignment != null) {
            this.mBuilder.setSpan((Object)new AlignmentSpan.Standard(this.alignment), start, end, this.flag);
        }
        if (this.clickSpan != null) {
            this.mBuilder.setSpan((Object)this.clickSpan, start, end, this.flag);
        }
        if (this.url != null) {
            this.mBuilder.setSpan((Object)new URLSpan(this.url), start, end, this.flag);
        }
        if (this.blurRadius != -1.0f) {
            this.mBuilder.setSpan((Object)new MaskFilterSpan((MaskFilter)new BlurMaskFilter(this.blurRadius, this.style)), start, end, this.flag);
        }
        if (this.shader != null) {
            this.mBuilder.setSpan((Object)new ShaderSpan(this.shader), start, end, this.flag);
        }
        if (this.shadowRadius != -1.0f) {
            this.mBuilder.setSpan((Object)new ShadowSpan(this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor), start, end, this.flag);
        }
        if (this.spans != null) {
            for (Object span : this.spans) {
                this.mBuilder.setSpan(span, start, end, this.flag);
            }
        }
    }

    private void updateImage() {
        int start = this.mBuilder.length();
        this.mBuilder.append((CharSequence)"<img>");
        int end = start + 5;
        if (this.imageBitmap != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageBitmap, this.alignImage), start, end, this.flag);
        } else if (this.imageDrawable != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageDrawable, this.alignImage), start, end, this.flag);
        } else if (this.imageUri != null) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageUri, this.alignImage), start, end, this.flag);
        } else if (this.imageResourceId != -1) {
            this.mBuilder.setSpan((Object)new CustomImageSpan(this.imageResourceId, this.alignImage), start, end, this.flag);
        }
    }

    private void updateSpace() {
        int start = this.mBuilder.length();
        this.mBuilder.append((CharSequence)"< >");
        int end = start + 3;
        this.mBuilder.setSpan((Object)new SpaceSpan(this.spaceSize, this.spaceColor), start, end, this.flag);
    }

    static class ShadowSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private float radius;
        private float dx;
        private float dy;
        private int shadowColor;

        private ShadowSpan(float radius, float dx, float dy, int shadowColor) {
            this.radius = radius;
            this.dx = dx;
            this.dy = dy;
            this.shadowColor = shadowColor;
        }

        public void updateDrawState(TextPaint tp) {
            tp.setShadowLayer(this.radius, this.dx, this.dy, this.shadowColor);
        }
    }

    static class ShaderSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private Shader mShader;

        private ShaderSpan(Shader shader) {
            this.mShader = shader;
        }

        public void updateDrawState(TextPaint tp) {
            tp.setShader(this.mShader);
        }
    }

    static abstract class CustomDynamicDrawableSpan
    extends ReplacementSpan {
        static final int ALIGN_BOTTOM = 0;
        static final int ALIGN_BASELINE = 1;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;
        private WeakReference<Drawable> mDrawableRef;

        private CustomDynamicDrawableSpan() {
            this.mVerticalAlignment = 0;
        }

        private CustomDynamicDrawableSpan(int verticalAlignment) {
            this.mVerticalAlignment = verticalAlignment;
        }

        public abstract Drawable getDrawable();

        public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            int fontHeight = (int)(paint.getFontMetrics().descent - paint.getFontMetrics().ascent);
            if (fm != null && rect.height() > fontHeight) {
                if (this.mVerticalAlignment == 3) {
                    fm.descent += rect.height() - fontHeight;
                } else if (this.mVerticalAlignment == 2) {
                    fm.ascent -= (rect.height() - fontHeight) / 2;
                    fm.descent += (rect.height() - fontHeight) / 2;
                } else {
                    fm.ascent -= rect.height() - fontHeight;
                }
            }
            return rect.right;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            canvas.save();
            float fontHeight = paint.getFontMetrics().descent - paint.getFontMetrics().ascent;
            int transY = bottom - rect.bottom;
            if ((float)rect.height() < fontHeight) {
                if (this.mVerticalAlignment == 1) {
                    transY -= paint.getFontMetricsInt().descent;
                } else if (this.mVerticalAlignment == 2) {
                    transY = (int)((float)transY - (fontHeight - (float)rect.height()) / 2.0f);
                } else if (this.mVerticalAlignment == 3) {
                    transY = (int)((float)transY - (fontHeight - (float)rect.height()));
                }
            }
            canvas.translate(x, (float)transY);
            d.draw(canvas);
            canvas.restore();
        }

        private Drawable getCachedDrawable() {
            WeakReference<Drawable> wr = this.mDrawableRef;
            Drawable d = null;
            if (wr != null) {
                d = (Drawable)wr.get();
            }
            if (d == null) {
                d = this.getDrawable();
                this.mDrawableRef = new WeakReference<Drawable>(d);
            }
            return this.getDrawable();
        }
    }

    class CustomImageSpan
    extends CustomDynamicDrawableSpan {
        private Drawable mDrawable;
        private Uri mContentUri;
        private int mResourceId;

        private CustomImageSpan(Bitmap b, int verticalAlignment) {
            super(verticalAlignment);
            this.mDrawable = new BitmapDrawable(XUI.getContext().getResources(), b);
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        private CustomImageSpan(Drawable d, int verticalAlignment) {
            super(verticalAlignment);
            this.mDrawable = d;
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        private CustomImageSpan(Uri uri, int verticalAlignment) {
            super(verticalAlignment);
            this.mContentUri = uri;
        }

        private CustomImageSpan(int resourceId, int verticalAlignment) {
            super(verticalAlignment);
            this.mResourceId = resourceId;
        }

        @Override
        public Drawable getDrawable() {
            Drawable drawable2 = null;
            if (this.mDrawable != null) {
                drawable2 = this.mDrawable;
            } else if (this.mContentUri != null) {
                try {
                    InputStream is = XUI.getContext().getContentResolver().openInputStream(this.mContentUri);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                    drawable2 = new BitmapDrawable(XUI.getContext().getResources(), bitmap);
                    drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    Log.e((String)"sms", (String)("Failed to loaded content " + this.mContentUri), (Throwable)e);
                }
            } else {
                try {
                    drawable2 = ContextCompat.getDrawable((Context)XUI.getContext(), (int)this.mResourceId);
                    drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                }
                catch (Exception e) {
                    Log.e((String)"sms", (String)("Unable to find resource: " + this.mResourceId));
                }
            }
            return drawable2;
        }
    }

    @SuppressLint(value={"ParcelCreator"})
    static class CustomTypefaceSpan
    extends TypefaceSpan {
        private final Typeface newType;

        private CustomTypefaceSpan(Typeface type) {
            super("");
            this.newType = type;
        }

        public void updateDrawState(@NonNull TextPaint textPaint) {
            this.apply((Paint)textPaint, this.newType);
        }

        public void updateMeasureState(@NonNull TextPaint paint) {
            this.apply((Paint)paint, this.newType);
        }

        private void apply(Paint paint, Typeface tf) {
            Typeface old = paint.getTypeface();
            int oldStyle = old == null ? 0 : old.getStyle();
            int fake = oldStyle & ~tf.getStyle();
            if ((fake & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
            paint.getShader();
            paint.setTypeface(tf);
        }
    }

    static class CustomIconMarginSpan
    implements LeadingMarginSpan,
    LineHeightSpan {
        Bitmap mBitmap;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;
        private int mPad;
        private int totalHeight;
        private int lineHeight;
        private int need0;
        private int need1;
        private boolean flag;

        private CustomIconMarginSpan(Bitmap b, int pad, int verticalAlignment) {
            this.mBitmap = b;
            this.mPad = pad;
            this.mVerticalAlignment = verticalAlignment;
        }

        private CustomIconMarginSpan(Drawable drawable2, int pad, int verticalAlignment) {
            this.mBitmap = this.drawable2Bitmap(drawable2);
            this.mPad = pad;
            this.mVerticalAlignment = verticalAlignment;
        }

        private CustomIconMarginSpan(Uri uri, int pad, int verticalAlignment) {
            this.mBitmap = this.uri2Bitmap(uri);
            this.mPad = pad;
            this.mVerticalAlignment = verticalAlignment;
        }

        private CustomIconMarginSpan(int resourceId, int pad, int verticalAlignment) {
            this.mBitmap = this.resource2Bitmap(resourceId);
            this.mPad = pad;
            this.mVerticalAlignment = verticalAlignment;
        }

        private Bitmap drawable2Bitmap(Drawable drawable2) {
            BitmapDrawable bitmapDrawable;
            if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
                return bitmapDrawable.getBitmap();
            }
            Bitmap bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }

        private Bitmap uri2Bitmap(Uri uri) {
            try {
                return MediaStore.Images.Media.getBitmap((ContentResolver)XUI.getContext().getContentResolver(), (Uri)uri);
            }
            catch (IOException e) {
                e.printStackTrace();
                return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        }

        private Bitmap resource2Bitmap(int resourceId) {
            Drawable drawable2 = ContextCompat.getDrawable((Context)XUI.getContext(), (int)resourceId);
            if (drawable2 == null) {
                return null;
            }
            Canvas canvas = new Canvas();
            Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            canvas.setBitmap(bitmap);
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            drawable2.draw(canvas);
            return bitmap;
        }

        public int getLeadingMargin(boolean first) {
            return this.mBitmap.getWidth() + this.mPad;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
            int delta;
            int st = ((Spanned)text).getSpanStart((Object)this);
            int itop = layout2.getLineTop(layout2.getLineForOffset(st));
            if (dir < 0) {
                x -= this.mBitmap.getWidth();
            }
            if ((delta = this.totalHeight - this.mBitmap.getHeight()) > 0) {
                if (this.mVerticalAlignment == 3) {
                    c.drawBitmap(this.mBitmap, (float)x, (float)itop, p);
                } else if (this.mVerticalAlignment == 2) {
                    c.drawBitmap(this.mBitmap, (float)x, (float)itop + (float)delta / 2.0f, p);
                } else {
                    c.drawBitmap(this.mBitmap, (float)x, (float)(itop + delta), p);
                }
            } else {
                c.drawBitmap(this.mBitmap, (float)x, (float)itop, p);
            }
        }

        public void chooseHeight(CharSequence text, int start, int end, int istartv, int v, Paint.FontMetricsInt fm) {
            if (this.lineHeight == 0) {
                this.lineHeight = v - istartv;
            }
            if (this.need0 == 0 && end == ((Spanned)text).getSpanEnd((Object)this)) {
                int ht = this.mBitmap.getHeight();
                this.need0 = ht - (v + fm.descent - fm.ascent - istartv);
                this.need1 = ht - (v + fm.bottom - fm.top - istartv);
                this.totalHeight = v - istartv + this.lineHeight;
                return;
            }
            if (this.need0 > 0 || this.need1 > 0) {
                if (this.mVerticalAlignment == 3) {
                    if (end == ((Spanned)text).getSpanEnd((Object)this)) {
                        if (this.need0 > 0) {
                            fm.descent += this.need0;
                        }
                        if (this.need1 > 0) {
                            fm.bottom += this.need1;
                        }
                    }
                } else if (this.mVerticalAlignment == 2) {
                    if (start == ((Spanned)text).getSpanStart((Object)this)) {
                        if (this.need0 > 0) {
                            fm.ascent -= this.need0 / 2;
                        }
                        if (this.need1 > 0) {
                            fm.top -= this.need1 / 2;
                        }
                    } else if (!this.flag) {
                        if (this.need0 > 0) {
                            fm.ascent += this.need0 / 2;
                        }
                        if (this.need1 > 0) {
                            fm.top += this.need1 / 2;
                        }
                        this.flag = true;
                    }
                    if (end == ((Spanned)text).getSpanEnd((Object)this)) {
                        if (this.need0 > 0) {
                            fm.descent += this.need0 / 2;
                        }
                        if (this.need1 > 0) {
                            fm.bottom += this.need1 / 2;
                        }
                    }
                } else if (start == ((Spanned)text).getSpanStart((Object)this)) {
                    if (this.need0 > 0) {
                        fm.ascent -= this.need0;
                    }
                    if (this.need1 > 0) {
                        fm.top -= this.need1;
                    }
                } else if (!this.flag) {
                    if (this.need0 > 0) {
                        fm.ascent += this.need0;
                    }
                    if (this.need1 > 0) {
                        fm.top += this.need1;
                    }
                    this.flag = true;
                }
            }
        }
    }

    static class CustomBulletSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int radius;
        private final int gapWidth;
        private Path sBulletPath = null;

        private CustomBulletSpan(int color2, int radius, int gapWidth) {
            this.color = color2;
            this.radius = radius;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return 2 * this.radius + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
            if (((Spanned)text).getSpanStart((Object)this) == start) {
                Paint.Style style2 = p.getStyle();
                int oldColor = 0;
                oldColor = p.getColor();
                p.setColor(this.color);
                p.setStyle(Paint.Style.FILL);
                if (c.isHardwareAccelerated()) {
                    if (this.sBulletPath == null) {
                        this.sBulletPath = new Path();
                        this.sBulletPath.addCircle(0.0f, 0.0f, (float)this.radius, Path.Direction.CW);
                    }
                    c.save();
                    c.translate((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f);
                    c.drawPath(this.sBulletPath, p);
                    c.restore();
                } else {
                    c.drawCircle((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f, (float)this.radius, p);
                }
                p.setColor(oldColor);
                p.setStyle(style2);
            }
        }
    }

    static class CustomQuoteSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int stripeWidth;
        private final int gapWidth;

        private CustomQuoteSpan(int color2, int stripeWidth, int gapWidth) {
            this.color = color2;
            this.stripeWidth = stripeWidth;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return this.stripeWidth + this.gapWidth;
        }

        public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
            Paint.Style style2 = p.getStyle();
            int color2 = p.getColor();
            p.setStyle(Paint.Style.FILL);
            p.setColor(this.color);
            c.drawRect((float)x, (float)top, (float)(x + dir * this.stripeWidth), (float)bottom, p);
            p.setStyle(style2);
            p.setColor(color2);
        }
    }

    static class SpaceSpan
    extends ReplacementSpan {
        private final int width;
        private final int color;

        private SpaceSpan(int width) {
            this(width, 0);
        }

        private SpaceSpan(int width, int color2) {
            this.width = width;
            this.color = color2;
        }

        public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
            return this.width;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Paint.Style style2 = paint.getStyle();
            int color2 = paint.getColor();
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(this.color);
            canvas.drawRect(x, (float)top, x + (float)this.width, (float)bottom, paint);
            paint.setStyle(style2);
            paint.setColor(color2);
        }
    }

    static class CustomLineHeightSpan
    extends CharacterStyle
    implements LineHeightSpan {
        private final int height;
        static final int ALIGN_CENTER = 2;
        static final int ALIGN_TOP = 3;
        final int mVerticalAlignment;

        CustomLineHeightSpan(int height, int verticalAlignment) {
            this.height = height;
            this.mVerticalAlignment = verticalAlignment;
        }

        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
            int need = this.height - (v + fm.descent - fm.ascent - spanstartv);
            if (need > 0) {
                if (this.mVerticalAlignment == 3) {
                    fm.descent += need;
                } else if (this.mVerticalAlignment == 2) {
                    fm.descent += need / 2;
                    fm.ascent -= need / 2;
                } else {
                    fm.ascent -= need;
                }
            }
            if ((need = this.height - (v + fm.bottom - fm.top - spanstartv)) > 0) {
                if (this.mVerticalAlignment == 3) {
                    fm.top += need;
                } else if (this.mVerticalAlignment == 2) {
                    fm.bottom += need / 2;
                    fm.top -= need / 2;
                } else {
                    fm.top -= need;
                }
            }
        }

        public void updateDrawState(TextPaint tp) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Align {
    }
}

