/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.AnyRes;
import androidx.annotation.NonNull;
import androidx.core.content.pm.ShortcutInfoCompat;
import androidx.core.content.pm.ShortcutManagerCompat;
import androidx.core.graphics.drawable.IconCompat;

public final class ShortcutUtils {
    private static final String ACTION_ADD_SHORTCUT = "com.android.launcher.action.INSTALL_SHORTCUT";

    private ShortcutUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean addPinShortcut(@NonNull Context context, @NonNull Class<?> targetClass, @NonNull String shortcutId, @AnyRes int iconResourceId, @NonNull CharSequence shortLabel, Class<? extends BroadcastReceiver> resultReceiver) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ShortcutUtils.addPinShortcutAboveN(context, targetClass, shortcutId, IconCompat.createWithResource((Context)context, (int)iconResourceId), shortLabel, resultReceiver);
        }
        return ShortcutUtils.addShortcutBelowAndroidN(context, targetClass, iconResourceId, shortLabel);
    }

    public static boolean addPinShortcutAboveN(@NonNull Context context, @NonNull Class<?> targetClass, @NonNull String shortcutId, @NonNull IconCompat icon, @NonNull CharSequence shortLabel, Class<? extends BroadcastReceiver> resultReceiver) {
        if (ShortcutManagerCompat.isRequestPinShortcutSupported((Context)context)) {
            Intent shortcutInfoIntent = new Intent(context, targetClass);
            shortcutInfoIntent.setAction("android.intent.action.VIEW");
            ShortcutInfoCompat info = new ShortcutInfoCompat.Builder(context, shortcutId).setIcon(icon).setShortLabel(shortLabel).setIntent(shortcutInfoIntent).build();
            Intent resultIntent = resultReceiver != null ? new Intent(context, resultReceiver) : ShortcutManagerCompat.createShortcutResultIntent((Context)context, (ShortcutInfoCompat)info);
            PendingIntent shortcutCallbackIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)resultIntent, (int)0x8000000);
            return ShortcutManagerCompat.requestPinShortcut((Context)context, (ShortcutInfoCompat)info, (IntentSender)shortcutCallbackIntent.getIntentSender());
        }
        return false;
    }

    public static boolean addShortcutBelowAndroidN(@NonNull Context context, @NonNull Class<?> targetClass, @AnyRes int iconResourceId, @NonNull CharSequence shortLabel) {
        try {
            Intent addShortcutIntent = new Intent(ACTION_ADD_SHORTCUT);
            addShortcutIntent.putExtra("duplicate", false);
            addShortcutIntent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)context, (int)iconResourceId));
            addShortcutIntent.putExtra("android.intent.extra.shortcut.NAME", shortLabel);
            Intent launcherIntent = new Intent();
            launcherIntent.setClass(context, targetClass);
            addShortcutIntent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)launcherIntent);
            context.sendBroadcast(addShortcutIntent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

