/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.AnimRes;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.StyleableRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.xuexiang.xui.XUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ResUtils {
    private ResUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @Deprecated
    public static Resources getResources() {
        return XUI.getContext().getResources();
    }

    public static Resources getResources(@NonNull Context context) {
        return context.getResources();
    }

    @Deprecated
    public static String getString(@StringRes int resId) {
        return ResUtils.getResources().getString(resId);
    }

    public static String getString(@NonNull Context context, @StringRes int resId) {
        return context.getResources().getString(resId);
    }

    @Deprecated
    public static Drawable getDrawable(@DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return XUI.getContext().getDrawable(resId);
        }
        return ResUtils.getResources().getDrawable(resId);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    public static Drawable getVectorDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    public static Drawable getDrawableAttrRes(Context context, TypedArray typedArray, @StyleableRes int styleableResId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return typedArray.getDrawable(styleableResId);
        }
        int resourceId = typedArray.getResourceId(styleableResId, -1);
        if (resourceId != -1) {
            return AppCompatResources.getDrawable((Context)context, (int)resourceId);
        }
        return null;
    }

    public static ColorStateList getColorStateListAttrRes(Context context, TypedArray typedArray, @StyleableRes int styleableResId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return typedArray.getColorStateList(styleableResId);
        }
        int resourceId = typedArray.getResourceId(styleableResId, -1);
        if (resourceId != -1) {
            return AppCompatResources.getColorStateList((Context)context, (int)resourceId);
        }
        return null;
    }

    @Deprecated
    public static float getDimens(@DimenRes int resId) {
        return ResUtils.getResources().getDimension(resId);
    }

    public static float getDimens(@NonNull Context context, @DimenRes int resId) {
        return context.getResources().getDimension(resId);
    }

    @Deprecated
    public static int getColor(@ColorRes int resId) {
        return ResUtils.getResources().getColor(resId);
    }

    public static int getColor(@NonNull Context context, @ColorRes int resId) {
        return ContextCompat.getColor((Context)context, (int)resId);
    }

    @Deprecated
    public static ColorStateList getColors(@ColorRes int resId) {
        return ResUtils.getResources().getColorStateList(resId);
    }

    public static ColorStateList getColors(@NonNull Context context, @ColorRes int resId) {
        return ContextCompat.getColorStateList((Context)context, (int)resId);
    }

    @Deprecated
    public static int getDimensionPixelOffset(@DimenRes int resId) {
        return ResUtils.getResources().getDimensionPixelOffset(resId);
    }

    public static int getDimensionPixelOffset(@NonNull Context context, @DimenRes int resId) {
        return context.getResources().getDimensionPixelOffset(resId);
    }

    @Deprecated
    public static int getDimensionPixelSize(@DimenRes int resId) {
        return ResUtils.getResources().getDimensionPixelSize(resId);
    }

    public static int getDimensionPixelSize(@NonNull Context context, @DimenRes int resId) {
        return context.getResources().getDimensionPixelSize(resId);
    }

    @Deprecated
    public static String[] getStringArray(@ArrayRes int resId) {
        return ResUtils.getResources().getStringArray(resId);
    }

    public static String[] getStringArray(Context context, @ArrayRes int resId) {
        return context.getResources().getStringArray(resId);
    }

    @NonNull
    public static List<String> getStringList(@NonNull Context context, int resId) {
        return ResUtils.getStringList(context, resId, 0);
    }

    @NonNull
    public static List<String> getStringList(@NonNull Context context, int resId, int emptyId) {
        ArrayList<String> data = new ArrayList<String>();
        if (resId == emptyId) {
            return data;
        }
        String[] array = context.getResources().getStringArray(resId);
        if (array.length > 0) {
            data.addAll(Arrays.asList(array));
        }
        return data;
    }

    public static Drawable[] getDrawableArray(Context context, @ArrayRes int resId) {
        TypedArray ta = ResUtils.getResources().obtainTypedArray(resId);
        Drawable[] icons = new Drawable[ta.length()];
        for (int i = 0; i < ta.length(); ++i) {
            int id2 = ta.getResourceId(i, 0);
            if (id2 == 0) continue;
            icons[i] = ContextCompat.getDrawable((Context)context, (int)id2);
        }
        ta.recycle();
        return icons;
    }

    @Deprecated
    public static int[] getIntArray(@ArrayRes int resId) {
        return ResUtils.getResources().getIntArray(resId);
    }

    public static int[] getIntArray(@NonNull Context context, @ArrayRes int resId) {
        return context.getResources().getIntArray(resId);
    }

    @Deprecated
    public static Animation getAnim(@AnimRes int resId) {
        return AnimationUtils.loadAnimation((Context)XUI.getContext(), (int)resId);
    }

    public static Animation getAnim(@NonNull Context context, @AnimRes int resId) {
        return AnimationUtils.loadAnimation((Context)context, (int)resId);
    }

    @Deprecated
    public static boolean isRtl() {
        return Build.VERSION.SDK_INT >= 17 && ResUtils.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    public static boolean isRtl(@NonNull Context context) {
        return Build.VERSION.SDK_INT >= 17 && context.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    public static int darker(int color2, float factor) {
        return Color.argb((int)Color.alpha((int)color2), (int)Math.max((int)((float)Color.red((int)color2) * factor), 0), (int)Math.max((int)((float)Color.green((int)color2) * factor), 0), (int)Math.max((int)((float)Color.blue((int)color2) * factor), 0));
    }

    public static int lighter(int color2, float factor) {
        int red = (int)(((float)Color.red((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int green = (int)(((float)Color.green((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int blue = (int)(((float)Color.blue((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        return Color.argb((int)Color.alpha((int)color2), (int)red, (int)green, (int)blue);
    }
}

