/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Rect;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.NonNull;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import java.lang.reflect.Field;
import java.util.HashMap;

public class KeyboardUtils
implements ViewTreeObserver.OnGlobalLayoutListener {
    private SoftKeyboardToggleListener mCallback;
    private ViewGroup mRootView;
    private Boolean prevValue = null;
    private static HashMap<SoftKeyboardToggleListener, KeyboardUtils> sListenerMap = new HashMap();

    public void onGlobalLayout() {
        boolean isVisible = KeyboardUtils.isSoftInputShow(this.mRootView);
        if (this.mCallback != null && (this.prevValue == null || isVisible != this.prevValue)) {
            this.prevValue = isVisible;
            this.mCallback.onToggleSoftKeyboard(isVisible);
        }
    }

    public static void addKeyboardToggleListener(Activity act, SoftKeyboardToggleListener listener) {
        KeyboardUtils.removeKeyboardToggleListener(listener);
        sListenerMap.put(listener, new KeyboardUtils(act, listener));
    }

    public static void addKeyboardToggleListener(ViewGroup act, SoftKeyboardToggleListener listener) {
        KeyboardUtils.removeKeyboardToggleListener(listener);
        sListenerMap.put(listener, new KeyboardUtils(act, listener));
    }

    public static void removeKeyboardToggleListener(SoftKeyboardToggleListener listener) {
        if (sListenerMap.containsKey(listener)) {
            KeyboardUtils k = sListenerMap.get(listener);
            if (k != null) {
                k.removeListener();
            }
            sListenerMap.remove(listener);
        }
    }

    public static void removeAllKeyboardToggleListeners() {
        for (SoftKeyboardToggleListener l : sListenerMap.keySet()) {
            KeyboardUtils k = sListenerMap.get(l);
            if (k == null) continue;
            k.removeListener();
        }
        sListenerMap.clear();
    }

    public static void toggleKeyboardVisibility(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        inputMethodManager.toggleSoftInput(2, 0);
    }

    public static void forceCloseKeyboard(View activeView) {
        InputMethodManager inputMethodManager = (InputMethodManager)activeView.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(activeView.getWindowToken(), 0);
    }

    private void removeListener() {
        this.mCallback = null;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.mRootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    private KeyboardUtils(Activity activity, SoftKeyboardToggleListener listener) {
        this.mCallback = listener;
        this.mRootView = (ViewGroup)activity.getWindow().getDecorView();
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private KeyboardUtils(ViewGroup viewGroup, SoftKeyboardToggleListener listener) {
        this.mCallback = listener;
        this.mRootView = viewGroup;
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public static void setSoftInputAdjustNothing(@NonNull Activity activity) {
        activity.getWindow().setSoftInputMode(50);
    }

    public static void setSoftInputAdjustResize(@NonNull Activity activity) {
        activity.getWindow().setSoftInputMode(18);
    }

    public static void setSoftInputAdjustPan(@NonNull Activity activity) {
        activity.getWindow().setSoftInputMode(34);
    }

    public static boolean isSoftInputShow(Activity activity) {
        return activity != null && KeyboardUtils.isSoftInputShow(activity.getWindow());
    }

    public static boolean isSoftInputShow(Window window) {
        if (window != null && window.getDecorView() instanceof ViewGroup) {
            return KeyboardUtils.isSoftInputShow((ViewGroup)window.getDecorView());
        }
        return false;
    }

    public static boolean isSoftInputShow(ViewGroup rootView) {
        if (rootView == null) {
            return false;
        }
        int viewHeight = rootView.getHeight();
        Rect rect = new Rect();
        rootView.getWindowVisibleDisplayFrame(rect);
        int space = viewHeight - rect.bottom - DensityUtils.getNavigationBarHeight(rootView.getContext());
        return space > 0;
    }

    public static boolean onDisableBackKeyDown(int keyCode) {
        switch (keyCode) {
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    public static void dispatchTouchEvent(MotionEvent ev, @NonNull Activity activity) {
        KeyboardUtils.dispatchTouchEvent(ev, activity.getWindow());
    }

    public static void dispatchTouchEvent(MotionEvent ev, @NonNull Dialog dialog) {
        KeyboardUtils.dispatchTouchEvent(ev, dialog.getWindow());
    }

    public static void dispatchTouchEvent(MotionEvent ev, Window window) {
        if (ev == null || window == null) {
            return;
        }
        if (ev.getAction() == 0 && KeyboardUtils.isShouldHideKeyboard(window, ev)) {
            KeyboardUtils.hideSoftInputClearFocus(window.getCurrentFocus());
        }
    }

    public static boolean isShouldHideKeyboard(View view, MotionEvent event) {
        if (view instanceof EditText && event != null) {
            return !KeyboardUtils.isTouchView(view, event);
        }
        return false;
    }

    public static boolean isShouldHideKeyboard(Window window, MotionEvent event) {
        if (window == null || event == null) {
            return false;
        }
        if (!KeyboardUtils.isSoftInputShow(window)) {
            return false;
        }
        if (!(window.getCurrentFocus() instanceof EditText)) {
            return false;
        }
        View decorView = window.getDecorView();
        if (decorView instanceof ViewGroup) {
            return KeyboardUtils.findTouchEditText((ViewGroup)decorView, event) == null;
        }
        return false;
    }

    private static View findTouchEditText(ViewGroup viewGroup, MotionEvent event) {
        if (viewGroup == null) {
            return null;
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (child == null || !child.isShown() || !KeyboardUtils.isTouchView(child, event)) continue;
            if (child instanceof EditText) {
                return child;
            }
            if (!(child instanceof ViewGroup)) continue;
            return KeyboardUtils.findTouchEditText((ViewGroup)child, event);
        }
        return null;
    }

    private static boolean isTouchView(View view, MotionEvent event) {
        if (view == null || event == null) {
            return false;
        }
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return event.getY() >= (float)top && event.getY() <= (float)bottom && event.getX() >= (float)left && event.getX() <= (float)right;
    }

    public static void hideSoftInput(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInput(@NonNull DialogInterface dialog) {
        if (dialog instanceof Dialog) {
            KeyboardUtils.hideSoftInput((Dialog)dialog);
        }
    }

    public static void hideSoftInput(@NonNull Dialog dialog) {
        View view = dialog.getCurrentFocus();
        if (view == null && dialog.getWindow() != null) {
            view = dialog.getWindow().getDecorView();
        }
        KeyboardUtils.hideSoftInput(view);
    }

    public static void hideSoftInputClearFocus(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        if (view instanceof EditText) {
            view.clearFocus();
        }
    }

    public static void toggleSoftInput() {
        InputMethodManager imm = (InputMethodManager)XUI.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(2, 0);
    }

    public static void showSoftInputForce(Activity activity) {
        if (!KeyboardUtils.isSoftInputShow(activity)) {
            KeyboardUtils.toggleSoftInput();
        }
    }

    public static void showSoftInput(EditText view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.showSoftInput((View)view, 2);
    }

    public static void fixSoftInputLeaks(Context context) {
        String[] strArr;
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        for (String s : strArr = new String[]{"mCurRootView", "mServedView", "mNextServedView"}) {
            try {
                Object obj;
                Field declaredField = imm.getClass().getDeclaredField(s);
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                if (!((obj = declaredField.get(imm)) instanceof View)) continue;
                View view = (View)obj;
                if (view.getContext() == context) {
                    declaredField.set(imm, null);
                    continue;
                }
                return;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static interface SoftKeyboardToggleListener {
        public void onToggleSoftKeyboard(boolean var1);
    }
}

