/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.ScrollView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.widget.NestedScrollView;
import com.xuexiang.xui.utils.ColorUtils;
import com.xuexiang.xui.utils.ResUtils;
import java.security.InvalidParameterException;

public final class DrawableUtils {
    private static final String TAG = DrawableUtils.class.getSimpleName();
    private static final Canvas CANVAS = new Canvas();

    private DrawableUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap createBitmapFromView(View view, float scale) {
        Bitmap bitmap;
        int i;
        Drawable drawable2;
        if (view instanceof ImageView && (drawable2 = ((ImageView)view).getDrawable()) != null && drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        view.clearFocus();
        int viewHeight = 0;
        if (view instanceof ScrollView) {
            for (i = 0; i < ((ScrollView)view).getChildCount(); ++i) {
                viewHeight += ((ScrollView)view).getChildAt(i).getHeight();
            }
        } else if (view instanceof NestedScrollView) {
            for (i = 0; i < ((NestedScrollView)view).getChildCount(); ++i) {
                viewHeight += ((NestedScrollView)view).getChildAt(i).getHeight();
            }
        } else {
            viewHeight = view.getHeight();
        }
        if ((bitmap = DrawableUtils.createBitmapSafely((int)((float)view.getWidth() * scale), (int)((float)viewHeight * scale), Bitmap.Config.ARGB_8888, 1)) != null) {
            Canvas canvas = CANVAS;
            synchronized (canvas) {
                Canvas canvas2 = CANVAS;
                canvas2.setBitmap(bitmap);
                canvas2.save();
                canvas2.drawColor(-1);
                canvas2.scale(scale, scale);
                view.draw(canvas2);
                canvas2.restore();
                canvas2.setBitmap(null);
            }
        }
        return bitmap;
    }

    public static Bitmap createBitmapFromWebView(WebView view) {
        return DrawableUtils.createBitmapFromWebView(view, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap createBitmapFromWebView(WebView view, float scale) {
        view.clearFocus();
        int viewHeight = (int)((float)view.getContentHeight() * view.getScale());
        Bitmap bitmap = DrawableUtils.createBitmapSafely((int)((float)view.getWidth() * scale), (int)((float)viewHeight * scale), Bitmap.Config.ARGB_8888, 1);
        int unitHeight = view.getHeight();
        int bottom = viewHeight;
        if (bitmap != null) {
            Canvas canvas = CANVAS;
            synchronized (canvas) {
                Canvas canvas2 = CANVAS;
                canvas2.setBitmap(bitmap);
                canvas2.drawColor(-1);
                canvas2.scale(scale, scale);
                while (bottom > 0) {
                    bottom = bottom < unitHeight ? 0 : (bottom -= unitHeight);
                    canvas2.save();
                    canvas2.clipRect(0, bottom, canvas2.getWidth(), bottom + unitHeight);
                    view.scrollTo(0, bottom);
                    view.draw(canvas2);
                    canvas2.restore();
                }
                canvas2.setBitmap(null);
            }
        }
        return bitmap;
    }

    public static Bitmap createBitmapFromView(View view) {
        return DrawableUtils.createBitmapFromView(view, 1.0f);
    }

    public static Bitmap createBitmapFromView(View view, int leftCrop, int topCrop, int rightCrop, int bottomCrop) {
        Bitmap originBitmap = DrawableUtils.createBitmapFromView(view);
        if (originBitmap == null) {
            return null;
        }
        Bitmap cutBitmap = DrawableUtils.createBitmapSafely(view.getWidth() - rightCrop - leftCrop, view.getHeight() - topCrop - bottomCrop, Bitmap.Config.ARGB_8888, 1);
        if (cutBitmap == null) {
            return null;
        }
        Canvas canvas = new Canvas(cutBitmap);
        Rect src = new Rect(leftCrop, topCrop, view.getWidth() - rightCrop, view.getHeight() - bottomCrop);
        Rect dest = new Rect(0, 0, view.getWidth() - rightCrop - leftCrop, view.getHeight() - topCrop - bottomCrop);
        canvas.drawColor(-1);
        canvas.drawBitmap(originBitmap, src, dest, null);
        originBitmap.recycle();
        return cutBitmap;
    }

    public static Bitmap createBitmapSafely(int width, int height, Bitmap.Config config, int retryCount) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (retryCount > 0) {
                System.gc();
                return DrawableUtils.createBitmapSafely(width, height, config, retryCount - 1);
            }
            return null;
        }
    }

    public static Bitmap createBitmapSafely(@NonNull Bitmap source, int x, int y, int width, int height, int retryCount) {
        if (x < 0 || y < 0 || width <= 0 || height <= 0) {
            return null;
        }
        try {
            return Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)width, (int)height);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (retryCount > 0) {
                System.gc();
                return DrawableUtils.createBitmapSafely(source, x, y, width, height, retryCount - 1);
            }
            return null;
        }
    }

    public static BitmapDrawable createDrawableWithSize(Resources resources, int width, int height, int cornerRadius, @ColorInt int filledColor) {
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        if (filledColor == 0) {
            filledColor = 0;
        }
        if (cornerRadius > 0) {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(filledColor);
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), (float)cornerRadius, (float)cornerRadius, paint);
        } else {
            canvas.drawColor(filledColor);
        }
        return new BitmapDrawable(resources, output);
    }

    public static ColorFilter setDrawableTintColor(Drawable drawable2, @ColorInt int tintColor) {
        LightingColorFilter colorFilter = new LightingColorFilter(Color.argb((int)255, (int)0, (int)0, (int)0), tintColor);
        if (drawable2 != null) {
            drawable2.setColorFilter((ColorFilter)colorFilter);
        }
        return colorFilter;
    }

    public static GradientDrawable createCircleGradientDrawable(@ColorInt int startColor, @ColorInt int endColor, int radius, @FloatRange(from=0.0, to=1.0) float centerX, @FloatRange(from=0.0, to=1.0) float centerY) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColors(new int[]{startColor, endColor});
        gradientDrawable.setGradientType(1);
        gradientDrawable.setGradientRadius((float)radius);
        gradientDrawable.setGradientCenter(centerX, centerY);
        return gradientDrawable;
    }

    public static LayerDrawable createItemSeparatorBg(@ColorInt int separatorColor, @ColorInt int bgColor, int separatorHeight, boolean top) {
        ShapeDrawable separator = new ShapeDrawable();
        separator.getPaint().setStyle(Paint.Style.FILL);
        separator.getPaint().setColor(separatorColor);
        ShapeDrawable bg = new ShapeDrawable();
        bg.getPaint().setStyle(Paint.Style.FILL);
        bg.getPaint().setColor(bgColor);
        Drawable[] layers = new Drawable[]{separator, bg};
        LayerDrawable layerDrawable = new LayerDrawable(layers);
        layerDrawable.setLayerInset(1, 0, top ? separatorHeight : 0, 0, top ? 0 : separatorHeight);
        return layerDrawable;
    }

    public static BitmapDrawable createCircleDrawableWithText(Resources resources, int size, @ColorInt int filledColor, String text, float textSize, @ColorInt int textColor) {
        if (size <= 0) {
            throw new InvalidParameterException("bitmap size must be > 0!");
        }
        if (textSize <= 0.0f) {
            throw new InvalidParameterException("text size must be > 0!");
        }
        Bitmap output = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.drawColor(0);
        int radius = size / 2;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(filledColor);
        canvas.drawCircle((float)radius, (float)radius, (float)radius, paint);
        paint.setColor(textColor);
        paint.setTextSize(textSize);
        paint.setTextAlign(Paint.Align.CENTER);
        float baseline = (float)radius + DrawableUtils.getBaselineDistance(paint);
        canvas.drawText(text, (float)radius, baseline, paint);
        return new BitmapDrawable(resources, output);
    }

    public static float getBaselineDistance(@NonNull Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
    }

    public static StateListDrawable getDrawable(int cornerRadius) {
        return DrawableUtils.getDrawable(cornerRadius, ColorUtils.getRandomColor());
    }

    public static StateListDrawable getDrawable(int cornerRadius, int normalColor) {
        return DrawableUtils.getDrawable(cornerRadius, ColorUtils.darker(normalColor, 0.8f), normalColor);
    }

    public static StateListDrawable getDrawable(int cornerRadius, int pressedColor, int normalColor) {
        return DrawableUtils.getStateListDrawable((Drawable)DrawableUtils.getSolidRectDrawable(cornerRadius, pressedColor), (Drawable)DrawableUtils.getSolidRectDrawable(cornerRadius, normalColor));
    }

    public static StateListDrawable getStateListDrawable(Drawable pressedDrawable, Drawable normalDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910, 16842919}, pressedDrawable);
        stateListDrawable.addState(new int[]{16842910}, normalDrawable);
        GradientDrawable gray = DrawableUtils.getSolidRectDrawable(10, -7829368);
        stateListDrawable.addState(new int[0], (Drawable)gray);
        return stateListDrawable;
    }

    public static GradientDrawable getSolidRectDrawable(int cornerRadius, int solidColor) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setCornerRadius((float)cornerRadius);
        gradientDrawable.setColor(solidColor);
        gradientDrawable.setGradientType(1);
        return gradientDrawable;
    }

    public static Drawable setTint(Drawable drawable2, @ColorInt int tint) {
        if (drawable2 != null) {
            DrawableCompat.setTint((Drawable)drawable2, (int)tint);
        }
        return drawable2;
    }

    public static Drawable setTintList(Drawable drawable2, @Nullable ColorStateList tint) {
        if (drawable2 != null) {
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)tint);
        }
        return drawable2;
    }

    @Nullable
    public static Drawable getVectorDrawable(Context context, @DrawableRes int resVector) {
        try {
            return AppCompatResources.getDrawable((Context)context, (int)resVector);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Bitmap vectorDrawableToBitmap(Context context, @DrawableRes int resVector) {
        Drawable drawable2 = DrawableUtils.getVectorDrawable(context, resVector);
        if (drawable2 != null) {
            return DrawableUtils.drawable2Bitmap(drawable2);
        }
        return null;
    }

    public static Drawable getSupportRTLDrawable(@NonNull Context context, Drawable src) {
        return DrawableUtils.getSupportRTLDrawable(context, src, false);
    }

    public static Drawable getSupportRTLDrawable(@NonNull Context context, Drawable src, boolean recycle) {
        if (ResUtils.isRtl(context)) {
            return DrawableUtils.rotate(src, 180, 0.0f, 0.0f, recycle);
        }
        return src;
    }

    public static Drawable rotate(Drawable src, int degrees, float px, float py, boolean recycle) {
        return DrawableUtils.bitmap2Drawable(DrawableUtils.rotate(DrawableUtils.drawable2Bitmap(src), degrees, px, py, recycle));
    }

    public static Bitmap rotate(Bitmap src, int degrees, float px, float py, boolean recycle) {
        if (DrawableUtils.isEmptyBitmap(src)) {
            return null;
        }
        if (src.isRecycled()) {
            return null;
        }
        if (degrees == 0) {
            return src;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float)degrees, px, py);
        Bitmap ret = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return ret;
    }

    private static boolean isEmptyBitmap(Bitmap src) {
        return src == null || src.getWidth() == 0 || src.getHeight() == 0;
    }

    public static Bitmap getBitmapByDrawableId(Context context, @DrawableRes int resId) {
        return DrawableUtils.drawable2Bitmap(ResUtils.getDrawable(context, resId));
    }

    public static Bitmap drawable2Bitmap(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(ResUtils.getResources(), bitmap);
    }
}

