/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;

public final class DividerUtils {
    private DividerUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void drawTop(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int left = child.getLeft() - params.leftMargin - drawable2.getIntrinsicWidth();
        int right = child.getRight() + params.rightMargin + drawable2.getIntrinsicWidth();
        int top = child.getTop() - params.topMargin - drawable2.getIntrinsicHeight();
        int bottom = top + drawable2.getIntrinsicHeight();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawBottom(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int left = child.getLeft() - params.leftMargin - drawable2.getIntrinsicWidth();
        int right = child.getRight() + params.rightMargin + drawable2.getIntrinsicWidth();
        int top = child.getBottom() + params.bottomMargin;
        int bottom = top + drawable2.getIntrinsicHeight();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawLeft(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int top = child.getTop() - params.topMargin - drawable2.getIntrinsicHeight();
        int bottom = child.getBottom() + params.bottomMargin + drawable2.getIntrinsicHeight();
        int left = child.getLeft() - params.leftMargin - drawable2.getIntrinsicWidth();
        int right = left + drawable2.getIntrinsicWidth();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawRight(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int top = child.getTop() - params.topMargin - drawable2.getIntrinsicHeight();
        int bottom = child.getBottom() + params.bottomMargin + drawable2.getIntrinsicHeight();
        int left = child.getRight() + params.rightMargin;
        int right = left + drawable2.getIntrinsicWidth();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawTopAlignItem(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int left = child.getLeft() - params.leftMargin;
        int right = child.getRight() + params.rightMargin;
        int top = child.getTop() - params.topMargin - drawable2.getIntrinsicHeight();
        int bottom = top + drawable2.getIntrinsicHeight();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawBottomAlignItem(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int left = child.getLeft() - params.leftMargin;
        int right = child.getRight() + params.rightMargin;
        int top = child.getBottom() + params.bottomMargin;
        int bottom = top + drawable2.getIntrinsicHeight();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawLeftAlignItem(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int top = child.getTop() - params.topMargin;
        int bottom = child.getBottom() + params.bottomMargin;
        int left = child.getLeft() - params.leftMargin - drawable2.getIntrinsicWidth();
        int right = left + drawable2.getIntrinsicWidth();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }

    public static void drawRightAlignItem(Canvas canvas, Drawable drawable2, View child, ViewGroup.MarginLayoutParams params) {
        int top = child.getTop() - params.topMargin;
        int bottom = child.getBottom() + params.bottomMargin;
        int left = child.getRight() + params.rightMargin;
        int right = left + drawable2.getIntrinsicWidth();
        drawable2.setBounds(left, top, right, bottom);
        drawable2.draw(canvas);
    }
}

