/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ResUtils;

public final class DensityUtils {
    private DensityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @Deprecated
    public static DisplayMetrics getDisplayMetrics() {
        return ResUtils.getResources().getDisplayMetrics();
    }

    public static DisplayMetrics getDisplayMetrics(@NonNull Context context) {
        return context.getResources().getDisplayMetrics();
    }

    @Deprecated
    public static int dp2px(float dpValue) {
        float scale = ResUtils.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @Deprecated
    public static int px2dp(float pxValue) {
        float scale = ResUtils.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    @Deprecated
    public static int px2sp(float pxValue) {
        float fontScale = ResUtils.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    @Deprecated
    public static int sp2px(float spValue) {
        float fontScale = ResUtils.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    @Deprecated
    public static int getScreenDpi() {
        return DensityUtils.getDisplayMetrics().densityDpi;
    }

    public static int getScreenDpi(@NonNull Context context) {
        return DensityUtils.getDisplayMetrics((Context)context).densityDpi;
    }

    public static int getRealDpi(Context context) {
        DisplayMetrics metric = context.getResources().getDisplayMetrics();
        float xdpi = metric.xdpi;
        float ydpi = metric.ydpi;
        return (int)((xdpi + ydpi) / 2.0f + 0.5f);
    }

    public static Point getAppSize(Activity activity, boolean isReal) {
        return DensityUtils.getDisplaySize((Context)activity, isReal);
    }

    public static Point getScreenSize(boolean isReal) {
        return DensityUtils.getDisplaySize(XUI.getContext(), isReal);
    }

    public static Point getDisplaySize(Context context, boolean isReal) {
        WindowManager windowManager = context instanceof Activity ? ((Activity)context).getWindowManager() : (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return null;
        }
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        if (isReal) {
            display.getRealSize(point);
        } else {
            display.getSize(point);
        }
        return point;
    }

    public static int getDisplayWidth(Context context, boolean isReal) {
        Point point = DensityUtils.getDisplaySize(context, isReal);
        return point != null ? point.x : 0;
    }

    public static int getDisplayHeight(Context context, boolean isReal) {
        Point point = DensityUtils.getDisplaySize(context, isReal);
        return point != null ? point.y : 0;
    }

    public static DisplayMetrics getAppMetrics(Activity activity, boolean isReal) {
        return DensityUtils.getDisplayMetrics((Context)activity, isReal);
    }

    public static DisplayMetrics getScreenMetrics(boolean isReal) {
        return DensityUtils.getDisplayMetrics(XUI.getContext(), isReal);
    }

    public static DisplayMetrics getDisplayMetrics(Context context, boolean isReal) {
        WindowManager windowManager = context instanceof Activity ? ((Activity)context).getWindowManager() : (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return null;
        }
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        if (isReal) {
            display.getRealMetrics(metrics);
        } else {
            display.getMetrics(metrics);
        }
        return metrics;
    }

    public static boolean isNavigationBarExist(Context context) {
        return DensityUtils.getNavigationBarHeight(context) > 0;
    }

    public static int getNavigationBarHeight(Context context) {
        WindowManager windowManager = context instanceof Activity ? ((Activity)context).getWindowManager() : (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        Display defaultDisplay = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            defaultDisplay.getRealMetrics(realDisplayMetrics);
        }
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        if (realHeight - displayHeight > 0) {
            return realHeight - displayHeight;
        }
        return Math.max(realWidth - displayWidth, 0);
    }
}

