/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.os.CountDownTimer;
import android.widget.TextView;
import com.xuexiang.xui.R;

public class CountDownButtonHelper {
    private CountDownTimer mCountDownTimer;
    private OnCountDownListener mListener;
    private TextView mButton;
    private int mCountDownTime;
    private int mInterval;

    public CountDownButtonHelper(TextView button, int countDownTime) {
        this(button, countDownTime, 1);
    }

    public CountDownButtonHelper(TextView button, int countDownTime, int interval) {
        this.mButton = button;
        this.mCountDownTime = countDownTime;
        this.mInterval = interval;
        this.initCountDownTimer();
    }

    private void initCountDownTimer() {
        if (this.mCountDownTimer == null) {
            this.mCountDownTimer = new CountDownTimer(this.mCountDownTime * 1000, this.mInterval * 1000 - 10){

                public void onTick(long time) {
                    int surplusTime = (int)((time + 15L) / 1000L);
                    if (CountDownButtonHelper.this.mListener != null) {
                        CountDownButtonHelper.this.mListener.onCountDown(surplusTime);
                    } else {
                        CountDownButtonHelper.this.mButton.setText((CharSequence)(surplusTime + "s"));
                    }
                }

                public void onFinish() {
                    CountDownButtonHelper.this.mButton.setEnabled(true);
                    if (CountDownButtonHelper.this.mListener != null) {
                        CountDownButtonHelper.this.mListener.onFinished();
                    } else {
                        CountDownButtonHelper.this.mButton.setText((CharSequence)CountDownButtonHelper.this.mButton.getResources().getString(R.string.xui_count_down_finish));
                    }
                }
            };
        }
    }

    public void start() {
        this.initCountDownTimer();
        this.mButton.setEnabled(false);
        this.mCountDownTimer.start();
    }

    public CountDownButtonHelper setOnCountDownListener(OnCountDownListener listener) {
        this.mListener = listener;
        return this;
    }

    public void cancel() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
            this.mCountDownTimer = null;
        }
    }

    public void recycle() {
        this.cancel();
        this.mListener = null;
        this.mButton = null;
    }

    public static interface OnCountDownListener {
        public void onCountDown(int var1);

        public void onFinished();
    }
}

