/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import java.util.Random;

public final class ColorUtils {
    private ColorUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int setColorAlpha(@ColorInt int color2, float alpha) {
        return ColorUtils.setColorAlpha(color2, alpha, true);
    }

    public static int setColorAlpha(@ColorInt int color2, float alpha, boolean override) {
        int origin = override ? 255 : color2 >> 24 & 0xFF;
        return color2 & 0xFFFFFF | (int)(alpha * (float)origin) << 24;
    }

    public static int computeColor(@ColorInt int fromColor, @ColorInt int toColor, float fraction) {
        fraction = Math.max(Math.min(fraction, 1.0f), 0.0f);
        int minColorA = Color.alpha((int)fromColor);
        int maxColorA = Color.alpha((int)toColor);
        int resultA = (int)((float)(maxColorA - minColorA) * fraction) + minColorA;
        int minColorR = Color.red((int)fromColor);
        int maxColorR = Color.red((int)toColor);
        int resultR = (int)((float)(maxColorR - minColorR) * fraction) + minColorR;
        int minColorG = Color.green((int)fromColor);
        int maxColorG = Color.green((int)toColor);
        int resultG = (int)((float)(maxColorG - minColorG) * fraction) + minColorG;
        int minColorB = Color.blue((int)fromColor);
        int maxColorB = Color.blue((int)toColor);
        int resultB = (int)((float)(maxColorB - minColorB) * fraction) + minColorB;
        return Color.argb((int)resultA, (int)resultR, (int)resultG, (int)resultB);
    }

    public static String colorToString(@ColorInt int color2) {
        return String.format("#%08X", color2);
    }

    public static int darker(int color2) {
        return ColorUtils.darker(color2, 0.8f);
    }

    public static int darker(int color2, float factor) {
        return Color.argb((int)Color.alpha((int)color2), (int)Math.max((int)((float)Color.red((int)color2) * factor), 0), (int)Math.max((int)((float)Color.green((int)color2) * factor), 0), (int)Math.max((int)((float)Color.blue((int)color2) * factor), 0));
    }

    public static int lighter(int color2) {
        return ColorUtils.lighter(color2, 0.8f);
    }

    public static int lighter(int color2, float factor) {
        int red = (int)(((float)Color.red((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int green = (int)(((float)Color.green((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int blue = (int)(((float)Color.blue((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        return Color.argb((int)Color.alpha((int)color2), (int)red, (int)green, (int)blue);
    }

    public static boolean isColorDark(@ColorInt int color2) {
        return ColorUtils.isColorDark(color2, 0.5);
    }

    public static boolean isColorDark(@ColorInt int color2, double factor) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / 255.0;
        return darkness >= factor;
    }

    public static int getRandomColor() {
        return new RandomColor(255, 0, 255).getColor();
    }

    public static class RandomColor {
        int alpha;
        int lower;
        int upper;

        RandomColor(int alpha, int lower, int upper) {
            if (upper <= lower) {
                throw new IllegalArgumentException("must be lower < upper");
            }
            this.setAlpha(alpha);
            this.setLower(lower);
            this.setUpper(upper);
        }

        public int getColor() {
            int red = this.getLower() + new Random().nextInt(this.getUpper() - this.getLower() + 1);
            int green = this.getLower() + new Random().nextInt(this.getUpper() - this.getLower() + 1);
            int blue = this.getLower() + new Random().nextInt(this.getUpper() - this.getLower() + 1);
            return Color.argb((int)this.getAlpha(), (int)red, (int)green, (int)blue);
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(int alpha) {
            if (alpha > 255) {
                alpha = 255;
            }
            if (alpha < 0) {
                alpha = 0;
            }
            this.alpha = alpha;
        }

        int getLower() {
            return this.lower;
        }

        void setLower(int lower) {
            if (lower < 0) {
                lower = 0;
            }
            this.lower = lower;
        }

        int getUpper() {
            return this.upper;
        }

        void setUpper(int upper) {
            if (upper > 255) {
                upper = 255;
            }
            this.upper = upper;
        }
    }
}

