/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import androidx.annotation.Nullable;
import java.util.Collection;
import java.util.List;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static <E> boolean isIndexValid(Collection<E> collection, int index) {
        return collection != null && index >= 0 && index < collection.size();
    }

    @Nullable
    public static <E> E getListItem(List<E> list, int index) {
        return CollectionUtils.isIndexValid(list, index) ? (E)list.get(index) : null;
    }

    public static <E> int getSize(Collection<E> collection) {
        return collection != null ? collection.size() : 0;
    }

    public static <E> boolean isEmpty(Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <E> void clear(Collection<E> collection) {
        if (!CollectionUtils.isEmpty(collection)) {
            collection.clear();
        }
    }
}

