/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.simple;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.adapter.simple.AdapterItem;
import com.xuexiang.xui.adapter.simple.ExpandableItem;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XUISimpleExpandableListAdapter
extends BaseExpandableListAdapter {
    private List<ExpandableItem> mData;
    private int mPaddingStartPx;
    private int mArrowUpResId = R.drawable.xui_ic_expand_arrow_up;
    private int mArrowDownResId = R.drawable.xui_ic_expand_arrow_down;

    public XUISimpleExpandableListAdapter(List<ExpandableItem> data) {
        this.mData = data;
    }

    public XUISimpleExpandableListAdapter(ExpandableItem ... data) {
        this.mData = new ArrayList<ExpandableItem>(Arrays.asList(data));
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupViewHolder groupViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xui_layout_expand_group_item, parent, false);
            groupViewHolder = new GroupViewHolder();
            groupViewHolder.ivIcon = (AppCompatImageView)convertView.findViewById(R.id.iv_icon);
            groupViewHolder.tvTitle = (TextView)convertView.findViewById(R.id.tv_group_name);
            groupViewHolder.ivIndicator = (AppCompatImageView)convertView.findViewById(R.id.iv_indicator);
            convertView.setTag((Object)groupViewHolder);
        } else {
            groupViewHolder = (GroupViewHolder)convertView.getTag();
        }
        AdapterItem group = this.getGroup(groupPosition).getGroup();
        if (group != null) {
            groupViewHolder.tvTitle.setText(group.getTitle());
            groupViewHolder.ivIndicator.setImageResource(isExpanded ? this.mArrowUpResId : this.mArrowDownResId);
            if (group.getIcon() != null) {
                groupViewHolder.ivIcon.setVisibility(0);
                groupViewHolder.ivIcon.setImageDrawable(group.getIcon());
            } else {
                groupViewHolder.ivIcon.setVisibility(8);
            }
        }
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ChildViewHolder childViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.xui_layout_expand_child_item, parent, false);
            childViewHolder = new ChildViewHolder();
            childViewHolder.llContentView = (LinearLayout)convertView.findViewById(R.id.ll_content);
            childViewHolder.ivIcon = (AppCompatImageView)convertView.findViewById(R.id.iv_icon);
            childViewHolder.tvTitle = (TextView)convertView.findViewById(R.id.tv_child_name);
            if (this.mPaddingStartPx != 0) {
                int padding = ThemeUtils.resolveDimension(parent.getContext(), R.attr.xui_config_content_spacing_vertical);
                childViewHolder.llContentView.setPaddingRelative(this.mPaddingStartPx, padding, padding, padding);
                childViewHolder.llContentView.setGravity(16);
            } else {
                childViewHolder.llContentView.setGravity(17);
            }
            convertView.setTag((Object)childViewHolder);
        } else {
            childViewHolder = (ChildViewHolder)convertView.getTag();
        }
        AdapterItem child = this.getChild(groupPosition, childPosition);
        if (child != null) {
            childViewHolder.tvTitle.setText(child.getTitle());
            if (child.getIcon() != null) {
                childViewHolder.ivIcon.setVisibility(0);
                childViewHolder.ivIcon.setImageDrawable(child.getIcon());
            } else {
                childViewHolder.ivIcon.setVisibility(8);
            }
        }
        return convertView;
    }

    public int getGroupCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public int getChildrenCount(int groupPosition) {
        return this.mData != null ? this.mData.get(groupPosition).getChildSize() : 0;
    }

    public ExpandableItem getGroup(int groupPosition) {
        return this.mData != null ? this.mData.get(groupPosition) : null;
    }

    public AdapterItem getChild(int groupPosition, int childPosition) {
        return this.mData != null ? this.mData.get(groupPosition).getChildItem(childPosition) : null;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Deprecated
    public XUISimpleExpandableListAdapter setPaddingLeftPx(int paddingLeftPx) {
        this.mPaddingStartPx = paddingLeftPx;
        return this;
    }

    @Deprecated
    public XUISimpleExpandableListAdapter setPaddingLeftDp(@NonNull Context context, int paddingLeftDp) {
        this.mPaddingStartPx = DensityUtils.dp2px(context, paddingLeftDp);
        return this;
    }

    public XUISimpleExpandableListAdapter setPaddingStartPx(int paddingStartPx) {
        this.mPaddingStartPx = paddingStartPx;
        return this;
    }

    public XUISimpleExpandableListAdapter setPaddingStartDp(@NonNull Context context, int paddingStartDp) {
        this.mPaddingStartPx = DensityUtils.dp2px(context, paddingStartDp);
        return this;
    }

    public XUISimpleExpandableListAdapter setArrowStyle(int arrowDownResId, int arrowUpResId) {
        this.mArrowDownResId = arrowDownResId;
        this.mArrowUpResId = arrowUpResId;
        return this;
    }

    private static class ChildViewHolder {
        LinearLayout llContentView;
        AppCompatImageView ivIcon;
        TextView tvTitle;

        private ChildViewHolder() {
        }
    }

    private static class GroupViewHolder {
        AppCompatImageView ivIcon;
        TextView tvTitle;
        AppCompatImageView ivIndicator;

        private GroupViewHolder() {
        }
    }
}

