/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.simple;

import androidx.annotation.NonNull;
import com.xuexiang.xui.adapter.simple.AdapterItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExpandableItem {
    private AdapterItem mGroup;
    private List<AdapterItem> mChild;

    public static ExpandableItem of(@NonNull AdapterItem group) {
        return new ExpandableItem(group);
    }

    public ExpandableItem(@NonNull AdapterItem group) {
        this.mGroup = group;
        this.mChild = new ArrayList<AdapterItem>();
    }

    public ExpandableItem(@NonNull AdapterItem group, AdapterItem ... child) {
        this.mGroup = group;
        this.mChild = new ArrayList<AdapterItem>(Arrays.asList(child));
    }

    public ExpandableItem(@NonNull AdapterItem group, @NonNull List<AdapterItem> child) {
        this.mGroup = group;
        this.mChild = child;
    }

    public ExpandableItem addChild(AdapterItem child) {
        if (this.mChild == null) {
            this.mChild = new ArrayList<AdapterItem>();
        }
        this.mChild.add(child);
        return this;
    }

    public ExpandableItem addChild(int index, AdapterItem child) {
        if (this.mChild == null) {
            this.mChild = new ArrayList<AdapterItem>();
        }
        this.mChild.add(index, child);
        return this;
    }

    public ExpandableItem addChild(AdapterItem ... child) {
        if (this.mChild == null) {
            this.mChild = new ArrayList<AdapterItem>();
        }
        this.mChild.addAll(Arrays.asList(child));
        return this;
    }

    public AdapterItem getGroup() {
        return this.mGroup;
    }

    public ExpandableItem setGroup(AdapterItem group) {
        this.mGroup = group;
        return this;
    }

    public List<AdapterItem> getChild() {
        return this.mChild;
    }

    public int getChildSize() {
        return this.mChild != null ? this.mChild.size() : 0;
    }

    public AdapterItem getChildItem(int index) {
        return this.mChild != null ? this.mChild.get(index) : null;
    }

    public ExpandableItem setChild(List<AdapterItem> child) {
        this.mChild = child;
        return this;
    }
}

