/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.simple;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import com.xuexiang.xui.utils.ResUtils;

public class AdapterItem {
    private CharSequence mTitle;
    private Drawable mIcon;

    public static AdapterItem of(CharSequence title) {
        return new AdapterItem(title);
    }

    public static AdapterItem[] arrayof(CharSequence[] title) {
        AdapterItem[] array = new AdapterItem[title.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new AdapterItem(title[i]);
        }
        return array;
    }

    public AdapterItem(CharSequence title) {
        this.mTitle = title;
    }

    public AdapterItem(CharSequence title, Drawable icon) {
        this.mTitle = title;
        this.mIcon = icon;
    }

    public AdapterItem(CharSequence title, int drawableId) {
        this(title, ResUtils.getDrawable(drawableId));
    }

    public AdapterItem(Context context, int titleId, int drawableId) {
        this((CharSequence)ResUtils.getString(context, titleId), ResUtils.getDrawable(context, drawableId));
    }

    public AdapterItem(Context context, CharSequence title, int drawableId) {
        this(title, ResUtils.getDrawable(context, drawableId));
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public AdapterItem setTitle(CharSequence title) {
        this.mTitle = title;
        return this;
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public AdapterItem setIcon(Drawable icon) {
        this.mIcon = icon;
        return this;
    }

    @NonNull
    public String toString() {
        return this.mTitle.toString();
    }
}

