/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview.sticky;

import android.graphics.Canvas;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.xuexiang.xui.adapter.recyclerview.sticky.OnStickyChangedListener;
import com.xuexiang.xui.adapter.recyclerview.sticky.StickyHeadContainer;

public class StickyItemDecoration
extends RecyclerView.ItemDecoration {
    private int mStickyHeadType;
    private int mFirstVisiblePosition;
    private int mStickyHeadPosition;
    private int[] mInto;
    private RecyclerView.Adapter mAdapter;
    private StickyHeadContainer mStickyHeadContainer;
    private boolean mEnableStickyHead = true;
    private OnStickyChangedListener mOnStickyChangedListener;
    private RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            StickyItemDecoration.this.reset();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            StickyItemDecoration.this.reset();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            StickyItemDecoration.this.reset();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            StickyItemDecoration.this.reset();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            StickyItemDecoration.this.reset();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            StickyItemDecoration.this.reset();
        }
    };

    public StickyItemDecoration(@NonNull StickyHeadContainer stickyHeadContainer, int stickyHeadType) {
        this.mStickyHeadContainer = stickyHeadContainer;
        this.mStickyHeadType = stickyHeadType;
    }

    public StickyItemDecoration setOnStickyChangedListener(OnStickyChangedListener onStickyChangedListener) {
        this.mOnStickyChangedListener = onStickyChangedListener;
        return this;
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(canvas, parent, state);
        this.checkCache(parent);
        if (this.mAdapter == null || this.mStickyHeadContainer == null) {
            return;
        }
        this.calculateStickyHeadPosition(parent);
        if (this.mEnableStickyHead && this.mFirstVisiblePosition >= this.mStickyHeadPosition && this.mStickyHeadPosition != -1) {
            View belowView = parent.findChildViewUnder((float)canvas.getWidth() / 2.0f, (float)this.mStickyHeadContainer.getChildHeight() + 0.01f);
            this.mStickyHeadContainer.onPositionChanged(this.mStickyHeadPosition);
            int topOffset = belowView != null ? belowView.getTop() : 0;
            int offset = this.isStickyHead(parent, belowView) && topOffset >= 0 ? topOffset - this.mStickyHeadContainer.getChildHeight() : 0;
            if (this.mOnStickyChangedListener == null) {
                this.mStickyHeadContainer.onScrolling(offset);
            } else {
                this.mOnStickyChangedListener.onScrolling(offset);
            }
            if (!parent.canScrollVertically(1) && offset != 0) {
                if (this.mOnStickyChangedListener == null) {
                    this.mStickyHeadContainer.onNotEnoughHighScroll();
                } else {
                    this.mOnStickyChangedListener.onNotEnoughHighScroll();
                }
            }
        } else if (this.mOnStickyChangedListener == null) {
            this.mStickyHeadContainer.onInVisible();
        } else {
            this.mOnStickyChangedListener.onInVisible();
        }
    }

    public void enableStickyHead(boolean enableStickyHead) {
        this.mEnableStickyHead = enableStickyHead;
        if (!this.mEnableStickyHead) {
            this.mStickyHeadContainer.setVisibility(4);
        }
    }

    private void calculateStickyHeadPosition(RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        this.mFirstVisiblePosition = this.findFirstVisiblePosition(layoutManager);
        int stickyHeadPosition = this.findStickyHeadPosition(this.mFirstVisiblePosition);
        if (stickyHeadPosition >= 0 && this.mStickyHeadPosition != stickyHeadPosition) {
            this.mStickyHeadPosition = stickyHeadPosition;
        }
    }

    private int findStickyHeadPosition(int startPosition) {
        for (int position = startPosition; position >= 0; --position) {
            int type = this.mAdapter.getItemViewType(position);
            if (!this.isStickyHeadType(type)) continue;
            return position;
        }
        return -1;
    }

    private boolean isStickyHeadType(int type) {
        return this.mStickyHeadType == type;
    }

    private int findFirstVisiblePosition(RecyclerView.LayoutManager layoutManager) {
        int firstVisiblePosition = 0;
        if (layoutManager instanceof GridLayoutManager) {
            firstVisiblePosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
        } else if (layoutManager instanceof LinearLayoutManager) {
            firstVisiblePosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.mInto = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
            ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(this.mInto);
            firstVisiblePosition = Integer.MAX_VALUE;
            for (int pos : this.mInto) {
                firstVisiblePosition = Math.min(pos, firstVisiblePosition);
            }
        }
        return firstVisiblePosition;
    }

    private int findFirstCompletelyVisiblePosition(RecyclerView.LayoutManager layoutManager) {
        int firstVisiblePosition = 0;
        if (layoutManager instanceof GridLayoutManager) {
            firstVisiblePosition = ((GridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
        } else if (layoutManager instanceof LinearLayoutManager) {
            firstVisiblePosition = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.mInto = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
            ((StaggeredGridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPositions(this.mInto);
            firstVisiblePosition = Integer.MAX_VALUE;
            for (int pos : this.mInto) {
                firstVisiblePosition = Math.min(pos, firstVisiblePosition);
            }
        }
        return firstVisiblePosition;
    }

    private void checkCache(RecyclerView parent) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (this.mAdapter != adapter) {
            this.mAdapter = adapter;
            this.mStickyHeadPosition = -1;
            try {
                if (this.mAdapter != null) {
                    this.mAdapter.registerAdapterDataObserver(this.mAdapterDataObserver);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void reset() {
        if (this.mStickyHeadContainer != null) {
            this.mStickyHeadContainer.reset();
        }
    }

    public void recycle() {
        if (this.mStickyHeadContainer != null) {
            this.mStickyHeadContainer.recycle();
        }
        try {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterAdapterDataObserver(this.mAdapterDataObserver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mOnStickyChangedListener = null;
    }

    private boolean isStickyHead(RecyclerView parent, View view) {
        int position = parent.getChildAdapterPosition(view);
        if (position == -1) {
            return false;
        }
        int type = this.mAdapter.getItemViewType(position);
        return this.isStickyHeadType(type);
    }
}

