/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview.sticky;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewCompat;

public class StickyHeadContainer
extends ViewGroup {
    private int mOffset;
    private int mLastOffset = Integer.MIN_VALUE;
    private int mLastStickyHeadPosition = Integer.MIN_VALUE;
    private OnStickyPositionChangedListener mOnStickyPositionChangedListener;

    public StickyHeadContainer(Context context) {
        this(context, null);
    }

    public StickyHeadContainer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StickyHeadContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        if (count > 1) {
            throw new IllegalArgumentException("you must set only one child view\uff01");
        }
        View child = this.getChildAt(0);
        if (child == null) {
            return;
        }
        this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int desireWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
        int desireHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
        desireWidth += this.getPaddingLeft() + this.getPaddingRight();
        desireHeight += this.getPaddingTop() + this.getPaddingBottom();
        desireWidth = Math.max(desireWidth, this.getSuggestedMinimumWidth());
        desireHeight = Math.max(desireHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(StickyHeadContainer.resolveSize((int)desireWidth, (int)widthMeasureSpec), StickyHeadContainer.resolveSize((int)desireHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child = this.getChildAt(0);
        if (child == null) {
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int left = paddingLeft + lp.leftMargin;
        int right = child.getMeasuredWidth() + left;
        int top = paddingTop + lp.topMargin + this.mOffset;
        int bottom = child.getMeasuredHeight() + top;
        child.layout(left, top, right, bottom);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return super.generateDefaultLayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    public void onScrolling(int offset) {
        this.scrollChild(offset);
        this.setVisibility(0);
    }

    public void onInVisible() {
        this.reset();
        this.setVisibility(4);
    }

    public void scrollChild(int offset) {
        if (this.mLastOffset != offset) {
            this.mOffset = offset;
            View child = this.getChildAt(0);
            if (child != null) {
                ViewCompat.offsetTopAndBottom((View)child, (int)(this.mOffset - this.mLastOffset));
            }
        }
        this.mLastOffset = this.mOffset;
    }

    public void onNotEnoughHighScroll() {
        this.onInVisible();
    }

    protected int getChildHeight() {
        View child = this.getChildAt(0);
        return child != null ? child.getMeasuredHeight() : 0;
    }

    protected void onPositionChanged(int stickyHeadPosition) {
        if (this.mOnStickyPositionChangedListener != null && this.mLastStickyHeadPosition != stickyHeadPosition) {
            this.mOnStickyPositionChangedListener.onPositionChanged(stickyHeadPosition);
        }
        this.mLastStickyHeadPosition = stickyHeadPosition;
    }

    public void reset() {
        this.mLastStickyHeadPosition = Integer.MIN_VALUE;
    }

    public void recycle() {
        this.mLastStickyHeadPosition = Integer.MIN_VALUE;
        this.mOnStickyPositionChangedListener = null;
    }

    public int getLastStickyHeadPosition() {
        return this.mLastStickyHeadPosition;
    }

    public StickyHeadContainer setOnStickyPositionChangedListener(OnStickyPositionChangedListener onStickyPositionChangedListener) {
        this.mOnStickyPositionChangedListener = onStickyPositionChangedListener;
        return this;
    }

    public static interface OnStickyPositionChangedListener {
        public void onPositionChanged(int var1);
    }
}

