/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.xuexiang.xui.adapter.recyclerview.RecyclerViewHolder;
import com.xuexiang.xui.logs.UILog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class XRecyclerAdapter<T, V extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<V> {
    private static final String TAG = "XRecyclerAdapter";
    public static boolean DEBUG = false;
    protected final List<T> mData = new ArrayList<T>();
    private RecyclerViewHolder.OnItemClickListener<T> mClickListener;
    private RecyclerViewHolder.OnItemLongClickListener<T> mLongClickListener;
    protected int mSelectPosition = -1;

    public XRecyclerAdapter() {
    }

    public XRecyclerAdapter(Collection<T> source) {
        if (source != null) {
            this.mData.addAll(source);
        }
    }

    public XRecyclerAdapter(T[] source) {
        if (source != null && source.length > 0) {
            this.mData.addAll(Arrays.asList(source));
        }
    }

    @NonNull
    protected abstract V getViewHolder(@NonNull ViewGroup var1, int var2);

    protected abstract void bindData(@NonNull V var1, int var2, T var3);

    protected View inflateView(@NonNull ViewGroup parent, @LayoutRes int layoutId) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
    }

    @NonNull
    public V onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (DEBUG) {
            long startNanos = System.nanoTime();
            V holder = this.processCreateViewHolder(parent, viewType);
            long cost = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            UILog.dTag(TAG, "onCreateViewHolder cost:" + cost + " ms");
            return holder;
        }
        return this.processCreateViewHolder(parent, viewType);
    }

    protected V processCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        V holder = this.getViewHolder(parent, viewType);
        if (this.mClickListener != null) {
            ((RecyclerView.ViewHolder)holder).itemView.setOnClickListener(new View.OnClickListener((RecyclerView.ViewHolder)holder){
                final /* synthetic */ RecyclerView.ViewHolder val$holder;
                {
                    this.val$holder = viewHolder;
                }

                public void onClick(View v) {
                    int position = XRecyclerAdapter.this.getItemPosition(this.val$holder);
                    XRecyclerAdapter.this.mClickListener.onItemClick(this.val$holder.itemView, XRecyclerAdapter.this.getItem(position), position);
                }
            });
        }
        if (this.mLongClickListener != null) {
            ((RecyclerView.ViewHolder)holder).itemView.setOnLongClickListener(new View.OnLongClickListener((RecyclerView.ViewHolder)holder){
                final /* synthetic */ RecyclerView.ViewHolder val$holder;
                {
                    this.val$holder = viewHolder;
                }

                public boolean onLongClick(View v) {
                    int position = XRecyclerAdapter.this.getItemPosition(this.val$holder);
                    XRecyclerAdapter.this.mLongClickListener.onItemLongClick(this.val$holder.itemView, XRecyclerAdapter.this.getItem(position), position);
                    return true;
                }
            });
        }
        return holder;
    }

    protected int getItemPosition(V holder) {
        return holder.getLayoutPosition();
    }

    public void onBindViewHolder(@NonNull V holder, int position) {
        this.bindData(holder, position, this.mData.get(position));
    }

    public T getItem(int position) {
        return this.checkPosition(position) ? (T)this.mData.get(position) : null;
    }

    private boolean checkPosition(int position) {
        return position >= 0 && position < this.mData.size();
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public List<T> getData() {
        return this.mData;
    }

    public XRecyclerAdapter resetDataSource(Collection<T> collection) {
        if (collection != null) {
            this.mData.clear();
            this.mData.addAll(collection);
        }
        return this;
    }

    public XRecyclerAdapter add(int pos, T item) {
        if (pos >= 0 && pos <= this.getItemCount()) {
            this.mData.add(pos, item);
            this.notifyItemInserted(pos);
        }
        return this;
    }

    public XRecyclerAdapter add(T item) {
        this.mData.add(item);
        this.notifyItemInserted(this.mData.size() - 1);
        return this;
    }

    public XRecyclerAdapter delete(int pos) {
        if (this.checkPosition(pos)) {
            this.mData.remove(pos);
            this.notifyItemRemoved(pos);
        }
        return this;
    }

    public XRecyclerAdapter refresh(int pos, T item) {
        if (this.checkPosition(pos)) {
            this.mData.set(pos, item);
            this.notifyItemChanged(pos);
        }
        return this;
    }

    public XRecyclerAdapter refresh(Collection<T> collection) {
        if (collection != null) {
            this.mData.clear();
            this.mData.addAll(collection);
            this.mSelectPosition = -1;
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter refresh(T[] array) {
        if (array != null && array.length > 0) {
            this.mData.clear();
            this.mData.addAll(Arrays.asList(array));
            this.mSelectPosition = -1;
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter loadMore(Collection<T> collection) {
        if (collection != null) {
            this.mData.addAll(collection);
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter loadMore(T[] array) {
        if (array != null && array.length > 0) {
            this.mData.addAll(Arrays.asList(array));
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter load(T item) {
        if (item != null) {
            this.mData.add(item);
            this.notifyDataSetChanged();
        }
        return this;
    }

    public void refreshPartly(int pos, String key, Object value) {
        Bundle payload = this.getBundle(key, value);
        this.notifyItemChanged(pos, payload);
    }

    private Bundle getBundle(String key, Object value) {
        Bundle payload = new Bundle();
        if (value instanceof String) {
            payload.putString(key, (String)value);
        } else if (value instanceof Boolean) {
            payload.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            payload.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            payload.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            payload.putDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof Short) {
            payload.putDouble(key, (double)((Short)value).shortValue());
        } else if (value instanceof Long) {
            payload.putDouble(key, (double)((Long)value).longValue());
        } else if (value instanceof Parcelable) {
            payload.putParcelable(key, (Parcelable)value);
        } else if (value instanceof Serializable) {
            payload.putSerializable(key, (Serializable)value);
        } else {
            payload.putString(key, value.toString());
        }
        return payload;
    }

    public XRecyclerAdapter setOnItemClickListener(RecyclerViewHolder.OnItemClickListener<T> listener) {
        this.mClickListener = listener;
        return this;
    }

    public XRecyclerAdapter setOnItemLongClickListener(RecyclerViewHolder.OnItemLongClickListener<T> listener) {
        this.mLongClickListener = listener;
        return this;
    }

    public int getSelectPosition() {
        return this.mSelectPosition;
    }

    public XRecyclerAdapter setSelectPosition(int selectPosition) {
        this.mSelectPosition = selectPosition;
        this.notifyDataSetChanged();
        return this;
    }

    public T getSelectItem() {
        return this.getItem(this.mSelectPosition);
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.mData.clear();
            this.mSelectPosition = -1;
            this.notifyDataSetChanged();
        }
    }
}

