/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.View;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.xuexiang.xui.widget.imageview.ImageLoader;

public class RecyclerViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> mViews = new SparseArray();

    public RecyclerViewHolder(View itemView) {
        super(itemView);
    }

    public <T extends View> T findViewById(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getView(int viewId) {
        return this.findViewById(viewId);
    }

    public TextView getTextView(int viewId) {
        return (TextView)this.getView(viewId);
    }

    public Button getButton(int viewId) {
        return (Button)this.getView(viewId);
    }

    public ImageView getImageView(int viewId) {
        return (ImageView)this.getView(viewId);
    }

    public ImageButton getImageButton(int viewId) {
        return (ImageButton)this.getView(viewId);
    }

    public EditText getEditText(int viewId) {
        return (EditText)this.getView(viewId);
    }

    public final Context getContext() {
        return this.itemView.getContext();
    }

    public View findView(@IdRes int id2) {
        return id2 == 0 ? this.itemView : this.findViewById(id2);
    }

    public RecyclerViewHolder text(int id2, CharSequence sequence) {
        View view = this.findView(id2);
        if (view instanceof TextView) {
            ((TextView)view).setText(sequence);
        }
        return this;
    }

    public RecyclerViewHolder text(@IdRes int id2, @StringRes int stringRes) {
        View view = this.findView(id2);
        if (view instanceof TextView) {
            ((TextView)view).setText(stringRes);
        }
        return this;
    }

    public RecyclerViewHolder textColorId(@IdRes int id2, @ColorRes int colorId) {
        View view = this.findView(id2);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)colorId));
        }
        return this;
    }

    public RecyclerViewHolder image(@IdRes int id2, @DrawableRes int imageId) {
        View view = this.findView(id2);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(imageId);
        }
        return this;
    }

    public RecyclerViewHolder image(@IdRes int id2, Drawable drawable2) {
        View view = this.findView(id2);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable2);
        }
        return this;
    }

    public RecyclerViewHolder image(@IdRes int id2, Object uri) {
        View view = this.findView(id2);
        if (view instanceof ImageView) {
            ImageLoader.get().loadImage((ImageView)view, uri);
        }
        return this;
    }

    public RecyclerViewHolder imageLevel(@IdRes int id2, int level) {
        View view = this.findView(id2);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageLevel(level);
        }
        return this;
    }

    public RecyclerViewHolder tint(@IdRes int id2, ColorStateList tint) {
        View view = this.findView(id2);
        if (view instanceof ImageView && Build.VERSION.SDK_INT >= 21) {
            ((ImageView)view).setImageTintList(tint);
        }
        return this;
    }

    public <T> RecyclerViewHolder viewClick(@IdRes int id2, final OnViewItemClickListener<T> listener, final T item, final int position) {
        View view = this.findView(id2);
        if (listener != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onViewItemClick(v, item, position);
                }
            });
        }
        return this;
    }

    public RecyclerViewHolder click(@IdRes int id2, View.OnClickListener listener) {
        View view = this.findView(id2);
        if (listener != null) {
            view.setOnClickListener(listener);
        }
        return this;
    }

    public RecyclerViewHolder visible(@IdRes int id2, int visibility) {
        View view = this.findView(id2);
        view.setVisibility(visibility);
        return this;
    }

    public RecyclerViewHolder enable(@IdRes int id2, boolean enable) {
        View view = this.findView(id2);
        view.setEnabled(enable);
        if (view instanceof EditText) {
            view.setFocusable(enable);
            view.setFocusableInTouchMode(enable);
        }
        return this;
    }

    public RecyclerViewHolder checked(@IdRes int id2, boolean checked) {
        View view = this.findView(id2);
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(checked);
        }
        return this;
    }

    public RecyclerViewHolder checkedListener(@IdRes int id2, CompoundButton.OnCheckedChangeListener listener) {
        View view = this.findView(id2);
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setOnCheckedChangeListener(listener);
        }
        return this;
    }

    public RecyclerViewHolder select(@IdRes int id2, boolean selected) {
        View view = this.findView(id2);
        view.setSelected(selected);
        return this;
    }

    public RecyclerViewHolder textListener(@IdRes int id2, TextWatcher watcher) {
        View view = this.findView(id2);
        if (view instanceof TextView) {
            ((TextView)view).addTextChangedListener(watcher);
        }
        return this;
    }

    public RecyclerViewHolder backgroundResId(int viewId, @DrawableRes int resId) {
        View view = this.findView(viewId);
        view.setBackgroundResource(resId);
        return this;
    }

    public void clearViews() {
        if (this.mViews != null) {
            this.mViews.clear();
        }
    }

    public static interface OnViewItemClickListener<T> {
        public void onViewItemClick(View var1, T var2, int var3);
    }

    public static interface OnItemLongClickListener<T> {
        public void onItemLongClick(View var1, T var2, int var3);
    }

    public static interface OnItemClickListener<T> {
        public void onItemClick(View var1, T var2, int var3);
    }
}

