/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.xuexiang.xui.utils.DensityUtils;

public class GridDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Drawable mDivider;
    private int mSpanCount;
    private int mDividerWidth;
    private Paint mPaint;

    public GridDividerItemDecoration(Context context, int spanCount) {
        this.mSpanCount = spanCount;
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        this.mDivider = a.getDrawable(0);
        a.recycle();
        this.mDividerWidth = this.mDivider != null ? this.mDivider.getIntrinsicWidth() : DensityUtils.dp2px(context, 1.0f);
    }

    public GridDividerItemDecoration(Context context, int spanCount, int dividerWidth) {
        this(context, spanCount);
        this.mDividerWidth = dividerWidth;
    }

    public GridDividerItemDecoration(Context context, int spanCount, int dividerWidth, int dividerColor) {
        this(context, spanCount);
        this.mDividerWidth = dividerWidth;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(dividerColor);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public GridDividerItemDecoration setDivider(@NonNull Drawable divider) {
        this.mDivider = divider;
        this.mDividerWidth = this.mDivider.getIntrinsicWidth();
        return this;
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(canvas, parent, state);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int position = parent.getChildLayoutPosition(child);
            int column = (position + 1) % this.mSpanCount;
            if (column == 0) {
                column = this.mSpanCount;
            }
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin + Math.round(ViewCompat.getTranslationY((View)child));
            int bottom = top + this.mDividerWidth;
            int left = child.getRight() + params.rightMargin + Math.round(ViewCompat.getTranslationX((View)child));
            int right = left + this.mDividerWidth;
            if (this.mPaint != null) {
                canvas.drawRect((float)child.getLeft(), (float)top, (float)right, (float)bottom, this.mPaint);
            } else if (this.mDivider != null) {
                this.mDivider.setBounds(child.getLeft(), top, right, bottom);
                this.mDivider.draw(canvas);
            }
            if (column >= this.mSpanCount) continue;
            if (this.mPaint != null) {
                canvas.drawRect((float)left, (float)child.getTop(), (float)right, (float)bottom, this.mPaint);
                continue;
            }
            if (this.mDivider == null) continue;
            this.mDivider.setBounds(left, child.getTop(), right, bottom);
            this.mDivider.draw(canvas);
        }
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int position = parent.getChildLayoutPosition(view);
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter != null) {
            int itemCount = parent.getAdapter().getItemCount();
            boolean isLastRow = this.isLastRow(parent, position, this.mSpanCount, itemCount);
            int eachWidth = (this.mSpanCount - 1) * this.mDividerWidth / this.mSpanCount;
            int dl = this.mDividerWidth - eachWidth;
            int left = position % this.mSpanCount * dl;
            int right = eachWidth - left;
            if (isLastRow) {
                outRect.set(left, 0, right, 0);
            } else {
                outRect.set(left, 0, right, this.mDividerWidth);
            }
        } else if ((position + 1) % this.mSpanCount > 0) {
            outRect.set(0, 0, this.mDividerWidth, this.mDividerWidth);
        } else {
            outRect.set(0, 0, 0, this.mDividerWidth);
        }
    }

    private boolean isLastRow(RecyclerView parent, int pos, int spanCount, int childCount) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            int lines = childCount % spanCount == 0 ? childCount / spanCount : childCount / spanCount + 1;
            return lines == pos / spanCount + 1;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
            if (orientation == 1) {
                return pos >= (childCount -= childCount % spanCount);
            }
            return (pos + 1) % spanCount == 0;
        }
        return false;
    }
}

