/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.listview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class XListAdapter<T>
extends BaseAdapter {
    private final List<T> mData = new ArrayList<T>();
    private Context mContext;
    protected int mSelectPosition = -1;

    public XListAdapter(Context context) {
        this.mContext = context;
    }

    public XListAdapter(Context context, Collection<T> data) {
        this.mContext = context;
        this.setData(data);
    }

    public XListAdapter(Context context, T[] data) {
        this.mContext = context;
        this.setData(data);
    }

    public void setData(Collection<T> data) {
        if (data != null) {
            this.mData.clear();
            this.mData.addAll(data);
            this.mSelectPosition = -1;
            this.notifyDataSetChanged();
        }
    }

    public void setData(T[] data) {
        if (data != null && data.length > 0) {
            this.setData(Arrays.asList(data));
        }
    }

    public void addData(List<T> data) {
        if (data != null && !data.isEmpty()) {
            this.mData.addAll(data);
            this.notifyDataSetChanged();
        }
    }

    public void addData(T[] data) {
        this.addData((T)Arrays.asList(data));
    }

    public void addData(T data) {
        if (data != null) {
            this.mData.add(data);
            this.notifyDataSetChanged();
        }
    }

    public void removeElement(T element) {
        if (this.mData.contains(element)) {
            this.mData.remove(element);
            this.notifyDataSetChanged();
        }
    }

    public void removeElement(int position) {
        if (this.mData.size() > position) {
            this.mData.remove(position);
            this.notifyDataSetChanged();
        }
    }

    public void removeElements(List<T> elements) {
        if (elements != null && elements.size() > 0 && this.mData.size() >= elements.size()) {
            for (T element : elements) {
                if (!this.mData.contains(element)) continue;
                this.mData.remove(element);
            }
            this.notifyDataSetChanged();
        }
    }

    public void removeElements(T[] elements) {
        if (elements != null && elements.length > 0) {
            this.removeElements(Arrays.asList(elements));
        }
    }

    public void updateElement(T element, int position) {
        if (this.checkPosition(position)) {
            this.mData.set(position, element);
            this.notifyDataSetChanged();
        }
    }

    public void addElement(T element) {
        if (element != null) {
            this.mData.add(element);
            this.notifyDataSetChanged();
        }
    }

    public void clearData() {
        this.mData.clear();
        this.mSelectPosition = -1;
        this.notifyDataSetChanged();
    }

    public void clearNotNotify() {
        this.mData.clear();
        this.mSelectPosition = -1;
    }

    protected void visible(boolean flag, View view) {
        if (flag) {
            view.setVisibility(0);
        }
    }

    protected void gone(boolean flag, View view) {
        if (flag) {
            view.setVisibility(8);
        }
    }

    protected void inVisible(View view) {
        view.setVisibility(4);
    }

    protected Drawable getDrawable(int resId) {
        return this.mContext.getResources().getDrawable(resId);
    }

    protected String getString(int resId) {
        return this.mContext.getResources().getString(resId);
    }

    protected int getColor(int resId) {
        return this.mContext.getResources().getColor(resId);
    }

    public List<T> getItems() {
        return this.mData;
    }

    public int getSize() {
        return this.mData.size();
    }

    public int getCount() {
        return this.mData.size();
    }

    public T getItem(int position) {
        return this.checkPosition(position) ? (T)this.mData.get(position) : null;
    }

    private boolean checkPosition(int position) {
        return position >= 0 && position <= this.mData.size() - 1;
    }

    public long getItemId(int position) {
        return position;
    }

    public abstract View getView(int var1, View var2, ViewGroup var3);

    public Context getContext() {
        return this.mContext;
    }

    public int getSelectPosition() {
        return this.mSelectPosition;
    }

    public XListAdapter setSelectPosition(int selectPosition) {
        this.mSelectPosition = selectPosition;
        this.notifyDataSetChanged();
        return this;
    }

    public T getSelectItem() {
        return this.getItem(this.mSelectPosition);
    }
}

