/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.ViewUtils;
import io.github.inflationx.calligraphy3.CalligraphyConfig;
import io.github.inflationx.calligraphy3.CalligraphyInterceptor;
import io.github.inflationx.calligraphy3.TypefaceUtils;
import io.github.inflationx.viewpump.Interceptor;
import io.github.inflationx.viewpump.ViewPump;

public class XUI {
    private static Application sContext;
    private static boolean sIsTabletChecked;
    private static int sScreenType;
    private static String sDefaultFontAssetPath;

    public static void init(Application context) {
        sContext = context;
    }

    public static void initFontStyle(String defaultFontAssetPath) {
        if (!TextUtils.isEmpty((CharSequence)defaultFontAssetPath)) {
            sDefaultFontAssetPath = defaultFontAssetPath;
            ViewPump.init((ViewPump)ViewPump.builder().addInterceptor((Interceptor)new CalligraphyInterceptor(new CalligraphyConfig.Builder().setDefaultFontPath(defaultFontAssetPath).setFontAttrId(R.attr.fontPath).build())).build());
        }
    }

    public static Context getContext() {
        XUI.testInitialize();
        return sContext;
    }

    private static void testInitialize() {
        if (sContext == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 XUI.init() \u521d\u59cb\u5316\uff01");
        }
    }

    public static void debug(String tag) {
        UILog.debug(tag);
    }

    public static void debug(boolean isDebug) {
        UILog.debug(isDebug);
    }

    public static void setViewsFont(View ... views) {
        ViewUtils.setViewsFont(views);
    }

    @Nullable
    public static Typeface getDefaultTypeface() {
        if (!TextUtils.isEmpty((CharSequence)sDefaultFontAssetPath)) {
            return TypefaceUtils.load((AssetManager)XUI.getContext().getAssets(), (String)sDefaultFontAssetPath);
        }
        return null;
    }

    public static String getDefaultFontAssetPath() {
        return sDefaultFontAssetPath;
    }

    @Nullable
    public static Typeface getDefaultTypeface(String fontPath) {
        if (TextUtils.isEmpty((CharSequence)fontPath)) {
            fontPath = sDefaultFontAssetPath;
        }
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load((AssetManager)XUI.getContext().getAssets(), (String)fontPath);
        }
        return null;
    }

    private static int checkScreenSize(Context context) {
        int screenSize = context.getResources().getConfiguration().screenLayout & 0xF;
        if (screenSize >= 3) {
            if (screenSize >= 4) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static int getScreenType() {
        if (sIsTabletChecked) {
            return sScreenType;
        }
        sScreenType = XUI.checkScreenSize(XUI.getContext());
        sIsTabletChecked = true;
        return sScreenType;
    }

    public static boolean isTablet() {
        return XUI.getScreenType() == 2 || XUI.getScreenType() == 3;
    }

    public static void initTheme(Activity activity) {
        int screenType = XUI.getScreenType();
        if (screenType == 1) {
            activity.setTheme(R.style.XUITheme_Phone);
        } else if (screenType == 2) {
            activity.setTheme(R.style.XUITheme_Tablet_Small);
        } else {
            activity.setTheme(R.style.XUITheme_Tablet_Big);
        }
    }

    @ColorInt
    public static int getMainThemeColor(Context context) {
        return ThemeUtils.getMainThemeColor(context);
    }
}

