/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.supertextview;

import android.content.Context;
import android.graphics.Typeface;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import uk.co.chrisjenx.calligraphy.HasTypeface;

public class BaseTextView
extends LinearLayout
implements HasTypeface {
    private Context mContext;
    private TextView mTopTextView;
    private TextView mCenterTextView;
    private TextView mBottomTextView;
    private LinearLayout.LayoutParams mTopTVParams;
    private LinearLayout.LayoutParams mCenterTVParams;
    private LinearLayout.LayoutParams mBottomTVParams;

    public BaseTextView(Context context) {
        super(context);
        this.init(context);
    }

    public BaseTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BaseTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setOrientation(1);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.initTopView();
        this.initCenterView();
        this.initBottomView();
    }

    private void initTopView() {
        if (this.mTopTVParams == null) {
            this.mTopTVParams = this.getParams(this.mTopTVParams);
        }
        if (this.mTopTextView == null) {
            this.mTopTextView = this.initTextView(this.mTopTVParams, this.mTopTextView);
        }
    }

    private void initCenterView() {
        if (this.mCenterTVParams == null) {
            this.mCenterTVParams = this.getParams(this.mCenterTVParams);
        }
        if (this.mCenterTextView == null) {
            this.mCenterTextView = this.initTextView(this.mCenterTVParams, this.mCenterTextView);
        }
    }

    private void initBottomView() {
        if (this.mBottomTVParams == null) {
            this.mBottomTVParams = this.getParams(this.mBottomTVParams);
        }
        if (this.mBottomTextView == null) {
            this.mBottomTextView = this.initTextView(this.mBottomTVParams, this.mBottomTextView);
        }
    }

    private TextView initTextView(LinearLayout.LayoutParams params, TextView textView) {
        textView = this.getTextView(textView, params);
        textView.setGravity(17);
        this.addView((View)textView);
        return textView;
    }

    public TextView getTextView(TextView textView, LinearLayout.LayoutParams layoutParams) {
        if (textView == null) {
            textView = new TextView(this.mContext);
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setVisibility(8);
        }
        return textView;
    }

    public LinearLayout.LayoutParams getParams(LinearLayout.LayoutParams params) {
        if (params == null) {
            params = new LinearLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    private void setTextString(TextView textView, CharSequence textString) {
        textView.setText(textString);
        if (!TextUtils.isEmpty((CharSequence)textString)) {
            textView.setVisibility(0);
        }
    }

    public void setTopTextString(CharSequence s) {
        this.setTextString(this.mTopTextView, s);
    }

    public void setCenterTextString(CharSequence s) {
        this.setTextString(this.mCenterTextView, s);
    }

    public void setBottomTextString(CharSequence s) {
        this.setTextString(this.mBottomTextView, s);
    }

    public TextView getTopTextView() {
        return this.mTopTextView;
    }

    public TextView getCenterTextView() {
        return this.mCenterTextView;
    }

    public TextView getBottomTextView() {
        return this.mBottomTextView;
    }

    public void setMaxEms(int topMaxEms, int centerMaxEms, int bottomMaxEms) {
        this.mTopTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mCenterTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mBottomTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTopTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(topMaxEms)});
        this.mCenterTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(centerMaxEms)});
        this.mBottomTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(bottomMaxEms)});
    }

    public void setCenterSpaceHeight(int centerSpaceHeight) {
        this.mTopTVParams.setMargins(0, 0, 0, centerSpaceHeight / 2);
        this.mCenterTVParams.setMargins(0, centerSpaceHeight / 2, 0, centerSpaceHeight / 2);
        this.mBottomTVParams.setMargins(0, centerSpaceHeight / 2, 0, 0);
    }

    public void setTypeface(Typeface typeface) {
        if (this.mTopTextView != null) {
            this.mTopTextView.setTypeface(typeface);
        }
        if (this.mCenterTextView != null) {
            this.mCenterTextView.setTypeface(typeface);
        }
        if (this.mBottomTextView != null) {
            this.mBottomTextView.setTypeface(typeface);
        }
    }
}

