/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.xuexiang.xui.widget.textview.span.AlignMiddleImageSpan;

public class MarginImageSpan
extends AlignMiddleImageSpan {
    private int mSpanMarginLeft = 0;
    private int mSpanMarginRight = 0;
    private int mOffsetY = 0;

    public MarginImageSpan(Drawable d, int verticalAlignment, int marginLeft, int marginRight) {
        super(d, verticalAlignment);
        this.mSpanMarginLeft = marginLeft;
        this.mSpanMarginRight = marginRight;
    }

    public MarginImageSpan(Drawable d, int verticalAlignment, int marginLeft, int marginRight, int offsetY) {
        this(d, verticalAlignment, marginLeft, marginRight);
        this.mOffsetY = offsetY;
    }

    @Override
    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (this.mSpanMarginLeft != 0 || this.mSpanMarginRight != 0) {
            super.getSize(paint, text, start, end, fm);
            Drawable d = this.getDrawable();
            return d.getIntrinsicWidth() + this.mSpanMarginLeft + this.mSpanMarginRight;
        }
        return super.getSize(paint, text, start, end, fm);
    }

    @Override
    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        canvas.save();
        canvas.translate(0.0f, (float)this.mOffsetY);
        super.draw(canvas, text, start, end, x + (float)this.mSpanMarginLeft, top, y, bottom, paint);
        canvas.restore();
    }
}

