/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.label;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.Utils;

public final class LabelViewHelper {
    private static final int LEFT_TOP = 1;
    private static final int RIGHT_TOP = 2;
    private static final int LEFT_BOTTOM = 3;
    private static final int RIGHT_BOTTOM = 4;
    private static final int DEFAULT_DISTANCE = 40;
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_STROKE_COLOR = 0;
    private static final int DEFAULT_STROKE_WIDTH = 1;
    private static final int DEFAULT_TEXT_SIZE = 14;
    private static final int DEFAULT_BACKGROUND_COLOR = -1624781376;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_ORIENTATION = 1;
    private static final int DEFAULT_TEXT_STYLE = 0;
    private Context mContext;
    private int mAlpha;
    private int mDistance;
    private int mHeight;
    private int mBackgroundColor;
    private int mStrokeWidth;
    private int mStrokeColor;
    private String mText;
    private int mTextSize;
    private int mTextStyle;
    private String mTextFont;
    private int mTextColor;
    private boolean mVisual;
    private int mOrientation;
    private Paint mRectPaint;
    private Paint mRectStrokePaint;
    private Path mRectPath;
    private Path mTextPath;
    private Paint mTextPaint;
    private Rect mTextBound;

    public LabelViewHelper(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mContext = context;
        this.initAttrs(context, attrs, defStyleAttr);
        this.initPaints();
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.LabelView, defStyleAttr, 0);
        this.mDistance = array.getDimensionPixelSize(R.styleable.LabelView_label_distance, this.dip2Px(40.0f));
        this.mHeight = array.getDimensionPixelSize(R.styleable.LabelView_label_height, this.dip2Px(20.0f));
        this.mBackgroundColor = array.getColor(R.styleable.LabelView_label_backgroundColor, -1624781376);
        this.mStrokeWidth = array.getDimensionPixelSize(R.styleable.LabelView_label_strokeWidth, this.dip2Px(1.0f));
        this.mStrokeColor = array.getColor(R.styleable.LabelView_label_strokeColor, 0);
        this.mText = array.getString(R.styleable.LabelView_label_text);
        this.mTextSize = array.getDimensionPixelSize(R.styleable.LabelView_label_textSize, this.dip2Px(14.0f));
        this.mTextStyle = array.getInt(R.styleable.LabelView_label_textStyle, 0);
        this.mTextFont = array.getString(R.styleable.LabelView_label_textFont);
        this.mTextColor = array.getColor(R.styleable.LabelView_label_textColor, -1);
        this.mVisual = array.getBoolean(R.styleable.LabelView_label_visual, true);
        this.mOrientation = array.getInteger(R.styleable.LabelView_label_orientation, 1);
        array.recycle();
    }

    private void initPaints() {
        this.mRectPaint = new Paint();
        this.mRectPaint.setDither(true);
        this.mRectPaint.setAntiAlias(true);
        this.mRectPaint.setStyle(Paint.Style.FILL);
        this.mRectStrokePaint = new Paint();
        this.mRectStrokePaint.setDither(true);
        this.mRectStrokePaint.setAntiAlias(true);
        this.mRectStrokePaint.setStyle(Paint.Style.STROKE);
        this.mRectPath = new Path();
        this.mRectPath.reset();
        this.mTextPath = new Path();
        this.mTextPath.reset();
        this.mTextPaint = new Paint();
        this.mTextPaint.setDither(true);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mTextPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mTextBound = new Rect();
    }

    public void onDraw(Canvas canvas, int measuredWidth, int measuredHeight) {
        if (!this.mVisual || this.mText == null) {
            return;
        }
        float actualDistance = this.mDistance + this.mHeight / 2;
        this.calcOffset(measuredWidth, measuredHeight);
        this.mRectPaint.setColor(this.mBackgroundColor);
        if (this.mAlpha != 0) {
            this.mRectPaint.setAlpha(this.mAlpha);
        }
        this.mRectStrokePaint.setColor(this.mStrokeColor);
        this.mRectStrokePaint.setStrokeWidth((float)this.mStrokeWidth);
        canvas.drawPath(this.mRectPath, this.mRectPaint);
        canvas.drawPath(this.mRectPath, this.mRectStrokePaint);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBound);
        if (Utils.isNullOrEmpty(this.mTextFont)) {
            this.mTextPaint.setTypeface(Typeface.defaultFromStyle((int)this.mTextStyle));
        } else {
            this.mTextPaint.setTypeface(XUI.getDefaultTypeface(this.mTextFont));
        }
        float begin_w_offset = 1.4142135f * actualDistance / 2.0f - (float)(this.mTextBound.width() / 2);
        if (begin_w_offset < 0.0f) {
            begin_w_offset = 0.0f;
        }
        canvas.drawTextOnPath(this.mText, this.mTextPath, begin_w_offset, (float)(this.mTextBound.height() / 2), this.mTextPaint);
    }

    private void calcOffset(int measuredWidth, int measuredHeight) {
        float startPosX = measuredWidth - this.mDistance - this.mHeight;
        float endPosX = measuredWidth;
        float startPosY = measuredHeight - this.mDistance - this.mHeight;
        float endPosY = measuredHeight;
        float middle = this.mHeight / 2;
        switch (this.mOrientation) {
            case 1: {
                this.mRectPath.reset();
                this.mRectPath.moveTo(0.0f, (float)this.mDistance);
                this.mRectPath.lineTo((float)this.mDistance, 0.0f);
                this.mRectPath.lineTo((float)(this.mDistance + this.mHeight), 0.0f);
                this.mRectPath.lineTo(0.0f, (float)(this.mDistance + this.mHeight));
                this.mRectPath.close();
                this.mTextPath.reset();
                this.mTextPath.moveTo(0.0f, (float)this.mDistance + middle);
                this.mTextPath.lineTo((float)this.mDistance + middle, 0.0f);
                this.mTextPath.close();
                break;
            }
            case 2: {
                this.mRectPath.reset();
                this.mRectPath.moveTo(startPosX, 0.0f);
                this.mRectPath.lineTo(startPosX + (float)this.mHeight, 0.0f);
                this.mRectPath.lineTo(endPosX, (float)this.mDistance);
                this.mRectPath.lineTo(endPosX, (float)(this.mDistance + this.mHeight));
                this.mRectPath.close();
                this.mTextPath.reset();
                this.mTextPath.moveTo(startPosX + middle, 0.0f);
                this.mTextPath.lineTo(endPosX, (float)this.mDistance + middle);
                this.mTextPath.close();
                break;
            }
            case 3: {
                this.mRectPath.reset();
                this.mRectPath.moveTo(0.0f, startPosY);
                this.mRectPath.lineTo((float)(this.mDistance + this.mHeight), endPosY);
                this.mRectPath.lineTo((float)this.mDistance, endPosY);
                this.mRectPath.lineTo(0.0f, startPosY + (float)this.mHeight);
                this.mRectPath.close();
                this.mTextPath.reset();
                this.mTextPath.moveTo(0.0f, startPosY + middle);
                this.mTextPath.lineTo((float)this.mDistance + middle, endPosY);
                this.mTextPath.close();
                break;
            }
            case 4: {
                this.mRectPath.reset();
                this.mRectPath.moveTo(startPosX, endPosY);
                this.mRectPath.lineTo((float)measuredWidth, startPosY);
                this.mRectPath.lineTo((float)measuredWidth, startPosY + (float)this.mHeight);
                this.mRectPath.lineTo(startPosX + (float)this.mHeight, endPosY);
                this.mRectPath.close();
                this.mTextPath.reset();
                this.mTextPath.moveTo(startPosX + middle, endPosY);
                this.mTextPath.lineTo(endPosX, startPosY + middle);
                this.mTextPath.close();
            }
        }
    }

    private int dip2Px(float dip) {
        return (int)(dip * this.mContext.getResources().getDisplayMetrics().density + 0.5f);
    }

    private int px2Dip(float px) {
        return (int)(px / this.mContext.getResources().getDisplayMetrics().density + 0.5f);
    }

    public void setLabelHeight(View view, int height) {
        if (this.mHeight != this.dip2Px(height)) {
            this.mHeight = this.dip2Px(height);
            view.invalidate();
        }
    }

    public int getLabelHeight() {
        return this.px2Dip(this.mHeight);
    }

    public void setLabelDistance(View view, int distance) {
        if (this.mDistance != this.dip2Px(distance)) {
            this.mDistance = this.dip2Px(distance);
            view.invalidate();
        }
    }

    public int getLabelStrokeWidth() {
        return this.px2Dip(this.mStrokeWidth);
    }

    public void setLabelStrokeWidth(View view, int strokeWidth) {
        if (this.mStrokeWidth != this.dip2Px(strokeWidth)) {
            this.mStrokeWidth = this.dip2Px(strokeWidth);
            view.invalidate();
        }
    }

    public int getLabelDistance() {
        return this.px2Dip(this.mDistance);
    }

    public boolean isLabelVisual() {
        return this.mVisual;
    }

    public void setLabelVisual(View view, boolean visual) {
        if (this.mVisual != visual) {
            this.mVisual = visual;
            view.invalidate();
        }
    }

    public int getLabelOrientation() {
        return this.mOrientation;
    }

    public void setLabelOrientation(View view, int orientation) {
        if (this.mOrientation != orientation && orientation <= 4 && orientation >= 1) {
            this.mOrientation = orientation;
            view.invalidate();
        }
    }

    public int getLabelTextColor() {
        return this.mTextColor;
    }

    public void setLabelTextColor(View view, int textColor) {
        if (this.mTextColor != textColor) {
            this.mTextColor = textColor;
            view.invalidate();
        }
    }

    public int getLabelBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setLabelBackgroundColor(View view, int backgroundColor) {
        if (this.mBackgroundColor != backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            view.invalidate();
        }
    }

    public int getLabelStrokeColor() {
        return this.mStrokeColor;
    }

    public void setLabelStrokeColor(View view, int strokeColor) {
        if (this.mStrokeColor != strokeColor) {
            this.mStrokeColor = strokeColor;
            view.invalidate();
        }
    }

    public void setLabelBackgroundAlpha(View view, int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            view.invalidate();
        }
    }

    public String getLabelText() {
        return this.mText;
    }

    public void setLabelText(View view, String text) {
        if (this.mText == null || !this.mText.equals(text)) {
            this.mText = text;
            view.invalidate();
        }
    }

    public int getLabelTextSize() {
        return this.px2Dip(this.mTextSize);
    }

    public void setLabelTextSize(View view, int textSize) {
        if (this.mTextSize != textSize) {
            this.mTextSize = textSize;
            view.invalidate();
        }
    }

    public int getLabelTextStyle() {
        return this.mTextStyle;
    }

    public void setLabelTextStyle(View view, int textStyle) {
        if (this.mTextStyle == textStyle) {
            return;
        }
        this.mTextStyle = textStyle;
        view.invalidate();
    }

    public void setLabelTextFont(View view, String textFont) {
        this.mTextFont = textFont;
        view.invalidate();
    }

    public String getLabelTextFont() {
        return this.mTextFont;
    }
}

