/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.autofit;

import android.content.Context;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.widget.TextView;
import com.xuexiang.xui.widget.textview.autofit.AutoFitHelper;

public class AutoFitTextView
extends AppCompatTextView
implements AutoFitHelper.OnTextSizeChangeListener {
    private AutoFitHelper mHelper;

    public AutoFitTextView(Context context) {
        this(context, null);
    }

    public AutoFitTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public AutoFitTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.mHelper = AutoFitHelper.create((TextView)this, attrs, defStyle).addOnTextSizeChangeListener(this);
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        if (this.mHelper != null) {
            this.mHelper.setTextSize(unit, size);
        }
    }

    public void setLines(int lines) {
        super.setLines(lines);
        if (this.mHelper != null) {
            this.mHelper.setMaxLines(lines);
        }
    }

    public void setMaxLines(int maxLines) {
        super.setMaxLines(maxLines);
        if (this.mHelper != null) {
            this.mHelper.setMaxLines(maxLines);
        }
    }

    public AutoFitHelper getAutofitHelper() {
        return this.mHelper;
    }

    public boolean isEnableFit() {
        return this.mHelper.isEnabled();
    }

    public void enableFit() {
        this.setEnableFit(true);
    }

    public void setEnableFit(boolean enableFit) {
        this.mHelper.setEnabled(enableFit);
    }

    public float getMaxTextSize() {
        return this.mHelper.getMaxTextSize();
    }

    public void setMaxTextSize(float size) {
        this.mHelper.setMaxTextSize(size);
    }

    public void setMaxTextSize(int unit, float size) {
        this.mHelper.setMaxTextSize(unit, size);
    }

    public float getMinTextSize() {
        return this.mHelper.getMinTextSize();
    }

    public void setMinTextSize(int minSize) {
        this.mHelper.setMinTextSize(2, minSize);
    }

    public void setMinTextSize(int unit, float minSize) {
        this.mHelper.setMinTextSize(unit, minSize);
    }

    public float getPrecision() {
        return this.mHelper.getPrecision();
    }

    public void setPrecision(float precision) {
        this.mHelper.setPrecision(precision);
    }

    @Override
    public void onTextSizeChange(float textSize, float oldTextSize) {
    }
}

