/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.autofit;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.textview.autofit.AutoFitHelper;
import java.util.WeakHashMap;

public class AutoFitLayout
extends FrameLayout {
    private boolean mEnabled;
    private float mMinTextSize;
    private float mPrecision;
    private WeakHashMap<View, AutoFitHelper> mHelpers = new WeakHashMap();

    public AutoFitLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public AutoFitLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public AutoFitLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        boolean enableFit = true;
        int minTextSize = -1;
        float precision = -1.0f;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AutoFitTextView, defStyle, 0);
            enableFit = ta.getBoolean(R.styleable.AutoFitTextView_aftv_enable, enableFit);
            minTextSize = ta.getDimensionPixelSize(R.styleable.AutoFitTextView_aftv_minTextSize, minTextSize);
            precision = ta.getFloat(R.styleable.AutoFitTextView_aftv_precision, precision);
            ta.recycle();
        }
        this.mEnabled = enableFit;
        this.mMinTextSize = minTextSize;
        this.mPrecision = precision;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (child instanceof TextView) {
            TextView textView = (TextView)child;
            AutoFitHelper helper = AutoFitHelper.create(textView).setEnabled(this.mEnabled);
            if (this.mPrecision > 0.0f) {
                helper.setPrecision(this.mPrecision);
            }
            if (this.mMinTextSize > 0.0f) {
                helper.setMinTextSize(0, this.mMinTextSize);
            }
            this.mHelpers.put((View)textView, helper);
        }
    }

    public AutoFitHelper getAutofitHelper(TextView textView) {
        return this.mHelpers.get(textView);
    }

    public AutoFitHelper getAutofitHelper(int index) {
        return this.mHelpers.get(this.getChildAt(index));
    }
}

