/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar.vertical;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Px;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.widget.tabbar.vertical.ITabView;
import com.xuexiang.xui.widget.tabbar.vertical.TabBadgeView;
import com.xuexiang.xui.widget.tabbar.vertical.TabView;
import com.xuexiang.xui.widget.textview.badge.Badge;

public class XTabView
extends TabView {
    private Context mContext;
    private TextView mTitle;
    private Badge mBadgeView;
    private ITabView.TabIcon mTabIcon;
    private ITabView.TabTitle mTabTitle;
    private ITabView.TabBadge mTabBadge;
    private boolean mChecked;
    private Drawable mDefaultBackground;

    public XTabView(Context context) {
        super(context);
        this.mContext = context;
        this.mTabIcon = new ITabView.TabIcon.Builder().build();
        this.mTabTitle = new ITabView.TabTitle.Builder().build();
        this.mTabBadge = new ITabView.TabBadge.Builder().build();
        this.initView();
        int[] attrs = Build.VERSION.SDK_INT >= 21 ? new int[]{16843868} : new int[]{16843534};
        TypedArray a = this.mContext.getTheme().obtainStyledAttributes(attrs);
        this.mDefaultBackground = a.getDrawable(0);
        a.recycle();
        this.setDefaultBackground();
    }

    private void initView() {
        this.setMinimumHeight(DensityUtils.dp2px(this.mContext, 25.0f));
        if (this.mTitle == null) {
            this.mTitle = new TextView(this.mContext);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -1);
            params.gravity = 17;
            this.mTitle.setLayoutParams((ViewGroup.LayoutParams)params);
            this.addView((View)this.mTitle);
        }
        this.initTitleView();
        this.initIconView();
        this.initBadge();
    }

    @RequiresApi(api=16)
    public void setPaddingRelative(@Px int start, @Px int top, @Px int end, @Px int bottom) {
        this.mTitle.setPaddingRelative(start, top, end, bottom);
    }

    public void setPadding(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        this.mTitle.setPadding(left, top, right, bottom);
    }

    private void initBadge() {
        this.mBadgeView = TabBadgeView.bindTab(this);
        if (this.mTabBadge.getBackgroundColor() != -1552832) {
            this.mBadgeView.setBadgeBackgroundColor(this.mTabBadge.getBackgroundColor());
        }
        if (this.mTabBadge.getBadgeTextColor() != -1) {
            this.mBadgeView.setBadgeTextColor(this.mTabBadge.getBadgeTextColor());
        }
        if (this.mTabBadge.getStrokeColor() != 0 || this.mTabBadge.getStrokeWidth() != 0.0f) {
            this.mBadgeView.stroke(this.mTabBadge.getStrokeColor(), this.mTabBadge.getStrokeWidth(), true);
        }
        if (this.mTabBadge.getDrawableBackground() != null || this.mTabBadge.isDrawableBackgroundClip()) {
            this.mBadgeView.setBadgeBackground(this.mTabBadge.getDrawableBackground(), this.mTabBadge.isDrawableBackgroundClip());
        }
        if (this.mTabBadge.getBadgeTextSize() != 11.0f) {
            this.mBadgeView.setBadgeTextSize(this.mTabBadge.getBadgeTextSize(), true);
        }
        if (this.mTabBadge.getBadgePadding() != 5.0f) {
            this.mBadgeView.setBadgePadding(this.mTabBadge.getBadgePadding(), true);
        }
        if (this.mTabBadge.getBadgeNumber() != 0) {
            this.mBadgeView.setBadgeNumber(this.mTabBadge.getBadgeNumber());
        }
        if (this.mTabBadge.getBadgeText() != null) {
            this.mBadgeView.setBadgeText(this.mTabBadge.getBadgeText());
        }
        if (this.mTabBadge.getBadgeGravity() != 8388661) {
            this.mBadgeView.setBadgeGravity(this.mTabBadge.getBadgeGravity());
        }
        if (this.mTabBadge.getGravityOffsetX() != 1 || this.mTabBadge.getGravityOffsetY() != 1) {
            this.mBadgeView.setGravityOffset(this.mTabBadge.getGravityOffsetX(), this.mTabBadge.getGravityOffsetY(), true);
        }
        if (this.mTabBadge.isExactMode()) {
            this.mBadgeView.setExactMode(this.mTabBadge.isExactMode());
        }
        if (!this.mTabBadge.isShowShadow()) {
            this.mBadgeView.setShowShadow(this.mTabBadge.isShowShadow());
        }
        if (this.mTabBadge.getOnDragStateChangedListener() != null) {
            this.mBadgeView.setOnDragStateChangedListener(this.mTabBadge.getOnDragStateChangedListener());
        }
    }

    private void initTitleView() {
        this.mTitle.setTextColor(this.isChecked() ? this.mTabTitle.getColorSelected() : this.mTabTitle.getColorNormal());
        this.mTitle.setTextSize((float)this.mTabTitle.getTitleTextSize());
        this.mTitle.setText((CharSequence)this.mTabTitle.getContent());
        this.mTitle.setGravity(17);
        this.mTitle.setEllipsize(TextUtils.TruncateAt.END);
        this.mTitle.setTypeface(XUI.getDefaultTypeface());
        this.refreshDrawablePadding();
    }

    private void initIconView() {
        int iconResid = this.mChecked ? this.mTabIcon.getSelectedIcon() : this.mTabIcon.getNormalIcon();
        Drawable drawable2 = null;
        if (iconResid != 0) {
            drawable2 = this.mContext.getResources().getDrawable(iconResid);
            int r = this.mTabIcon.getIconWidth() != -1 ? this.mTabIcon.getIconWidth() : drawable2.getIntrinsicWidth();
            int b = this.mTabIcon.getIconHeight() != -1 ? this.mTabIcon.getIconHeight() : drawable2.getIntrinsicHeight();
            drawable2.setBounds(0, 0, r, b);
        }
        switch (this.mTabIcon.getIconGravity()) {
            case 0x800003: {
                this.mTitle.setCompoundDrawables(drawable2, null, null, null);
                break;
            }
            case 48: {
                this.mTitle.setCompoundDrawables(null, drawable2, null, null);
                break;
            }
            case 0x800005: {
                this.mTitle.setCompoundDrawables(null, null, drawable2, null);
                break;
            }
            case 80: {
                this.mTitle.setCompoundDrawables(null, null, null, drawable2);
            }
        }
        this.refreshDrawablePadding();
    }

    private void refreshDrawablePadding() {
        int iconResid;
        int n = iconResid = this.mChecked ? this.mTabIcon.getSelectedIcon() : this.mTabIcon.getNormalIcon();
        if (iconResid != 0) {
            if (!TextUtils.isEmpty((CharSequence)this.mTabTitle.getContent()) && this.mTitle.getCompoundDrawablePadding() != this.mTabIcon.getMargin()) {
                this.mTitle.setCompoundDrawablePadding(this.mTabIcon.getMargin());
            } else if (TextUtils.isEmpty((CharSequence)this.mTabTitle.getContent())) {
                this.mTitle.setCompoundDrawablePadding(0);
            }
        } else {
            this.mTitle.setCompoundDrawablePadding(0);
        }
    }

    @Override
    public XTabView setBadge(ITabView.TabBadge badge) {
        if (badge != null) {
            this.mTabBadge = badge;
        }
        this.initBadge();
        return this;
    }

    @Override
    public XTabView setIcon(ITabView.TabIcon icon) {
        if (icon != null) {
            this.mTabIcon = icon;
        }
        this.initIconView();
        return this;
    }

    @Override
    public XTabView setTitle(ITabView.TabTitle title) {
        if (title != null) {
            this.mTabTitle = title;
        }
        this.initTitleView();
        return this;
    }

    @Override
    public XTabView setBackground(int resId) {
        if (resId == 0) {
            this.setDefaultBackground();
        } else if (resId <= 0) {
            this.setBackground(null);
        } else {
            super.setBackgroundResource(resId);
        }
        return this;
    }

    @Override
    public ITabView.TabBadge getBadge() {
        return this.mTabBadge;
    }

    @Override
    public ITabView.TabIcon getIcon() {
        return this.mTabIcon;
    }

    @Override
    public ITabView.TabTitle getTitle() {
        return this.mTabTitle;
    }

    @Override
    @Deprecated
    public ImageView getIconView() {
        return null;
    }

    @Override
    public TextView getTitleView() {
        return this.mTitle;
    }

    @Override
    public Badge getBadgeView() {
        return this.mBadgeView;
    }

    public void setBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.setBackground(background);
        } else {
            super.setBackgroundDrawable(background);
        }
    }

    public void setBackgroundResource(int resid) {
        this.setBackground(resid);
    }

    private void setDefaultBackground() {
        if (this.getBackground() != this.mDefaultBackground) {
            this.setBackground(this.mDefaultBackground);
        }
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.setSelected(checked);
        this.refreshDrawableState();
        this.mTitle.setTextColor(checked ? this.mTabTitle.getColorSelected() : this.mTabTitle.getColorNormal());
        this.initIconView();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }
}

