/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar.vertical;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.xuexiang.xui.widget.textview.badge.Badge;

public interface ITabView {
    public ITabView setBadge(TabBadge var1);

    public ITabView setIcon(TabIcon var1);

    public ITabView setTitle(TabTitle var1);

    public ITabView setBackground(int var1);

    public TabBadge getBadge();

    public TabIcon getIcon();

    public TabTitle getTitle();

    public View getTabView();

    public static class TabBadge {
        private Builder mBuilder;

        private TabBadge(Builder mBuilder) {
            this.mBuilder = mBuilder;
        }

        public int getBackgroundColor() {
            return this.mBuilder.colorBackground;
        }

        public int getBadgeTextColor() {
            return this.mBuilder.colorBadgeText;
        }

        public float getBadgeTextSize() {
            return this.mBuilder.badgeTextSize;
        }

        public float getBadgePadding() {
            return this.mBuilder.badgePadding;
        }

        public int getBadgeNumber() {
            return this.mBuilder.badgeNumber;
        }

        public String getBadgeText() {
            return this.mBuilder.badgeText;
        }

        public int getBadgeGravity() {
            return this.mBuilder.badgeGravity;
        }

        public int getGravityOffsetX() {
            return this.mBuilder.gravityOffsetX;
        }

        public int getGravityOffsetY() {
            return this.mBuilder.gravityOffsetY;
        }

        public boolean isExactMode() {
            return this.mBuilder.exactMode;
        }

        public boolean isShowShadow() {
            return this.mBuilder.showShadow;
        }

        public Drawable getDrawableBackground() {
            return this.mBuilder.drawableBackground;
        }

        public int getStrokeColor() {
            return this.mBuilder.colorStroke;
        }

        public boolean isDrawableBackgroundClip() {
            return this.mBuilder.drawableBackgroundClip;
        }

        public float getStrokeWidth() {
            return this.mBuilder.strokeWidth;
        }

        public Badge.OnDragStateChangedListener getOnDragStateChangedListener() {
            return this.mBuilder.dragStateChangedListener;
        }

        public static class Builder {
            private int colorBackground = -1552832;
            private int colorBadgeText = -1;
            private int colorStroke = 0;
            private Drawable drawableBackground = null;
            private boolean drawableBackgroundClip = false;
            private float strokeWidth = 0.0f;
            private float badgeTextSize = 11.0f;
            private float badgePadding = 5.0f;
            private int badgeNumber = 0;
            private String badgeText = null;
            private int badgeGravity = 8388661;
            private int gravityOffsetX = 1;
            private int gravityOffsetY = 1;
            private boolean exactMode = false;
            private boolean showShadow = true;
            private Badge.OnDragStateChangedListener dragStateChangedListener;

            public TabBadge build() {
                return new TabBadge(this);
            }

            public Builder stroke(int color2, int strokeWidth) {
                this.colorStroke = color2;
                this.strokeWidth = strokeWidth;
                return this;
            }

            public Builder setDrawableBackground(Drawable drawableBackground, boolean clip) {
                this.drawableBackground = drawableBackground;
                this.drawableBackgroundClip = clip;
                return this;
            }

            public Builder setShowShadow(boolean showShadow) {
                this.showShadow = showShadow;
                return this;
            }

            public Builder setOnDragStateChangedListener(Badge.OnDragStateChangedListener dragStateChangedListener) {
                this.dragStateChangedListener = dragStateChangedListener;
                return this;
            }

            public Builder setExactMode(boolean exactMode) {
                this.exactMode = exactMode;
                return this;
            }

            public Builder setBackgroundColor(int colorBackground) {
                this.colorBackground = colorBackground;
                return this;
            }

            public Builder setBadgePadding(float dpValue) {
                this.badgePadding = dpValue;
                return this;
            }

            public Builder setBadgeNumber(int badgeNumber) {
                this.badgeNumber = badgeNumber;
                this.badgeText = null;
                return this;
            }

            public Builder setBadgeGravity(int badgeGravity) {
                this.badgeGravity = badgeGravity;
                return this;
            }

            public Builder setBadgeTextColor(int colorBadgeText) {
                this.colorBadgeText = colorBadgeText;
                return this;
            }

            public Builder setBadgeTextSize(float badgeTextSize) {
                this.badgeTextSize = badgeTextSize;
                return this;
            }

            public Builder setBadgeText(String badgeText) {
                this.badgeText = badgeText;
                this.badgeNumber = 0;
                return this;
            }

            public Builder setGravityOffset(int offsetX, int offsetY) {
                this.gravityOffsetX = offsetX;
                this.gravityOffsetY = offsetY;
                return this;
            }
        }
    }

    public static class TabTitle {
        private Builder mBuilder;

        private TabTitle(Builder mBuilder) {
            this.mBuilder = mBuilder;
        }

        public int getColorSelected() {
            return this.mBuilder.mColorSelected;
        }

        public int getColorNormal() {
            return this.mBuilder.mColorNormal;
        }

        public int getTitleTextSize() {
            return this.mBuilder.mTitleTextSize;
        }

        public String getContent() {
            return this.mBuilder.mContent;
        }

        public static class Builder {
            private int mColorSelected = -49023;
            private int mColorNormal = -9079435;
            private int mTitleTextSize = 16;
            private String mContent = "";

            public Builder setTextColor(int colorSelected, int colorNormal) {
                this.mColorSelected = colorSelected;
                this.mColorNormal = colorNormal;
                return this;
            }

            public Builder setTextSize(int sizeSp) {
                this.mTitleTextSize = sizeSp;
                return this;
            }

            public Builder setContent(String content) {
                this.mContent = content;
                return this;
            }

            public TabTitle build() {
                return new TabTitle(this);
            }
        }
    }

    public static class TabIcon {
        private Builder mBuilder;

        private TabIcon(Builder mBuilder) {
            this.mBuilder = mBuilder;
        }

        public int getSelectedIcon() {
            return this.mBuilder.mSelectedIcon;
        }

        public int getNormalIcon() {
            return this.mBuilder.mNormalIcon;
        }

        public int getIconGravity() {
            return this.mBuilder.mIconGravity;
        }

        public int getIconWidth() {
            return this.mBuilder.mIconWidth;
        }

        public int getIconHeight() {
            return this.mBuilder.mIconHeight;
        }

        public int getMargin() {
            return this.mBuilder.mMargin;
        }

        public static class Builder {
            private int mSelectedIcon = 0;
            private int mNormalIcon = 0;
            private int mIconGravity = 0x800003;
            private int mIconWidth = -1;
            private int mIconHeight = -1;
            private int mMargin = 0;

            public Builder setIcon(int selectIconResId, int normalIconResId) {
                this.mSelectedIcon = selectIconResId;
                this.mNormalIcon = normalIconResId;
                return this;
            }

            public Builder setIconSize(int width, int height) {
                this.mIconWidth = width;
                this.mIconHeight = height;
                return this;
            }

            public Builder setIconGravity(int gravity) {
                if (gravity != 0x800003 && gravity != 0x800005 & gravity != 48 & gravity != 80) {
                    throw new IllegalStateException("iconGravity only support Gravity.START or Gravity.END or Gravity.TOP or Gravity.BOTTOM");
                }
                this.mIconGravity = gravity;
                return this;
            }

            public Builder setIconMargin(int margin) {
                this.mMargin = margin;
                return this;
            }

            public TabIcon build() {
                return new TabIcon(this);
            }
        }
    }
}

