/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ColorUtils;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.Utils;
import com.xuexiang.xui.widget.tabbar.XUIItemViewsAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class TabSegment
extends HorizontalScrollView {
    private static final String TAG = "TabSegment";
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_TOP = 1;
    public static final int ICON_POSITION_RIGHT = 2;
    public static final int ICON_POSITION_BOTTOM = 3;
    private static final int NO_POSITION = -1;
    private final ArrayList<OnTabSelectedListener> mSelectedListeners = new ArrayList();
    private Container mContentLayout;
    private int mCurrentSelectedIndex = -1;
    private int mPendingSelectedIndex = -1;
    private int mTabTextSize;
    private boolean mHasIndicator = true;
    private int mIndicatorHeight;
    private boolean mIndicatorTop = false;
    private Drawable mIndicatorDrawable;
    private boolean mIsIndicatorWidthFollowContent = true;
    private Rect mIndicatorRect = null;
    private Paint mIndicatorPaint = null;
    private int mNormalColor;
    private int mSelectedColor;
    private int mDefaultTabIconPosition;
    private int mMode = 1;
    private int mItemSpaceInScrollMode;
    private TypefaceProvider mTypefaceProvider;
    private int mViewPagerScrollState = 0;
    private Animator mSelectAnimator;
    private OnTabClickListener mOnTabClickListener;
    protected View.OnClickListener mTabOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (TabSegment.this.mSelectAnimator != null || TabSegment.this.mViewPagerScrollState != 0) {
                return;
            }
            int index = (Integer)v.getTag();
            Tab model = (Tab)TabSegment.this.getAdapter().getItem(index);
            if (model != null) {
                TabSegment.this.selectTab(index, !TabSegment.this.mHasIndicator && !model.isDynamicChangeIconColor(), true);
            }
            if (TabSegment.this.mOnTabClickListener != null) {
                TabSegment.this.mOnTabClickListener.onTabClick(index);
            }
        }
    };
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private DataSetObserver mPagerAdapterObserver;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private OnTabSelectedListener mViewPagerSelectedListener;
    private AdapterChangeListener mAdapterChangeListener;
    private boolean mIsInSelectTab = false;

    public TabSegment(Context context) {
        this(context, null);
    }

    public TabSegment(Context context, boolean hasIndicator) {
        this(context, null);
        this.mHasIndicator = hasIndicator;
    }

    public TabSegment(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.TabSegmentStyle);
    }

    public TabSegment(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.setClipToPadding(false);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TabSegment, defStyleAttr, 0);
        this.mSelectedColor = array.getColor(R.styleable.TabSegment_ts_selected_color, ThemeUtils.resolveColor(context, R.attr.colorAccent));
        this.mNormalColor = array.getColor(R.styleable.TabSegment_ts_normal_color, ContextCompat.getColor((Context)context, (int)R.color.xui_config_color_gray_5));
        this.mHasIndicator = array.getBoolean(R.styleable.TabSegment_ts_has_indicator, true);
        this.mIndicatorHeight = array.getDimensionPixelSize(R.styleable.TabSegment_ts_indicator_height, this.getResources().getDimensionPixelSize(R.dimen.xui_tab_segment_indicator_height));
        this.mTabTextSize = array.getDimensionPixelSize(R.styleable.TabSegment_android_textSize, this.getResources().getDimensionPixelSize(R.dimen.xui_tab_segment_text_size));
        this.mIndicatorTop = array.getBoolean(R.styleable.TabSegment_ts_indicator_top, false);
        this.mDefaultTabIconPosition = array.getInt(R.styleable.TabSegment_ts_icon_position, 0);
        this.mMode = array.getInt(R.styleable.TabSegment_ts_mode, 1);
        this.mItemSpaceInScrollMode = array.getDimensionPixelSize(R.styleable.TabSegment_ts_space, DensityUtils.dp2px(context, 10.0f));
        String typefaceProviderName = array.getString(R.styleable.TabSegment_ts_typeface_provider);
        array.recycle();
        this.mContentLayout = new Container(context);
        this.addView((View)this.mContentLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        this.createTypefaceProvider(context, typefaceProviderName);
    }

    private void createTypefaceProvider(Context context, String className) {
        if (Utils.isNullOrEmpty(className)) {
            return;
        }
        if ((className = className.trim()).length() == 0) {
            return;
        }
        className = this.getFullClassName(context, className);
        try {
            Constructor<TypefaceProvider> constructor;
            ClassLoader classLoader = this.isInEditMode() ? ((Object)((Object)this)).getClass().getClassLoader() : context.getClassLoader();
            Class<TypefaceProvider> providerClass = classLoader.loadClass(className).asSubclass(TypefaceProvider.class);
            try {
                constructor = providerClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Error creating TypefaceProvider " + className, e);
            }
            constructor.setAccessible(true);
            this.mTypefaceProvider = constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find TypefaceProvider " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Could not instantiate the TypefaceProvider: " + className, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate the TypefaceProvider: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access non-public constructor " + className, e);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Class is not a TypefaceProvider " + className, e);
        }
    }

    private String getFullClassName(Context context, String className) {
        if (className.charAt(0) == '.') {
            return context.getPackageName() + className;
        }
        return className;
    }

    public void setTypefaceProvider(TypefaceProvider typefaceProvider) {
        this.mTypefaceProvider = typefaceProvider;
    }

    public TabSegment addTab(Tab item) {
        this.mContentLayout.getTabAdapter().addItem(item);
        return this;
    }

    private TabAdapter getAdapter() {
        return this.mContentLayout.getTabAdapter();
    }

    public void setTabTextSize(int tabTextSize) {
        this.mTabTextSize = tabTextSize;
    }

    public void reset() {
        this.mContentLayout.getTabAdapter().clear();
        this.mCurrentSelectedIndex = -1;
        if (this.mSelectAnimator != null) {
            this.mSelectAnimator.cancel();
            this.mSelectAnimator = null;
        }
    }

    public void notifyDataChanged() {
        this.getAdapter().setup();
        this.populateFromPagerAdapter(false);
    }

    public void addOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        if (!this.mSelectedListeners.contains(listener)) {
            this.mSelectedListeners.add(listener);
        }
    }

    public void setItemSpaceInScrollMode(int itemSpaceInScrollMode) {
        this.mItemSpaceInScrollMode = itemSpaceInScrollMode;
    }

    public void setIndicatorDrawable(Drawable indicatorDrawable) {
        this.mIndicatorDrawable = indicatorDrawable;
        if (indicatorDrawable != null) {
            this.mIndicatorHeight = indicatorDrawable.getIntrinsicHeight();
        }
        this.mContentLayout.invalidate();
    }

    public void setIndicatorWidthAdjustContent(boolean indicatorWidthFollowContent) {
        if (this.mIsIndicatorWidthFollowContent != indicatorWidthFollowContent) {
            this.mIsIndicatorWidthFollowContent = indicatorWidthFollowContent;
            this.mContentLayout.requestLayout();
        }
    }

    public void setIndicatorPosition(boolean isIndicatorTop) {
        if (this.mIndicatorTop != isIndicatorTop) {
            this.mIndicatorTop = isIndicatorTop;
            this.mContentLayout.invalidate();
        }
    }

    public void setHasIndicator(boolean hasIndicator) {
        if (this.mHasIndicator != hasIndicator) {
            this.mHasIndicator = hasIndicator;
            this.invalidate();
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        if (this.mMode != mode) {
            this.mMode = mode;
            this.mContentLayout.invalidate();
        }
    }

    public void removeOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        this.mSelectedListeners.remove(listener);
    }

    public void clearOnTabSelectedListeners() {
        this.mSelectedListeners.clear();
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean useAdapterTitle) {
        this.setupWithViewPager(viewPager, useAdapterTitle, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean useAdapterTitle, boolean autoRefresh) {
        if (this.mViewPager != null) {
            if (this.mOnPageChangeListener != null) {
                this.mViewPager.removeOnPageChangeListener(this.mOnPageChangeListener);
            }
            if (this.mAdapterChangeListener != null) {
                this.mViewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
            }
        }
        if (this.mViewPagerSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mViewPagerSelectedListener);
            this.mViewPagerSelectedListener = null;
        }
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mOnPageChangeListener == null) {
                this.mOnPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            viewPager.addOnPageChangeListener(this.mOnPageChangeListener);
            this.mViewPagerSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.mViewPagerSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter, useAdapterTitle, autoRefresh);
            }
            if (this.mAdapterChangeListener == null) {
                this.mAdapterChangeListener = new AdapterChangeListener(useAdapterTitle);
            }
            this.mAdapterChangeListener.setAutoRefresh(autoRefresh);
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
        } else {
            this.mViewPager = null;
            this.setPagerAdapter(null, false, false);
        }
    }

    private void dispatchTabSelected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabSelected(index);
        }
    }

    private void dispatchTabUnselected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabUnselected(index);
        }
    }

    private void dispatchTabReselected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabReselected(index);
        }
    }

    private void dispatchTabDoubleTap(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onDoubleTap(index);
        }
    }

    public void setDefaultNormalColor(@ColorInt int defaultNormalColor) {
        this.mNormalColor = defaultNormalColor;
    }

    public void setDefaultSelectedColor(@ColorInt int defaultSelectedColor) {
        this.mSelectedColor = defaultSelectedColor;
    }

    public void setDefaultTabIconPosition(int defaultTabIconPosition) {
        this.mDefaultTabIconPosition = defaultTabIconPosition;
    }

    private void setViewPagerScrollState(int state) {
        this.mViewPagerScrollState = state;
        if (this.mViewPagerScrollState == 0 && this.mPendingSelectedIndex != -1 && this.mSelectAnimator == null) {
            this.selectTab(this.mPendingSelectedIndex, true, false);
            this.mPendingSelectedIndex = -1;
        }
    }

    public void selectTab(int index) {
        this.selectTab(index, false, false);
    }

    public void selectTab(final int index, boolean noAnimation, boolean fromTabClick) {
        if (this.mIsInSelectTab) {
            return;
        }
        this.mIsInSelectTab = true;
        TabAdapter tabAdapter = this.getAdapter();
        List listViews = tabAdapter.getViews();
        if (listViews.size() != tabAdapter.getSize()) {
            tabAdapter.setup();
            listViews = tabAdapter.getViews();
        }
        if (listViews.size() == 0 || listViews.size() <= index) {
            this.mIsInSelectTab = false;
            return;
        }
        if (this.mSelectAnimator != null || this.mViewPagerScrollState != 0) {
            this.mPendingSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        if (this.mCurrentSelectedIndex == index) {
            if (fromTabClick) {
                this.dispatchTabReselected(index);
            }
            this.mIsInSelectTab = false;
            this.mContentLayout.invalidate();
            return;
        }
        if (this.mCurrentSelectedIndex > listViews.size()) {
            Log.i((String)TAG, (String)"selectTab: current selected index is bigger than views size.");
            this.mCurrentSelectedIndex = -1;
        }
        if (this.mCurrentSelectedIndex == -1) {
            Tab model = (Tab)tabAdapter.getItem(index);
            this.layoutIndicator(model, true);
            TextView selectedTv = ((TabItemView)((Object)listViews.get(index))).getTextView();
            this.setTextViewTypeface(selectedTv, true);
            ((TabItemView)((Object)listViews.get(index))).updateDecoration(model, true);
            this.dispatchTabSelected(index);
            this.mCurrentSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        final int prev = this.mCurrentSelectedIndex;
        final Tab prevModel = (Tab)tabAdapter.getItem(prev);
        final TabItemView prevView = (TabItemView)((Object)listViews.get(prev));
        final Tab nowModel = (Tab)tabAdapter.getItem(index);
        final TabItemView nowView = (TabItemView)((Object)listViews.get(index));
        if (noAnimation) {
            this.dispatchTabUnselected(prev);
            this.dispatchTabSelected(index);
            this.setTextViewTypeface(prevView.getTextView(), false);
            this.setTextViewTypeface(nowView.getTextView(), true);
            prevView.updateDecoration(prevModel, false);
            nowView.updateDecoration(nowModel, true);
            if (this.getScrollX() > nowView.getLeft()) {
                this.smoothScrollTo(nowView.getLeft(), 0);
            } else {
                int realWidth = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                if (this.getScrollX() + realWidth < nowView.getRight()) {
                    this.smoothScrollBy(nowView.getRight() - realWidth - this.getScrollX(), 0);
                }
            }
            this.mCurrentSelectedIndex = index;
            this.mIsInSelectTab = false;
            this.layoutIndicator(nowModel, true);
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animValue = ((Float)animation.getAnimatedValue()).floatValue();
                int preColor = ColorUtils.computeColor(TabSegment.this.getTabSelectedColor(prevModel), TabSegment.this.getTabNormalColor(prevModel), animValue);
                int nowColor = ColorUtils.computeColor(TabSegment.this.getTabNormalColor(nowModel), TabSegment.this.getTabSelectedColor(nowModel), animValue);
                prevView.setColorInTransition(prevModel, preColor);
                nowView.setColorInTransition(nowModel, nowColor);
                TabSegment.this.layoutIndicatorInTransition(prevModel, nowModel, animValue);
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                TabSegment.this.mSelectAnimator = animation;
            }

            public void onAnimationEnd(Animator animation) {
                TabSegment.this.mSelectAnimator = null;
                prevView.updateDecoration(prevModel, false);
                nowView.updateDecoration(nowModel, true);
                TabSegment.this.dispatchTabSelected(index);
                TabSegment.this.dispatchTabUnselected(prev);
                TabSegment.this.setTextViewTypeface(prevView.getTextView(), false);
                TabSegment.this.setTextViewTypeface(nowView.getTextView(), true);
                TabSegment.this.mCurrentSelectedIndex = index;
                if (TabSegment.this.mPendingSelectedIndex != -1 && TabSegment.this.mViewPagerScrollState == 0) {
                    TabSegment.this.selectTab(TabSegment.this.mPendingSelectedIndex, true, false);
                    TabSegment.this.mPendingSelectedIndex = -1;
                }
            }

            public void onAnimationCancel(Animator animation) {
                TabSegment.this.mSelectAnimator = null;
                prevView.updateDecoration(prevModel, true);
                nowView.updateDecoration(nowModel, false);
                TabSegment.this.layoutIndicator(prevModel, true);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.setDuration(200L);
        animator.start();
        this.mIsInSelectTab = false;
    }

    private void layoutIndicator(Tab model, boolean invalidate) {
        if (model == null) {
            return;
        }
        if (this.mIndicatorRect == null) {
            this.mIndicatorRect = new Rect(model.contentLeft, 0, model.contentLeft + model.contentWidth, 0);
        } else {
            this.mIndicatorRect.left = model.contentLeft;
            this.mIndicatorRect.right = model.contentLeft + model.contentWidth;
        }
        if (this.mIndicatorPaint == null) {
            this.mIndicatorPaint = new Paint();
            this.mIndicatorPaint.setStyle(Paint.Style.FILL);
        }
        this.mIndicatorPaint.setColor(this.getTabSelectedColor(model));
        if (invalidate) {
            this.mContentLayout.invalidate();
        }
    }

    private void layoutIndicatorInTransition(Tab preModel, Tab targetModel, float offsetPercent) {
        int leftDistance = targetModel.getContentLeft() - preModel.getContentLeft();
        int widthDistance = targetModel.getContentWidth() - preModel.getContentWidth();
        int targetLeft = (int)((float)preModel.getContentLeft() + (float)leftDistance * offsetPercent);
        int targetWidth = (int)((float)preModel.getContentWidth() + (float)widthDistance * offsetPercent);
        if (this.mIndicatorRect == null) {
            this.mIndicatorRect = new Rect(targetLeft, 0, targetLeft + targetWidth, 0);
        } else {
            this.mIndicatorRect.left = targetLeft;
            this.mIndicatorRect.right = targetLeft + targetWidth;
        }
        if (this.mIndicatorPaint == null) {
            this.mIndicatorPaint = new Paint();
            this.mIndicatorPaint.setStyle(Paint.Style.FILL);
        }
        int indicatorColor = ColorUtils.computeColor(this.getTabSelectedColor(preModel), this.getTabSelectedColor(targetModel), offsetPercent);
        this.mIndicatorPaint.setColor(indicatorColor);
        this.mContentLayout.invalidate();
    }

    private void setTextViewTypeface(TextView tv, boolean selected) {
        if (this.mTypefaceProvider == null || tv == null) {
            return;
        }
        boolean isBold = selected ? this.mTypefaceProvider.isSelectedTabBold() : this.mTypefaceProvider.isNormalTabBold();
        tv.setTypeface(this.mTypefaceProvider.getTypeface(), isBold ? 1 : 0);
    }

    public void updateIndicatorPosition(int index, float offsetPercent) {
        int targetIndex;
        if (this.mSelectAnimator != null || this.mIsInSelectTab || offsetPercent == 0.0f) {
            return;
        }
        if (offsetPercent < 0.0f) {
            targetIndex = index - 1;
            offsetPercent = -offsetPercent;
        } else {
            targetIndex = index + 1;
        }
        TabAdapter tabAdapter = this.getAdapter();
        List listViews = tabAdapter.getViews();
        if (listViews.size() <= index || listViews.size() <= targetIndex) {
            return;
        }
        Tab preModel = (Tab)tabAdapter.getItem(index);
        Tab targetModel = (Tab)tabAdapter.getItem(targetIndex);
        TabItemView preView = (TabItemView)((Object)listViews.get(index));
        TabItemView targetView = (TabItemView)((Object)listViews.get(targetIndex));
        int preColor = ColorUtils.computeColor(this.getTabSelectedColor(preModel), this.getTabNormalColor(preModel), offsetPercent);
        int targetColor = ColorUtils.computeColor(this.getTabNormalColor(targetModel), this.getTabSelectedColor(targetModel), offsetPercent);
        preView.setColorInTransition(preModel, preColor);
        targetView.setColorInTransition(targetModel, targetColor);
        this.layoutIndicatorInTransition(preModel, targetModel, offsetPercent);
    }

    public void updateTabText(int index, String text) {
        Tab model = (Tab)this.getAdapter().getItem(index);
        if (model == null) {
            return;
        }
        model.setText(text);
        this.notifyDataChanged();
    }

    public void replaceTab(int index, Tab model) {
        try {
            this.getAdapter().replaceItem(index, model);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setOnTabClickListener(OnTabClickListener onTabClickListener2) {
        this.mOnTabClickListener = onTabClickListener2;
    }

    private void setDrawable(TextView tv, Drawable drawable2, int iconPosition) {
        tv.setCompoundDrawables((Drawable)(iconPosition == 0 ? drawable2 : null), (Drawable)(iconPosition == 1 ? drawable2 : null), (Drawable)(iconPosition == 2 ? drawable2 : null), (Drawable)(iconPosition == 3 ? drawable2 : null));
    }

    private int getTabNormalColor(Tab item) {
        int color2 = item.getNormalColor();
        if (color2 == Integer.MIN_VALUE) {
            color2 = this.mNormalColor;
        }
        return color2;
    }

    private int getTabIconPosition(Tab item) {
        int iconPosition = item.getIconPosition();
        if (iconPosition == Integer.MIN_VALUE) {
            iconPosition = this.mDefaultTabIconPosition;
        }
        return iconPosition;
    }

    private int getTabTextSize(Tab item) {
        int textSize = item.getTextSize();
        if (textSize == Integer.MIN_VALUE) {
            textSize = this.mTabTextSize;
        }
        return textSize;
    }

    private int getTabSelectedColor(Tab item) {
        int color2 = item.getSelectedColor();
        if (color2 == Integer.MIN_VALUE) {
            color2 = this.mSelectedColor;
        }
        return color2;
    }

    void populateFromPagerAdapter(boolean useAdapterTitle) {
        if (this.mPagerAdapter == null) {
            if (useAdapterTitle) {
                this.reset();
            }
            return;
        }
        int adapterCount = this.mPagerAdapter.getCount();
        if (useAdapterTitle) {
            this.reset();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(new Tab(this.mPagerAdapter.getPageTitle(i)));
            }
            this.notifyDataChanged();
        }
        if (this.mViewPager != null && adapterCount > 0) {
            int curItem = this.mViewPager.getCurrentItem();
            this.selectTab(curItem, true, false);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            int paddingHor = this.getPaddingLeft() + this.getPaddingRight();
            child.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - paddingHor), (int)0x40000000), heightMeasureSpec);
            if (widthMode == Integer.MIN_VALUE) {
                this.setMeasuredDimension(Math.min(widthSize, child.getMeasuredWidth() + paddingHor), heightMeasureSpec);
                return;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    void setPagerAdapter(@Nullable PagerAdapter adapter, boolean useAdapterTitle, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver(useAdapterTitle);
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter(useAdapterTitle);
    }

    public int getSelectedIndex() {
        return this.mCurrentSelectedIndex;
    }

    private int getTabCount() {
        return this.getAdapter().getSize();
    }

    public Tab getTab(int index) {
        return (Tab)this.getAdapter().getItem(index);
    }

    public void showSignCountView(Context context, int index, int count) {
        Tab tab = (Tab)this.getAdapter().getItem(index);
        tab.showSignCountView(context, count);
        this.notifyDataChanged();
    }

    public void hideSignCountView(int index) {
        Tab tab = (Tab)this.getAdapter().getItem(index);
        tab.hideSignCountView();
    }

    public int getSignCount(int index) {
        Tab tab = (Tab)this.getAdapter().getItem(index);
        return tab.getSignCount();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mCurrentSelectedIndex != -1 && this.mMode == 0) {
            TabAdapter tabAdapter = this.getAdapter();
            TabItemView view = (TabItemView)((Object)tabAdapter.getViews().get(this.mCurrentSelectedIndex));
            if (this.getScrollX() > view.getLeft()) {
                this.scrollTo(view.getLeft(), 0);
            } else {
                int realWidth = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                if (this.getScrollX() + realWidth < view.getRight()) {
                    this.scrollBy(view.getRight() - realWidth - this.getScrollX(), 0);
                }
            }
        }
    }

    private final class Container
    extends ViewGroup {
        private TabAdapter mTabAdapter;

        public Container(Context context) {
            super(context);
            this.mTabAdapter = new TabAdapter(this);
        }

        public TabAdapter getTabAdapter() {
            return this.mTabAdapter;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int i;
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            List childViews = this.mTabAdapter.getViews();
            int size = childViews.size();
            int visibleChild = 0;
            for (i = 0; i < size; ++i) {
                View child = (View)childViews.get(i);
                if (child.getVisibility() != 0) continue;
                ++visibleChild;
            }
            if (size == 0 || visibleChild == 0) {
                this.setMeasuredDimension(widthSpecSize, heightSpecSize);
                return;
            }
            int childHeight = heightSpecSize - this.getPaddingTop() - this.getPaddingBottom();
            int resultWidthSize = 0;
            if (TabSegment.this.mMode == 1) {
                resultWidthSize = widthSpecSize;
                int modeFixItemWidth = widthSpecSize / visibleChild;
                for (i = 0; i < size; ++i) {
                    View child = (View)childViews.get(i);
                    if (child.getVisibility() != 0) continue;
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)modeFixItemWidth, (int)0x40000000);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
            } else {
                for (i = 0; i < size; ++i) {
                    View child = (View)childViews.get(i);
                    if (child.getVisibility() != 0) continue;
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSpecSize, (int)Integer.MIN_VALUE);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    resultWidthSize += child.getMeasuredWidth() + TabSegment.this.mItemSpaceInScrollMode;
                }
                resultWidthSize -= TabSegment.this.mItemSpaceInScrollMode;
            }
            this.setMeasuredDimension(resultWidthSize, heightSpecSize);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            int i;
            List childViews = this.mTabAdapter.getViews();
            int size = childViews.size();
            int visibleChild = 0;
            for (i = 0; i < size; ++i) {
                View child = (View)childViews.get(i);
                if (child.getVisibility() != 0) continue;
                ++visibleChild;
            }
            if (size == 0 || visibleChild == 0) {
                return;
            }
            int usedLeft = this.getPaddingLeft();
            for (i = 0; i < size; ++i) {
                int newWidth;
                int newLeft;
                TabItemView childView = (TabItemView)((Object)childViews.get(i));
                if (childView.getVisibility() != 0) continue;
                int childMeasureWidth = childView.getMeasuredWidth();
                childView.layout(usedLeft, this.getPaddingTop(), usedLeft + childMeasureWidth, b - t - this.getPaddingBottom());
                Tab model = (Tab)this.mTabAdapter.getItem(i);
                int oldLeft = model.getContentLeft();
                int oldWidth = model.getContentWidth();
                if (TabSegment.this.mMode == 1 && TabSegment.this.mIsIndicatorWidthFollowContent) {
                    TextView contentView = childView.getTextView();
                    newLeft = usedLeft + contentView.getLeft();
                    newWidth = contentView.getWidth();
                } else {
                    newLeft = usedLeft;
                    newWidth = childMeasureWidth;
                }
                if (oldLeft != newLeft || oldWidth != newWidth) {
                    model.setContentLeft(newLeft);
                    model.setContentWidth(newWidth);
                }
                usedLeft = usedLeft + childMeasureWidth + (TabSegment.this.mMode == 0 ? TabSegment.this.mItemSpaceInScrollMode : 0);
            }
            if (TabSegment.this.mCurrentSelectedIndex != -1 && TabSegment.this.mSelectAnimator == null && TabSegment.this.mViewPagerScrollState == 0) {
                TabSegment.this.layoutIndicator((Tab)this.mTabAdapter.getItem(TabSegment.this.mCurrentSelectedIndex), false);
            }
        }

        protected void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            if (TabSegment.this.mHasIndicator && TabSegment.this.mIndicatorRect != null) {
                if (TabSegment.this.mIndicatorTop) {
                    ((TabSegment)TabSegment.this).mIndicatorRect.top = this.getPaddingTop();
                    ((TabSegment)TabSegment.this).mIndicatorRect.bottom = ((TabSegment)TabSegment.this).mIndicatorRect.top + TabSegment.this.mIndicatorHeight;
                } else {
                    ((TabSegment)TabSegment.this).mIndicatorRect.bottom = this.getHeight() - this.getPaddingBottom();
                    ((TabSegment)TabSegment.this).mIndicatorRect.top = ((TabSegment)TabSegment.this).mIndicatorRect.bottom - TabSegment.this.mIndicatorHeight;
                }
                if (TabSegment.this.mIndicatorDrawable != null) {
                    TabSegment.this.mIndicatorDrawable.setBounds(TabSegment.this.mIndicatorRect);
                    TabSegment.this.mIndicatorDrawable.draw(canvas);
                } else {
                    canvas.drawRect(TabSegment.this.mIndicatorRect, TabSegment.this.mIndicatorPaint);
                }
            }
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private final boolean mUseAdapterTitle;

        PagerAdapterObserver(boolean useAdapterTitle) {
            this.mUseAdapterTitle = useAdapterTitle;
        }

        public void onChanged() {
            TabSegment.this.populateFromPagerAdapter(this.mUseAdapterTitle);
        }

        public void onInvalidated() {
            TabSegment.this.populateFromPagerAdapter(this.mUseAdapterTitle);
        }
    }

    public class TabItemView
    extends RelativeLayout {
        private AppCompatTextView mTextView;
        private GestureDetector mGestureDetector;

        public TabItemView(Context context) {
            super(context);
            this.mTextView = new AppCompatTextView(this.getContext());
            this.mTextView.setSingleLine(true);
            this.mTextView.setGravity(17);
            this.mTextView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            this.mTextView.setTypeface(XUI.getDefaultTypeface());
            this.mTextView.setId(R.id.xui_tab_segment_item_id);
            RelativeLayout.LayoutParams tvLp = new RelativeLayout.LayoutParams(-2, -2);
            tvLp.addRule(15, -1);
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)tvLp);
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onDoubleTap(MotionEvent e) {
                    if (TabSegment.this.mSelectedListeners.isEmpty()) {
                        return false;
                    }
                    int index = (Integer)TabItemView.this.getTag();
                    Tab model = (Tab)TabSegment.this.getAdapter().getItem(index);
                    if (model != null) {
                        TabSegment.this.dispatchTabDoubleTap(index);
                        return true;
                    }
                    return false;
                }
            });
        }

        public TextView getTextView() {
            return this.mTextView;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return this.mGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
        }

        public void setColorInTransition(Tab tab, int color2) {
            Drawable icon;
            this.mTextView.setTextColor(color2);
            if (tab.isDynamicChangeIconColor() && (icon = this.mTextView.getCompoundDrawables()[TabSegment.this.getTabIconPosition(tab)]) != null) {
                Utils.setDrawableTintColor(icon, color2);
                TabSegment.this.setDrawable((TextView)this.mTextView, icon, TabSegment.this.getTabIconPosition(tab));
            }
        }

        public void updateDecoration(Tab tab, boolean isSelected) {
            int color2 = isSelected ? TabSegment.this.getTabSelectedColor(tab) : TabSegment.this.getTabNormalColor(tab);
            this.mTextView.setTextColor(color2);
            Drawable icon = tab.getNormalIcon();
            if (isSelected) {
                if (!tab.isDynamicChangeIconColor()) {
                    icon = tab.getSelectedIcon() != null ? tab.getSelectedIcon() : icon;
                } else if (icon != null) {
                    icon = icon.mutate();
                    Utils.setDrawableTintColor(icon, color2);
                }
            }
            if (icon == null) {
                this.mTextView.setCompoundDrawablePadding(0);
                this.mTextView.setCompoundDrawables(null, null, null, null);
            } else {
                this.mTextView.setCompoundDrawablePadding(DensityUtils.dp2px(this.getContext(), 4.0f));
                TabSegment.this.setDrawable((TextView)this.mTextView, icon, TabSegment.this.getTabIconPosition(tab));
            }
        }
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        private boolean mAutoRefresh;
        private final boolean mUseAdapterTitle;

        AdapterChangeListener(boolean useAdapterTitle) {
            this.mUseAdapterTitle = useAdapterTitle;
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (TabSegment.this.mViewPager == viewPager) {
                TabSegment.this.setPagerAdapter(newAdapter, this.mUseAdapterTitle, this.mAutoRefresh);
            }
        }

        void setAutoRefresh(boolean autoRefresh) {
            this.mAutoRefresh = autoRefresh;
        }
    }

    public class TabAdapter
    extends XUIItemViewsAdapter<Tab, TabItemView> {
        public TabAdapter(ViewGroup parentView) {
            super(parentView);
        }

        @Override
        protected TabItemView createView(ViewGroup parentView) {
            return new TabItemView(TabSegment.this.getContext());
        }

        @Override
        protected void bind(Tab item, TabItemView view, int position) {
            TextView tv = view.getTextView();
            TabSegment.this.setTextViewTypeface(tv, false);
            List<View> mCustomViews = item.getCustomViews();
            if (mCustomViews != null && mCustomViews.size() > 0) {
                view.setTag(R.id.xui_view_can_not_cache_tag, true);
                for (View v : mCustomViews) {
                    if (v.getParent() != null) continue;
                    view.addView(v);
                }
            }
            if (TabSegment.this.mMode == 1) {
                int gravity = item.getGravity();
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)tv.getLayoutParams();
                lp.addRule(9, (gravity & 3) == 3 ? -1 : 0);
                lp.addRule(14, (gravity & 0x11) == 17 ? -1 : 0);
                lp.addRule(11, (gravity & 5) == 5 ? -1 : 0);
                tv.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            tv.setText(item.getText());
            tv.setTextSize(0, (float)TabSegment.this.getTabTextSize(item));
            view.updateDecoration(item, TabSegment.this.mCurrentSelectedIndex == position);
            view.setTag(position);
            view.setOnClickListener(TabSegment.this.mTabOnClickListener);
        }
    }

    public static class Tab {
        public static final int USE_TAB_SEGMENT = Integer.MIN_VALUE;
        private int textSize = Integer.MIN_VALUE;
        private int normalColor = Integer.MIN_VALUE;
        private int selectedColor = Integer.MIN_VALUE;
        private Drawable normalIcon = null;
        private Drawable selectedIcon = null;
        private int contentWidth = 0;
        private int contentLeft = 0;
        private int iconPosition = Integer.MIN_VALUE;
        private int gravity = 17;
        private CharSequence text;
        private List<View> mCustomViews;
        private int mSignCountDigits = 2;
        private TextView mSignCountTextView;
        private int mSignCountMarginLeft = 0;
        private int mSignCountMarginTop = 0;
        private boolean dynamicChangeIconColor = true;

        public Tab(CharSequence text) {
            this.text = text;
        }

        public Tab(Drawable normalIcon, Drawable selectedIcon, CharSequence text, boolean dynamicChangeIconColor) {
            this(normalIcon, selectedIcon, text, dynamicChangeIconColor, true);
        }

        public Tab(Drawable normalIcon, Drawable selectedIcon, CharSequence text, boolean dynamicChangeIconColor, boolean setIntrinsicSize) {
            this.normalIcon = normalIcon;
            if (this.normalIcon != null && setIntrinsicSize) {
                this.normalIcon.setBounds(0, 0, normalIcon.getIntrinsicWidth(), normalIcon.getIntrinsicHeight());
            }
            this.selectedIcon = selectedIcon;
            if (this.selectedIcon != null && setIntrinsicSize) {
                this.selectedIcon.setBounds(0, 0, selectedIcon.getIntrinsicWidth(), selectedIcon.getIntrinsicHeight());
            }
            this.text = text;
            this.dynamicChangeIconColor = dynamicChangeIconColor;
        }

        public void setmSignCountDigits(int digit) {
            this.mSignCountDigits = digit;
        }

        public void setTextColor(@ColorInt int normalColor, @ColorInt int selectedColor) {
            this.normalColor = normalColor;
            this.selectedColor = selectedColor;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public void setTextSize(int textSize) {
            this.textSize = textSize;
        }

        public CharSequence getText() {
            return this.text;
        }

        public void setText(CharSequence text) {
            this.text = text;
        }

        public int getContentLeft() {
            return this.contentLeft;
        }

        public void setContentLeft(int contentLeft) {
            this.contentLeft = contentLeft;
        }

        public int getContentWidth() {
            return this.contentWidth;
        }

        public void setContentWidth(int contentWidth) {
            this.contentWidth = contentWidth;
        }

        public int getIconPosition() {
            return this.iconPosition;
        }

        public void setIconPosition(int iconPosition) {
            this.iconPosition = iconPosition;
        }

        public int getGravity() {
            return this.gravity;
        }

        public void setGravity(int gravity) {
            this.gravity = gravity;
        }

        public int getNormalColor() {
            return this.normalColor;
        }

        public Drawable getNormalIcon() {
            return this.normalIcon;
        }

        public int getSelectedColor() {
            return this.selectedColor;
        }

        public Drawable getSelectedIcon() {
            return this.selectedIcon;
        }

        public boolean isDynamicChangeIconColor() {
            return this.dynamicChangeIconColor;
        }

        public void addCustomView(@NonNull View view) {
            if (this.mCustomViews == null) {
                this.mCustomViews = new ArrayList<View>();
            }
            if (view.getLayoutParams() == null) {
                view.setLayoutParams((ViewGroup.LayoutParams)this.getDefaultCustomLayoutParam());
            }
            this.mCustomViews.add(view);
        }

        public List<View> getCustomViews() {
            return this.mCustomViews;
        }

        public void setSignCountMargin(int marginLeft, int marginTop) {
            this.mSignCountMarginLeft = marginLeft;
            this.mSignCountMarginTop = marginTop;
            if (this.mSignCountTextView != null && this.mSignCountTextView.getLayoutParams() != null) {
                ((ViewGroup.MarginLayoutParams)this.mSignCountTextView.getLayoutParams()).leftMargin = marginLeft;
                ((ViewGroup.MarginLayoutParams)this.mSignCountTextView.getLayoutParams()).topMargin = marginTop;
            }
        }

        private TextView ensureSignCountView(Context context) {
            if (this.mSignCountTextView == null) {
                this.mSignCountTextView = new TextView(context, null, R.attr.xui_tab_sign_count_view);
                RelativeLayout.LayoutParams signCountLp = new RelativeLayout.LayoutParams(-2, ThemeUtils.resolveDimension(context, R.attr.xui_tab_sign_count_view_minSize));
                signCountLp.addRule(6, R.id.xui_tab_segment_item_id);
                signCountLp.addRule(1, R.id.xui_tab_segment_item_id);
                this.mSignCountTextView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
                this.addCustomView((View)this.mSignCountTextView);
            }
            this.setSignCountMargin(this.mSignCountMarginLeft, this.mSignCountMarginTop);
            return this.mSignCountTextView;
        }

        public void showSignCountView(Context context, int count) {
            this.ensureSignCountView(context);
            this.mSignCountTextView.setVisibility(0);
            RelativeLayout.LayoutParams signCountLp = (RelativeLayout.LayoutParams)this.mSignCountTextView.getLayoutParams();
            if (count != 0) {
                signCountLp.height = ThemeUtils.resolveDimension(this.mSignCountTextView.getContext(), R.attr.xui_tab_sign_count_view_minSize_with_text);
                this.mSignCountTextView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
                this.mSignCountTextView.setMinHeight(ThemeUtils.resolveDimension(this.mSignCountTextView.getContext(), R.attr.xui_tab_sign_count_view_minSize_with_text));
                this.mSignCountTextView.setMinWidth(ThemeUtils.resolveDimension(this.mSignCountTextView.getContext(), R.attr.xui_tab_sign_count_view_minSize_with_text));
                this.mSignCountTextView.setText((CharSequence)this.getNumberDigitsFormattingValue(count));
            } else {
                signCountLp.height = ThemeUtils.resolveDimension(this.mSignCountTextView.getContext(), R.attr.xui_tab_sign_count_view_minSize);
                this.mSignCountTextView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
                this.mSignCountTextView.setMinHeight(ThemeUtils.resolveDimension(this.mSignCountTextView.getContext(), R.attr.xui_tab_sign_count_view_minSize));
                this.mSignCountTextView.setMinWidth(ThemeUtils.resolveDimension(this.mSignCountTextView.getContext(), R.attr.xui_tab_sign_count_view_minSize));
                this.mSignCountTextView.setText(null);
            }
        }

        public void hideSignCountView() {
            if (this.mSignCountTextView != null) {
                this.mSignCountTextView.setVisibility(8);
            }
        }

        public int getSignCount() {
            if (this.mSignCountTextView == null || this.mSignCountTextView.getVisibility() != 0) {
                return 0;
            }
            if (!Utils.isNullOrEmpty(this.mSignCountTextView.getText())) {
                return Integer.parseInt(this.mSignCountTextView.getText().toString());
            }
            return 0;
        }

        private RelativeLayout.LayoutParams getDefaultCustomLayoutParam() {
            return new RelativeLayout.LayoutParams(-2, -2);
        }

        private String getNumberDigitsFormattingValue(int number) {
            if (Utils.getNumberDigits(number) > this.mSignCountDigits) {
                StringBuilder result = new StringBuilder();
                for (int digit = 1; digit <= this.mSignCountDigits; ++digit) {
                    result.append("9");
                }
                result.append("+");
                return result.toString();
            }
            return String.valueOf(number);
        }
    }

    private static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager mViewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(int index) {
            this.mViewPager.setCurrentItem(index, false);
        }

        @Override
        public void onTabUnselected(int index) {
        }

        @Override
        public void onTabReselected(int index) {
        }

        @Override
        public void onDoubleTap(int index) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<TabSegment> mTabSegmentRef;

        public TabLayoutOnPageChangeListener(TabSegment tabSegment) {
            this.mTabSegmentRef = new WeakReference<TabSegment>(tabSegment);
        }

        public void onPageScrollStateChanged(int state) {
            TabSegment tabSegment = (TabSegment)((Object)this.mTabSegmentRef.get());
            if (tabSegment != null) {
                tabSegment.setViewPagerScrollState(state);
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            TabSegment tabSegment = (TabSegment)((Object)this.mTabSegmentRef.get());
            if (tabSegment != null) {
                tabSegment.updateIndicatorPosition(position, positionOffset);
            }
        }

        public void onPageSelected(int position) {
            TabSegment tabSegment = (TabSegment)((Object)this.mTabSegmentRef.get());
            if (tabSegment != null && tabSegment.getSelectedIndex() != position && position < tabSegment.getTabCount()) {
                tabSegment.selectTab(position, true, false);
            }
        }
    }

    public static interface TypefaceProvider {
        public boolean isNormalTabBold();

        public boolean isSelectedTabBold();

        @Nullable
        public Typeface getTypeface();
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1);

        public void onTabUnselected(int var1);

        public void onTabReselected(int var1);

        public void onDoubleTap(int var1);
    }

    public static interface OnTabClickListener {
        public void onTabClick(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

