/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.statelayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class MultipleStatusView
extends FrameLayout {
    private static final FrameLayout.LayoutParams DEFAULT_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-1, -1);
    public static final int STATUS_CONTENT = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_EMPTY = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_NO_NETWORK = 4;
    private static final int NULL_RESOURCE_ID = -1;
    private View mEmptyView;
    private View mErrorView;
    private View mLoadingView;
    private View mNoNetworkView;
    private View mContentView;
    private int mEmptyViewResId;
    private int mErrorViewResId;
    private int mLoadingViewResId;
    private int mNoNetworkViewResId;
    private int mContentViewResId;
    private int mViewStatus;
    private LayoutInflater mInflater;
    private View.OnClickListener mOnRetryClickListener;
    private final List<Integer> mOtherIds = new ArrayList<Integer>();

    public MultipleStatusView(Context context) {
        this(context, null);
    }

    public MultipleStatusView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MultipleStatusViewStyle);
    }

    public MultipleStatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MultipleStatusView, defStyleAttr, 0);
        this.mEmptyViewResId = a.getResourceId(R.styleable.MultipleStatusView_msv_emptyView, R.layout.msv_empty_view);
        this.mErrorViewResId = a.getResourceId(R.styleable.MultipleStatusView_msv_errorView, R.layout.msv_error_view);
        this.mLoadingViewResId = a.getResourceId(R.styleable.MultipleStatusView_msv_loadingView, R.layout.msv_loading_view);
        this.mNoNetworkViewResId = a.getResourceId(R.styleable.MultipleStatusView_msv_noNetworkView, R.layout.msv_no_network_view);
        this.mContentViewResId = a.getResourceId(R.styleable.MultipleStatusView_msv_contentView, -1);
        a.recycle();
        this.mInflater = LayoutInflater.from((Context)this.getContext());
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.showContent();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear(this.mEmptyView, this.mLoadingView, this.mErrorView, this.mNoNetworkView);
        if (null != this.mOtherIds) {
            this.mOtherIds.clear();
        }
        if (null != this.mOnRetryClickListener) {
            this.mOnRetryClickListener = null;
        }
        this.mInflater = null;
    }

    public int getViewStatus() {
        return this.mViewStatus;
    }

    public void setOnRetryClickListener(View.OnClickListener onRetryClickListener) {
        this.mOnRetryClickListener = onRetryClickListener;
    }

    public final void showEmpty() {
        this.showEmpty(this.mEmptyViewResId, (ViewGroup.LayoutParams)DEFAULT_LAYOUT_PARAMS);
    }

    public final void showEmpty(int layoutId, ViewGroup.LayoutParams layoutParams) {
        this.showEmpty(this.inflateView(layoutId), layoutParams);
    }

    public final void showEmpty(View view, ViewGroup.LayoutParams layoutParams) {
        Utils.checkNull(view, "Empty view is null!");
        this.mViewStatus = 2;
        if (null == this.mEmptyView) {
            this.mEmptyView = view;
            if (null != this.mOnRetryClickListener) {
                this.mEmptyView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.mOtherIds.add(this.mEmptyView.getId());
            this.addView(this.mEmptyView, 0, layoutParams);
        }
        this.showViewById(this.mEmptyView.getId());
    }

    public final void showError() {
        this.showError(this.mErrorViewResId, (ViewGroup.LayoutParams)DEFAULT_LAYOUT_PARAMS);
    }

    public final void showError(int layoutId, ViewGroup.LayoutParams layoutParams) {
        this.showError(this.inflateView(layoutId), layoutParams);
    }

    public final void showError(View view, ViewGroup.LayoutParams layoutParams) {
        Utils.checkNull(view, "Error view is null!");
        this.mViewStatus = 3;
        if (null == this.mErrorView) {
            this.mErrorView = view;
            if (null != this.mOnRetryClickListener) {
                this.mErrorView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.mOtherIds.add(this.mErrorView.getId());
            this.addView(this.mErrorView, 0, layoutParams);
        }
        this.showViewById(this.mErrorView.getId());
    }

    public final void showLoading() {
        this.showLoading(this.mLoadingViewResId, (ViewGroup.LayoutParams)DEFAULT_LAYOUT_PARAMS);
    }

    public final void showLoading(int layoutId, ViewGroup.LayoutParams layoutParams) {
        this.showLoading(this.inflateView(layoutId), layoutParams);
    }

    public final void showLoading(View view, ViewGroup.LayoutParams layoutParams) {
        Utils.checkNull(view, "Loading view is null!");
        this.mViewStatus = 1;
        if (null == this.mLoadingView) {
            this.mLoadingView = view;
            this.mOtherIds.add(this.mLoadingView.getId());
            this.addView(this.mLoadingView, 0, layoutParams);
        }
        this.showViewById(this.mLoadingView.getId());
    }

    public final void showNoNetwork() {
        this.showNoNetwork(this.mNoNetworkViewResId, (ViewGroup.LayoutParams)DEFAULT_LAYOUT_PARAMS);
    }

    public final void showNoNetwork(int layoutId, ViewGroup.LayoutParams layoutParams) {
        this.showNoNetwork(this.inflateView(layoutId), layoutParams);
    }

    public final void showNoNetwork(View view, ViewGroup.LayoutParams layoutParams) {
        Utils.checkNull(view, "No network view is null!");
        this.mViewStatus = 4;
        if (null == this.mNoNetworkView) {
            this.mNoNetworkView = view;
            if (null != this.mOnRetryClickListener) {
                this.mNoNetworkView.setOnClickListener(this.mOnRetryClickListener);
            }
            this.mOtherIds.add(this.mNoNetworkView.getId());
            this.addView(this.mNoNetworkView, 0, layoutParams);
        }
        this.showViewById(this.mNoNetworkView.getId());
    }

    public final void showContent() {
        this.mViewStatus = 0;
        if (null == this.mContentView && this.mContentViewResId != -1) {
            this.mContentView = this.mInflater.inflate(this.mContentViewResId, null);
            this.addView(this.mContentView, 0, (ViewGroup.LayoutParams)DEFAULT_LAYOUT_PARAMS);
        }
        this.showContentView();
    }

    public View getErrorView() {
        return this.mErrorView;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public View getLoadingView() {
        return this.mLoadingView;
    }

    public View getNoNetworkView() {
        return this.mNoNetworkView;
    }

    public View getContentView() {
        return this.mContentView;
    }

    private void showContentView() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view;
            view.setVisibility(this.mOtherIds.contains((view = this.getChildAt(i)).getId()) ? 8 : 0);
        }
    }

    private View inflateView(int layoutId) {
        return this.mInflater.inflate(layoutId, null);
    }

    private void showViewById(int viewId) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view;
            view.setVisibility((view = this.getChildAt(i)).getId() == viewId ? 0 : 8);
        }
    }

    private void clear(View ... views) {
        if (null == views) {
            return;
        }
        try {
            for (View view : views) {
                if (null == view) continue;
                this.removeView(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

