/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.slideback.dispatcher.impl;

import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import com.xuexiang.xui.widget.slideback.SlideInfo;
import com.xuexiang.xui.widget.slideback.callback.SlideCallBack;
import com.xuexiang.xui.widget.slideback.dispatcher.ISlideTouchEventDispatcher;
import com.xuexiang.xui.widget.slideback.dispatcher.OnSlideUpdateListener;

public class DefaultSlideTouchDispatcher
implements ISlideTouchEventDispatcher {
    protected boolean mIsSideSlideLeft = false;
    protected boolean mIsSideSlideRight = false;
    protected float mDownX = 0.0f;
    protected float mMoveXLength = 0.0f;
    protected SlideInfo mSlideInfo;
    protected SlideCallBack mCallBack;
    protected OnSlideUpdateListener mOnSlideUpdateListener;

    @Override
    public ISlideTouchEventDispatcher init(@NonNull SlideInfo slideInfo, @NonNull SlideCallBack callBack, @NonNull OnSlideUpdateListener listener) {
        this.mSlideInfo = slideInfo;
        this.mCallBack = callBack;
        this.mOnSlideUpdateListener = listener;
        return this;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mDownX = event.getRawX();
                if (this.mSlideInfo.isAllowEdgeLeft() && this.mDownX <= this.mSlideInfo.getSideSlideLength()) {
                    this.mIsSideSlideLeft = true;
                    break;
                }
                if (!this.mSlideInfo.isAllowEdgeRight() || !(this.mDownX >= this.mSlideInfo.getScreenWidth() - this.mSlideInfo.getSideSlideLength())) break;
                this.mIsSideSlideRight = true;
                break;
            }
            case 2: {
                if (!this.mIsSideSlideLeft && !this.mIsSideSlideRight) break;
                this.mMoveXLength = Math.abs(event.getRawX() - this.mDownX);
                if (this.mMoveXLength / this.mSlideInfo.getDragRate() <= this.mSlideInfo.getMaxSlideLength()) {
                    if (this.mSlideInfo.isAllowEdgeLeft() && this.mIsSideSlideLeft) {
                        this.updateSlideLength(true, this.mMoveXLength / this.mSlideInfo.getDragRate());
                    } else if (this.mSlideInfo.isAllowEdgeRight() && this.mIsSideSlideRight) {
                        this.updateSlideLength(false, this.mMoveXLength / this.mSlideInfo.getDragRate());
                    }
                }
                if (this.mSlideInfo.isAllowEdgeLeft() && this.mIsSideSlideLeft) {
                    this.updateSlidePosition(true, (int)event.getRawY());
                    break;
                }
                if (!this.mSlideInfo.isAllowEdgeRight() || !this.mIsSideSlideRight) break;
                this.updateSlidePosition(false, (int)event.getRawY());
                break;
            }
            case 1: {
                if ((this.mIsSideSlideLeft || this.mIsSideSlideRight) && this.mMoveXLength / this.mSlideInfo.getDragRate() >= this.mSlideInfo.getMaxSlideLength() && null != this.mCallBack) {
                    this.mCallBack.onSlide(this.mIsSideSlideLeft ? 0 : 1);
                }
                if (this.mSlideInfo.isAllowEdgeLeft() && this.mIsSideSlideLeft) {
                    this.updateSlideLength(true, 0.0f);
                } else if (this.mSlideInfo.isAllowEdgeRight() && this.mIsSideSlideRight) {
                    this.updateSlideLength(false, 0.0f);
                }
                this.mIsSideSlideLeft = false;
                this.mIsSideSlideRight = false;
            }
        }
        return this.mIsSideSlideLeft || this.mIsSideSlideRight;
    }

    @Override
    public void updateSlideLength(boolean isLeft, float length) {
        if (this.mOnSlideUpdateListener != null) {
            this.mOnSlideUpdateListener.updateSlideLength(isLeft, length);
        }
    }

    @Override
    public void updateSlidePosition(boolean isLeft, int position) {
        if (this.mOnSlideUpdateListener != null) {
            this.mOnSlideUpdateListener.updateSlidePosition(isLeft, position);
        }
    }
}

