/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.slideback;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.xuexiang.xui.widget.slideback.SlideInfo;
import com.xuexiang.xui.widget.slideback.callback.SlideBackCallBack;
import com.xuexiang.xui.widget.slideback.callback.SlideCallBack;
import com.xuexiang.xui.widget.slideback.dispatcher.ISlideTouchEventDispatcher;
import com.xuexiang.xui.widget.slideback.dispatcher.OnSlideUpdateListener;
import com.xuexiang.xui.widget.slideback.dispatcher.impl.DefaultSlideTouchDispatcher;
import com.xuexiang.xui.widget.slideback.widget.SlideBackIconView;
import com.xuexiang.xui.widget.slideback.widget.SlideBackInterceptLayout;

public class SlideBackManager
implements OnSlideUpdateListener {
    private SlideBackIconView mSlideBackIconViewLeft;
    private SlideBackIconView mSlideBackIconViewRight;
    private Activity mActivity;
    private boolean mHaveScroll;
    private SlideCallBack mCallBack;
    private SlideInfo mSlideInfo;

    SlideBackManager(Activity activity) {
        this.mActivity = activity;
        this.mHaveScroll = false;
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        this.mSlideInfo = new SlideInfo().setBackViewHeight((float)dm.heightPixels / 4.0f).setArrowSize(this.dp2px(5.0f)).setScreenWidth(dm.widthPixels).setMaxSlideLength((float)dm.widthPixels / 12.0f).setSideSlideLength((float)dm.widthPixels / 24.0f).setDragRate(3.0f).setAllowEdgeLeft(true).setAllowEdgeRight(false);
    }

    public SlideBackManager haveScroll(boolean haveScroll) {
        this.mHaveScroll = haveScroll;
        return this;
    }

    public SlideBackManager callBack(SlideBackCallBack callBack) {
        this.mCallBack = new SlideCallBack(callBack){

            @Override
            public void onSlide(int edgeFrom) {
                this.onSlideBack();
            }
        };
        return this;
    }

    public SlideBackManager callBack(SlideCallBack callBack) {
        this.mCallBack = callBack;
        return this;
    }

    public SlideBackManager viewHeight(float backViewHeightDP) {
        this.mSlideInfo.setBackViewHeight(this.dp2px(backViewHeightDP));
        return this;
    }

    public SlideBackManager arrowSize(float arrowSizeDP) {
        this.mSlideInfo.setArrowSize(this.dp2px(arrowSizeDP));
        return this;
    }

    public SlideBackManager maxSlideLength(float maxSlideLengthDP) {
        this.mSlideInfo.setMaxSlideLength(this.dp2px(maxSlideLengthDP));
        return this;
    }

    public SlideBackManager sideSlideLength(float sideSlideLengthDP) {
        this.mSlideInfo.setSideSlideLength(this.dp2px(sideSlideLengthDP));
        return this;
    }

    public SlideBackManager dragRate(float dragRate) {
        this.mSlideInfo.setDragRate(dragRate);
        return this;
    }

    public SlideBackManager edgeMode(int edgeMode) {
        switch (edgeMode) {
            case 0: {
                this.mSlideInfo.setEdgeMode(true, false);
                break;
            }
            case 1: {
                this.mSlideInfo.setEdgeMode(false, true);
                break;
            }
            case 2: {
                this.mSlideInfo.setEdgeMode(true, true);
                break;
            }
            default: {
                throw new RuntimeException("\u672a\u5b9a\u4e49\u7684\u8fb9\u7f18\u4fa7\u6ed1\u6a21\u5f0f\u503c\uff1aEdgeMode = " + edgeMode);
            }
        }
        return this;
    }

    public void register() {
        this.register(new DefaultSlideTouchDispatcher().init(this.mSlideInfo, this.mCallBack, this));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void register(ISlideTouchEventDispatcher dispatcher) {
        if (this.mSlideInfo.isAllowEdgeLeft()) {
            this.mSlideBackIconViewLeft = new SlideBackIconView((Context)this.mActivity);
            this.mSlideBackIconViewLeft.setBackViewHeight(this.mSlideInfo.getBackViewHeight());
            this.mSlideBackIconViewLeft.setArrowSize(this.mSlideInfo.getArrowSize());
            this.mSlideBackIconViewLeft.setMaxSlideLength(this.mSlideInfo.getMaxSlideLength());
        }
        if (this.mSlideInfo.isAllowEdgeRight()) {
            this.mSlideBackIconViewRight = new SlideBackIconView((Context)this.mActivity);
            this.mSlideBackIconViewRight.setBackViewHeight(this.mSlideInfo.getBackViewHeight());
            this.mSlideBackIconViewRight.setArrowSize(this.mSlideInfo.getArrowSize());
            this.mSlideBackIconViewRight.setMaxSlideLength(this.mSlideInfo.getMaxSlideLength());
            this.mSlideBackIconViewRight.setRotationY(180.0f);
        }
        FrameLayout container = (FrameLayout)this.mActivity.getWindow().getDecorView();
        if (this.mHaveScroll) {
            SlideBackInterceptLayout interceptLayout = new SlideBackInterceptLayout((Context)this.mActivity);
            interceptLayout.setSideSlideLength(this.mSlideInfo.getSideSlideLength());
            this.addInterceptLayout((ViewGroup)container, interceptLayout);
        }
        if (this.mSlideInfo.isAllowEdgeLeft()) {
            container.addView((View)this.mSlideBackIconViewLeft);
        }
        if (this.mSlideInfo.isAllowEdgeRight()) {
            container.addView((View)this.mSlideBackIconViewRight);
        }
        container.setOnTouchListener((View.OnTouchListener)dispatcher);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    void unregister() {
        this.mActivity = null;
        this.mCallBack = null;
        this.mSlideBackIconViewLeft = null;
        this.mSlideBackIconViewRight = null;
    }

    private void addInterceptLayout(ViewGroup decorView, SlideBackInterceptLayout interceptLayout) {
        View rootLayout = decorView.getChildAt(0);
        decorView.removeView(rootLayout);
        interceptLayout.addView(rootLayout, -1, -1);
        decorView.addView((View)interceptLayout);
    }

    private void removeInterceptLayout(ViewGroup decorView) {
        FrameLayout rootLayout = (FrameLayout)decorView.getChildAt(0);
        decorView.removeView((View)rootLayout);
        View oriLayout = rootLayout.getChildAt(0);
        rootLayout.removeView(oriLayout);
        decorView.addView(oriLayout);
    }

    private void setSlideBackPosition(SlideBackIconView view, int position) {
        int topMargin = (int)((float)position - view.getBackViewHeight() / 2.0f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(view.getLayoutParams());
        layoutParams.topMargin = topMargin;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private float dp2px(float dpValue) {
        return dpValue * this.mActivity.getResources().getDisplayMetrics().density + 0.5f;
    }

    @Override
    public void updateSlideLength(boolean isLeft, float length) {
        if (isLeft) {
            this.mSlideBackIconViewLeft.updateSlideLength(length);
        } else {
            this.mSlideBackIconViewRight.updateSlideLength(length);
        }
    }

    @Override
    public void updateSlidePosition(boolean isLeft, int position) {
        if (isLeft) {
            this.setSlideBackPosition(this.mSlideBackIconViewLeft, position);
        } else {
            this.setSlideBackPosition(this.mSlideBackIconViewRight, position);
        }
    }
}

